<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();
?>

<div class="fat-sb-head">
    <h4 class="fat-sb-title"><?php echo esc_html($setting['step_category_title']);?></h4>
    <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_category_subtitle']);?></div>
</div>
<div class="fat-sb-item-inner-wrap category-step step-item flex-center">

</div>
<div class="fat-sb-go-back text-center">
    <a href="javascript:" data-onclick="RevyBookingFlow.goBackBrandStep" data-prevent-event="1">
        <i class="arrow left icon"></i><?php echo esc_html__('Change Brand Type','revy');?></a>
</div>

<?php if(isset($setting['enable_quote_form']) && $setting['enable_quote_form']=='1' && isset($setting['quote_form_page']) && $setting['quote_form_page']):
    $quote_page = get_permalink($setting['quote_form_page']);
    ?>
    <div class="fat-quote-link text-center fat-mg-top-30">
        <?php echo esc_html__('If you cannot see your model type listed here please use our ','revy');?><a href="<?php echo esc_url($quote_page);?>"> <?php echo esc_html__('Quote Form','revy');?></a>
    </div>
<?php endif; ?>

<script type="text/html" id="tmpl-fat-category-item-template">
    <# _.each(data, function(item){ #>
    <div class="fat-sb-item fat-align-center fat-on-click"
         data-cat-id="{{item.c_id}}" data-name="{{item.c_name}}"
         data-onClick="RevyBookingFlow.categoryOnClick">
        <div class="fat-it-inner">
            <img src="{{item.c_image_url}}">
            <div class="item-title">
                {{item.c_name}}
            </div>
        </div>
    </div>
    <# }) #>
</script>