<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();

$db = Revy_DB_Devices::instance();
$devices = $db->get_devices(1);

$brand_label = isset($setting['brand_label']) && $setting['brand_label'] ? $setting['brand_label'] : esc_html__('Choose your brand', 'revy');
$model_label = isset($setting['model_label']) && $setting['model_label'] ? $setting['model_label'] : esc_html__('Choose your model', 'revy');
$category_label = isset($setting['choose_category_title']) && $setting['choose_category_title'] ? $setting['choose_category_title'] : esc_html__('Choose category', 'revy');

$group_label = isset($setting['group_label']) && $setting['group_label'] ? $setting['group_label'] : esc_html__('Choose group', 'revy');

$deviceOnClick = !isset($atts['layout']) || $atts['layout'] != 'brand-model' ? 'RevyBookingFlow.deviceOnClick' : 'RevyBookingFlow.deviceBrandModelStepOnClick';
$service_types = isset($setting['service_types']) && $setting['service_types'] ? explode(',', $setting['service_types']) : array();
?>

<div class="fat-sb-head">
    <h4 class="fat-sb-title"><?php echo esc_html($setting['step_device_title']); ?></h4>
    <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_device_subtitle']); ?></div>
</div>
<div class="fat-sb-item-inner-wrap device-step step-item flex-center">
    <?php foreach ($devices as $dv) { ?>
        <div class="fat-sb-item fat-align-center fat-on-click"
             data-device-id="<?php echo esc_attr($dv->rd_id); ?>"
             data-onClick="<?php echo esc_attr($deviceOnClick); ?>">
            <div class="fat-it-inner">
                <img src="<?php echo esc_attr($dv->rd_image_url); ?>">
                <div class="item-title"><?php echo esc_html($dv->rd_name); ?></div>
            </div>

        </div>
    <?php } ?>


</div>
<?php if (!isset($atts['layout']) || $atts['layout'] != 'brand-model'): ?>
    <div class="brand-model-step step-item">
        <div class="step-item-inner">
            <div class="fat-sb-col-left">
                <div class="fat-sb-item fat-align-center">

                </div>
            </div>
            <div class="fat-sb-col-right">
                <h5><?php echo esc_html__('Just a few more details', 'revy'); ?></h5>

                <div class="field brand-field">
                    <div class="field-inner">
                        <label class="fat-fw-400"><?php echo esc_html($brand_label); ?></label>
                        <div class="ui fluid search   selection dropdown brands"
                             data-onChange="RevyBookingFlow.brandOnChange">
                            <input type="hidden" name="b_brand_id" id="b_brand_id"
                                   autocomplete="nope" value="">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="field category-field">
                    <div class="field-inner">
                        <label class="fat-fw-400"><?php echo esc_html($category_label); ?></label>
                        <div class="ui fluid search selection dropdown category clearable"
                             data-onChange="RevyBookingFlow.categoryOnChange">
                            <input type="hidden" name="b_cat_id" id="b_cat_id" autocomplete="nope">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="field model-field">
                    <div class="field-inner">
                        <label class="fat-fw-400"><?php echo esc_html($model_label); ?></label>
                        <div class="ui fluid search  selection dropdown models clearable"
                             data-onChange="RevyBookingFlow.modelOnChange">
                            <input type="hidden" name="b_model_id" id="b_model_id" autocomplete="nope">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">

                            </div>
                        </div>
                    </div>
                </div>

                <div class="field group-field">
                    <div class="field-inner">
                        <label class="fat-fw-400"><?php echo esc_html($group_label); ?></label>
                        <div class="ui fluid  selection dropdown groups clearable"
                             data-onChange="RevyBookingFlow.groupOnChange">
                            <input type="hidden" name="b_group" id="b_group" autocomplete="nope">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">

                            </div>
                        </div>
                    </div>
                </div>



                <div class="field service-type-field">
                    <div class="field-inner">
                        <label class="fat-fw-400"><?php echo esc_html__('Service type','revy'); ?></label>
                        <div class="ui fluid  selection dropdown service-types clearable"
                             data-onChange="RevyBookingFlow.serviceTypeOnChange">
                            <input type="hidden" name="b_service_types" id="b_service_types" autocomplete="nope">
                            <i class="dropdown icon"></i>
                            <div class="default text"></div>
                            <div class="menu">
                                <?php foreach($service_types as $type){ ?>
                                    <div class="item"
                                         data-value="<?php echo trim($type);?>"><?php echo trim($type);?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="fat-sb-go-back">
                    <a href="javascript:" data-onclick="RevyBookingFlow.goBackDevice" data-prevent-event="1">
                        <i class="arrow left icon"></i><?php echo esc_html__('Change Device Type', 'revy'); ?></a>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if (isset($setting['enable_quote_form']) && $setting['enable_quote_form'] == '1' && isset($setting['quote_form_page']) && $setting['quote_form_page']):
    $quote_page = get_permalink($setting['quote_form_page']);
    ?>
    <div class="fat-quote-link text-center fat-mg-top-30">
        <?php echo esc_html__('If you cannot see your product type listed here please use our ', 'revy'); ?><a
                href="<?php echo esc_url($quote_page); ?>"> <?php echo esc_html__('Quote Form', 'revy'); ?></a>
    </div>
<?php endif; ?>
