<?php
$setting_db = Revy_DB_Setting::instance();
$setting = $setting_db->get_setting();

$model_db = Revy_DB_Models::instance();
$colors = $model_db->get_color();
$colors = isset($colors['colors']) ? $colors['colors'] : array();
?>

<div class="fat-sb-head">
    <h4 class="fat-sb-title"><?php echo esc_html($setting['step_model_title']);?></h4>
    <div class="fat-sb-subtitle"><?php echo esc_html($setting['step_model_subtitle']);?></div>

    <div class="fat-search-box">
        <div class="ui transparent left icon input ui-search fat-sb-search fat-no-margin">
            <input type="text" id="model_key" data-type="model" placeholder="<?php echo esc_attr('Search model name ...','revy');?>" data-onkeyup="RevyBookingFlow.searchNameOnKeyUp" autocomplete="nope">
            <i class="search icon"></i>
            <a class="fat-close" data-onclick="RevyBookingFlow.closeSearchOnClick">
                <i class="times icon"></i>
            </a>
        </div>
    </div>
</div>
<div class="fat-sb-item-inner-wrap model-step step-item flex-center">

</div>
<div class="fat-sb-go-back text-center">
    <?php if (isset($atts['hide_model_category']) && $atts['hide_model_category'] == '1'): ?>
        <a href="javascript:" data-onclick="RevyBookingFlow.goBackBrandStep" data-prevent-event="1">
            <i class="arrow left icon"></i><?php echo esc_html__('Change Brand Type','revy');?></a>
    <?php else: ?>
        <a href="javascript:" data-onclick="RevyBookingFlow.goBackCategoryStep" data-prevent-event="1">
            <i class="arrow left icon"></i><?php echo esc_html__('Change Category','revy');?></a>
    <?php endif; ?>
</div>

<?php if(isset($setting['enable_quote_form']) && $setting['enable_quote_form']=='1' && isset($setting['quote_form_page']) && $setting['quote_form_page']):
    $quote_page = get_permalink($setting['quote_form_page']);
    ?>
    <div class="fat-quote-link text-center fat-mg-top-30">
        <?php echo esc_html__('If you cannot see your model type listed here please use our ','revy');?><a href="<?php echo esc_url($quote_page);?>"> <?php echo esc_html__('Quote Form','revy');?></a>
    </div>
<?php endif; ?>

<script type="text/html" id="tmpl-fat-model-item-template">
    <# _.each(data, function(item){ #>
    <div class="fat-sb-item fat-align-center fat-on-click"
         data-model-id="{{item.rm_id}}" data-name="{{item.rm_name}}"
         data-onClick="RevyBookingFlow.modelOnClick">
        <div class="fat-it-inner">
            <img src="{{item.rm_image_url}}">
            <div class="item-title">{{item.rm_name}}</div>
        </div>
    </div>
    <# }) #>
</script>


<script type="text/html" id="tmpl-fat-sb-popup-color-template">
    <div class="ui modal tiny fat-semantic-container fat-sb-color-list">
        <div class="header fat-sb-popup-title" ><?php echo esc_html__('Select color for','revy'); ?>&nbsp;<span class="fat-model-name"></span></div>
        <div class="scrolling content">
            <div class="fat-list-color">
                <?php foreach($colors as $c){ ?>
                    <div class="color-item color-<?php echo esc_attr($c->rc_id);?>" data-name="<?php echo esc_attr($c->rc_name);?>">
                        <div class="color-item-inner">
                            <div class="color-thumb"><img src="<?php echo esc_url($c->rc_image_url);?>"></div>
                            <div class="color-name"><?php echo esc_html($c->rc_name);?></div>
                        </div>
                    </div>
                <?php } ?>
            </div>

        </div>
        <div class="actions">
            <button class="ui basic button fat-close-modal">
                <i class="times circle outline icon"></i>
                <?php echo esc_html__('Close','revy'); ?>
            </button>
        </div>
    </div>
</script>
