<?php

namespace Salon\Util;

class Date {
	/** @var  \DateTime */
	private $dateTime;

	public function __construct( $date ) {
		if ( $date instanceof \DateTime || $date instanceof \DateTimeImmutable ) {
			$timestamp = $date->getTimestamp();
			$timezone = $date->getTimezone();
			$date = new \SLN_DateTime();
			$date->setTimestamp($timestamp);
			$date->setTimezone($timezone);
		} elseif(is_string($date)) {
			$date = new \SLN_DateTime( $date );
		} elseif($date instanceof self) {
			$date = $date->dateTime;
		}else{
			throw new \Exception('bad object for date '.esc_html(get_class($date)));
		}
		$this->dateTime = $date;
		$this->dateTime->setTime( 0, 0 );
	}

	public function getDateTime() {
		return clone $this->dateTime;
	}

	/**
	 * @return int
	 */
	public function getWeekday() {
		return intval($this->dateTime->format( "w" ));
	}

	public function getWeekdayName(){
		return $this->dateTime->format('D');
	}

	public function isGt( Date $date ) {
		return $this->dateTime > $date->dateTime;
	}

	public function isLt( Date $date ) {
		return $this->dateTime < $date->dateTime;
	}

	public function isLte( Date $date ) {
		return $this->dateTime <= $date->dateTime;
	}

	public function isEq( Date $date ) {
		return $this->dateTime == $date->dateTime;
	}

	public function toString(){
		return $this->dateTime->format( 'Y-m-d' );
	}

	/**
	 * @return Date
	 */
	public function getPrevDate() {
		return new self( $this->getDateTime()->modify( '-1 day' ) );
	}

	/**
	 * @return Date
	 */
	public function getNextDate() {
		return new self( $this->getDateTime()->modify( '+1 day' ) );
	}

	/**
	 * @param $date
	 *
	 * @return Date
	 */
	public static function create( $date ) {
		return new Date( $date );
	}
}