<?php

/**
 * Admin Assets.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'FP_SD_Admin_Assets' ) ) {

	/**
	 * Class.
	 */
	class FP_SD_Admin_Assets {

		/**
		 * Suffix.
		 * 
		 * @var string
		 */
		private static $suffix ;

		/**
		 * Class Initialization.
		 */
		public static function init() {
			self::$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ;

			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_js_files' ) ) ;
			add_action( 'admin_enqueue_scripts', array( __CLASS__, 'external_css_files' ) ) ;
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_css_files() {
			if ( isset( $_GET[ 'page' ] ) && 'sumodiscounts' == $_GET[ 'page' ] ) {
				wp_register_style( 'sweetalert2', FP_SD_PLUGIN_URL . '/js/sweetalert2/sweetalert2.min.css', array(), FP_SD_VERSION ) ;
				wp_enqueue_style( 'css-sweet-alert' ) ;
				wp_register_style( 'admin', FP_SD_PLUGIN_URL . '/css/admin/admin.css', array('wc-admin-layout'), FP_SD_VERSION ) ;
				wp_enqueue_style( 'admin' ) ;
			}
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_js_files() {
			global $woocommerce ;

			wp_enqueue_script( 'jquery' ) ;
			wp_enqueue_script( 'jquery-ui-sortable' ) ;
			wp_enqueue_script( 'jquery-ui-datepicker' ) ;
			wp_register_script( 'fpsd_date_picker_enhanced', FP_SD_PLUGIN_URL . '/js/sp_datepicker.js', array( 'jquery', 'jquery-ui-datepicker' ), FP_SD_VERSION ) ;
			wp_register_script( 'admin-rule', FP_SD_PLUGIN_URL . '/js/admin/admin-rule.js', array( 'jquery' ), FP_SD_VERSION ) ;

			wp_localize_script( 'admin-rule', 'admin_rule', array(
				'ajax_url'       => FP_SD_ADMIN_AJAX_URL,
				'title'          => __( 'Untitled', 'sumodiscounts' ),
				'add_rule_nonce' => wp_create_nonce( 'sumo-discounts-rule-nonce' ),
			) ) ;
			wp_enqueue_script( 'admin-rule' ) ;
						wp_enqueue_script( 'fpsd_date_picker_enhanced' ) ;


			wp_register_script( 'admin-general', FP_SD_PLUGIN_URL . '/js/admin/admin-general.js', array( 'jquery' ), FP_SD_VERSION ) ;

			// register ui script
			wp_enqueue_script( 'jquery-ui-accordion' ) ;
			if ( isset( $_GET[ 'page' ] ) && 'sumodiscounts' == wc_clean( wp_unslash( $_GET[ 'page' ] ) ) ) {
				wp_register_script( 'sweetalert2', FP_SD_PLUGIN_URL . '/js/sweetalert2/sweetalert2.min.js', array( 'jquery' ), FP_SD_VERSION ) ;
				wp_enqueue_script( 'jquery-sweet-alert' ) ;
			}

			if ( isset( $_GET[ 'tab' ] ) ) {
				switch ( wc_clean( wp_unslash( $_GET[ 'tab' ] ) ) ) {
					case 'sumo_quantity_pricing':
						wp_register_script( 'admin-quantity-pricing', FP_SD_PLUGIN_URL . '/js/admin/admin-quantity-price.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_localize_script( 'admin-quantity-pricing', 'admin_quantity_price', array(
							'ajax_url'               => FP_SD_ADMIN_AJAX_URL,
							'quantity_pricing_nonce' => wp_create_nonce( 'sumo-discounts-rule-nonce' ),
						) ) ;
						wp_enqueue_script( 'admin-quantity-pricing' ) ;
						break ;
					case 'sumo_cart_pricing':
						wp_register_script( 'admin-cart-pricing', FP_SD_PLUGIN_URL . '/js/admin/admin-cart-price.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_localize_script( 'admin-cart-pricing', 'admin_cart_price', array(
							'ajax_url'           => FP_SD_ADMIN_AJAX_URL,
							'cart_pricing_nonce' => wp_create_nonce( 'sumo-discounts-rule-nonce' ),
						) ) ;
						wp_enqueue_script( 'admin-cart-pricing' ) ;
						break ;
					case 'sp_general_settings':
						wp_register_script( 'admin-general-settings', FP_SD_PLUGIN_URL . '/js/admin/admin-general-settings.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_localize_script( 'admin-general-settings', 'admin_general_settings', array(
							'ajax_url'      => FP_SD_ADMIN_AJAX_URL,
							'arrange_nonce' => wp_create_nonce( 'sumo-discounts-arrange-nonce' ),
						) ) ;
						wp_enqueue_script( 'admin-general-settings' ) ;
						break ;
					case 'fp_sp_message_tab':
						wp_register_script( 'admin-messages', FP_SD_PLUGIN_URL . '/js/admin/admin-messages.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_enqueue_script( 'admin-messages' ) ;
						break ;
					case 'fp_sp_rpelpricing':
						wp_register_script( 'admin-rewardpoints-pricing', FP_SD_PLUGIN_URL . '/js/admin/admin-rewardpoints-price.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_localize_script( 'admin-rewardpoints-pricing', 'admin_rewardpoints_price', array(
							'wc_version'                 => ( float ) $woocommerce->version,
							'ajax_url'                   => FP_SD_ADMIN_AJAX_URL,
							'rewardpoints_pricing_nonce' => wp_create_nonce( 'sumo-discounts-rule-nonce' ),
						) ) ;

						wp_enqueue_script( 'admin-rewardpoints-pricing' ) ;
						break ;
					case 'sumo_offer_pricing':
						wp_register_script( 'admin-offer-pricing', FP_SD_PLUGIN_URL . '/js/admin/admin-offer-price.js', array( 'jquery' ), FP_SD_VERSION ) ;
						wp_localize_script( 'admin-offer-pricing', 'admin_offer_price', array(
							'ajax_url'            => FP_SD_ADMIN_AJAX_URL,
							'offer_pricing_nonce' => wp_create_nonce( 'sumo-discounts-rule-nonce' ),
						) ) ;
						wp_enqueue_script( 'admin-offer-pricing' ) ;
						break ;
				}
			}
		}

	}

	FP_SD_Admin_Assets::init() ;
}
