<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}

if ( ! class_exists( 'SUMOFunctionalityForGS' ) ) {

	class SUMOFunctionalityForGS {

		// Construct the Class
		public function __construct() {
			add_action( 'woocommerce_admin_field_drag_and_drop_rule_priority', array( $this, 'set_drag_and_drop_rule_priority' ) ) ;
			add_action( 'woocommerce_update_options_sp_general_settings', array( $this, 'save_set_drag_and_drop_rule_priority' ) ) ;
			add_action( 'wp_ajax_sumo_drag_and_arrange_tab', array( $this, 'admin_request_from_ajax_sortable_for_general' ) ) ;
		}

		public static function set_drag_and_drop_rule_priority() {
			global $woocommerce_settings ;

			$tabs         = '' ;
			$tabs         = apply_filters( 'woocommerce_sp_settings_tabs_array', $tabs ) ;
			$exclude_tabs = array( 'sp_general_settings', 'fp_sp_message_tab', 'sumo_quantity_pricing', 'sumo_offer_pricing', 'sumo_cart_pricing', 'fp_sp_advanced_tab', 'sumo_help' ) ;

			$priority_array                       = array_diff( array_keys( $tabs ), $exclude_tabs ) ;
			$get_data_rule_priority_check_for_swd = ( array ) get_option( 'drag_and_drop_rule_priority_for_site_wide_discounts', true ) ;
			$difference_array                     = array_diff( $priority_array, array_values( $get_data_rule_priority_check_for_swd ) ) ;
			$newmergedvalue                       = array_merge( $get_data_rule_priority_check_for_swd, $difference_array ) ;
			$priority_array                       = is_array( $difference_array ) && ! empty( $difference_array ) ? $newmergedvalue : $get_data_rule_priority_check_for_swd ;
			$priority_array                       = array_diff( $priority_array, $exclude_tabs ) ;

			$exclude_tabs1                       = array( 'sp_general_settings', 'fp_sp_message_tab', 'sumo_cart_pricing', 'fp_sp_rpelpricing', 'sumo_cat_pro_pricing', 'fp_sp_advanced_tab', 'sumo_help' ) ;
			$priority_array1                     = array_diff( array_keys( $tabs ), $exclude_tabs1 ) ;
			$get_data_rule_priority_check_for_bd = ( array ) get_option( 'drag_and_drop_rule_priority_for_bulk_discounts', true ) ;
			$difference_array1                   = array_diff( $priority_array1, array_values( $get_data_rule_priority_check_for_bd ) ) ;
			$newmergedvalue1                     = array_merge( $get_data_rule_priority_check_for_bd, $difference_array1 ) ;
			$priority_array1                     = is_array( $difference_array1 ) && ! empty( $difference_array1 ) ? $newmergedvalue1 : $get_data_rule_priority_check_for_bd ;
			$priority_array1                     = array_diff( $priority_array1, $exclude_tabs1 ) ;
			?>

			<table class="form-table" id="sumo_drag_n_drop_site_wide_discounts">
				<thead>
					<tr>
				<span><b><?php esc_html_e( 'Sitewide Discounts', 'sumodiscounts' ) ; ?></b></span>
				<span class="sumo_site_wide_discount">
					<select id="sumo_site_wide_discounts" name="sumo_site_wide_discounts">
						<option value="1" <?php selected( get_option( 'sumo_site_wide_discounts', true ), '1' ) ; ?> ><?php esc_html_e( 'First Matched Rule', 'sumodiscounts' ) ; ?></option>
						<option value="2" <?php selected( get_option( 'sumo_site_wide_discounts', true ), '2' ) ; ?> ><?php esc_html_e( 'Last Matched Rule', 'sumodiscounts' ) ; ?></option>
						<option value="3" <?php selected( get_option( 'sumo_site_wide_discounts', true ), '3' ) ; ?> ><?php esc_html_e( 'Minimum Discount', 'sumodiscounts' ) ; ?></option>
						<option value="4" <?php selected( get_option( 'sumo_site_wide_discounts', true ), '4' ) ; ?> ><?php esc_html_e( 'Maximum Discount', 'sumodiscounts' ) ; ?></option>
					</select>
				</span>
			</tr>
			</thead>
			<?php
			foreach ( $priority_array as $key ) {
				if ( isset( $tabs[ $key ] ) ) {
					?>
					<tbody class="sumo_pricing_tab_drag_n_drop" id="<?php echo esc_attr( $key ) ; ?>">
						<tr class="table1 <?php echo esc_attr( $key ) ; ?>">
							<td class="sumo_pricing_tab_sorting"><?php echo esc_html( $tabs[ $key ] ) ; ?></td>
							<td><input type="checkbox" id="<?php echo esc_attr( $key ) ; ?>" name="sumo_pricing_tab_sorting[<?php echo esc_attr( $key ) ; ?>]" value="yes" 
								<?php
								$get_option = get_option( 'sumo_pricing_tab_sorting' ) ;
								$get_key    = isset( $get_option[ $key ] ) ? $get_option[ $key ] : '' ;
								if ( 'yes' == $get_key ) {
									?>
										   checked
										   <?php
								}
								?>
									   > <?php esc_html_e( 'Enable', 'sumodiscounts' ) ; ?></td>
						</tr>
					</tbody>
					<?php
				}
			}
			?>
			</table>
			<br>
			<br>
			<br>
			<table class="form-table" id="sumo_drag_n_drop_bulk_discounts">
				<thead>
					<tr>
				<span><b><?php esc_html_e( 'Bulk Discounts', 'sumodiscounts' ) ; ?></b></span>
				<span class="sumo_bulk_discounts"><select id="sumo_bulk_discounts" name="sumo_bulk_discounts">
						<option value="1" <?php selected( get_option( 'sumo_bulk_discounts', true ), '1' ) ; ?> ><?php esc_html_e( 'First Matched Rule', 'sumodiscounts' ) ; ?></option>
						<option value="2" <?php selected( get_option( 'sumo_bulk_discounts', true ), '2' ) ; ?> ><?php esc_html_e( 'Last Matched Rule', 'sumodiscounts' ) ; ?></option>
						<option value="3" <?php selected( get_option( 'sumo_bulk_discounts', true ), '3' ) ; ?> ><?php esc_html_e( 'Minimum Discount', 'sumodiscounts' ) ; ?></option>
						<option value="4" <?php selected( get_option( 'sumo_bulk_discounts', true ), '4' ) ; ?> ><?php esc_html_e( 'Maximum Discount', 'sumodiscounts' ) ; ?></option>
					</select></span></tr>
			</thead>
			<?php
			foreach ( $priority_array1 as $key ) {
				if ( isset( $tabs[ $key ] ) ) {
					?>
					<tbody class="sumo_pricing_tab_drag_n_drop" id="<?php echo esc_attr( $key ) ; ?>">
						<tr class="table1 <?php echo esc_attr( $key ) ; ?>">
							<td class="sumo_pricing_tab_sorting"><?php echo esc_html( $tabs[ $key ] ) ; ?></td>
							<td><input type="checkbox" id="<?php echo esc_attr( $key ) ; ?>" name="sumo_pricing_tab_sorting[<?php echo esc_attr( $key ) ; ?>]" value="yes" 
								<?php
								$get_option = get_option( 'sumo_pricing_tab_sorting' ) ;
								$get_key    = isset( $get_option[ $key ] ) ? $get_option[ $key ] : '' ;
								if ( 'yes' == $get_key ) {
									?>
										   checked
										   <?php
								}
								?>
									   > <?php esc_html_e( 'Enable', 'sumodiscounts' ) ; ?></td>
						</tr>
					</tbody>
					<?php
				}
			}
			?>
			</table>
			<br>
			<br>
			<br>
			<table class="form-table" id="sumo_drag_n_drop_cart_discounts">
				<thead>
					<tr><span><b><?php esc_html_e( 'Cart Discounts', 'sumodiscounts' ) ; ?></b></span>
			</tr>
			</thead>
			<tbody class="sumo_pricing_tab_drag_n_drop" id="sumo_cart_pricing">
				<tr class="table1 sumo_cart_pricing">
					<td class="sumo_pricing_tab_sorting"><?php echo esc_html( $tabs[ 'sumo_cart_pricing' ] ) ; ?></td>
					<td><input type="checkbox" id="sumo_cart_pricing" name="sumo_pricing_tab_sorting[sumo_cart_pricing]" value="yes" 
							   <?php
								$get_option = get_option( 'sumo_pricing_tab_sorting' ) ;
								$get_key    = isset( $get_option[ 'sumo_cart_pricing' ] ) ? $get_option[ 'sumo_cart_pricing' ] : '' ;
								if ( 'yes' == $get_key ) {
									?>
								   checked
									<?php
								}
								?>
							   > <?php esc_html_e( 'Enable', 'sumodiscounts' ) ; ?></td>
				</tr>
			</tbody>
			</table>
			<?php
		}

		public static function admin_request_from_ajax_sortable_for_general() {
			check_ajax_referer( 'sumo-discounts-arrange-nonce', 'sumo_discount_security' ) ;

			if ( isset( $_REQUEST[ 'type' ] ) && isset( $_REQUEST[ 'data' ] ) ) {
				if ( 'sitewide' == wc_clean( wp_unslash( $_REQUEST[ 'type' ] ) ) ) {
					update_option( 'drag_and_drop_rule_priority_for_site_wide_discounts', wc_clean( wp_unslash( $_REQUEST[ 'data' ] ) ) ) ;
				} elseif ( 'bulk' == wc_clean( wp_unslash( $_REQUEST[ 'type' ] ) ) ) {
					update_option( 'drag_and_drop_rule_priority_for_bulk_discounts', wc_clean( wp_unslash( $_REQUEST[ 'data' ] ) ) ) ;
				}
			}
			exit() ;
		}

		public static function save_set_drag_and_drop_rule_priority() {
			update_option( 'sumo_site_wide_discounts', isset( $_REQUEST[ 'sumo_site_wide_discounts' ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'sumo_site_wide_discounts' ] ) ) : array()  ) ;
			update_option( 'sumo_bulk_discounts', isset( $_REQUEST[ 'sumo_bulk_discounts' ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'sumo_bulk_discounts' ] ) ) : array()  ) ;
			update_option( 'sumo_pricing_tab_sorting', isset( $_REQUEST[ 'sumo_pricing_tab_sorting' ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'sumo_pricing_tab_sorting' ] ) ) : array()  ) ;
		}

	}

	new SUMOFunctionalityForGS() ;
}
