<?php
/**
 * Compatibility Instances Class.
 *
 * @since 6.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'FPSD_Compatibility_Instances' ) ) {

	/**
	 * Class.
	 */
	class FPSD_Compatibility_Instances {

		/**
		 * Compatibilities.
		 * 
		 * @var array
		 * @since 6.4.0
		 * */
		private static $compatibilities;

		/**
		 * Get the compatibilities.
		 *
		 * @var array
		 * @since 6.4.0
		 */
		public static function instance() {
			if ( is_null( self::$compatibilities ) ) {
				self::$compatibilities = self::load_compatibilities();
			}

			return self::$compatibilities;
		}

		/**
		 * Load all Compatibilities.
		 * 
		 * @since 6.4.0
		 */
		public static function load_compatibilities() {
			if ( ! class_exists( 'FPSD_Compatibility' ) ) {
				include FP_SD_PLUGIN_PATH . '/inc/abstracts/abstract-fpsd-compatibility.php';
			}
			
			$default_compatibility_classes = array(
				'sumo-subscriptions'        => 'FPSD_Sumo_Subscriptions_Compatibility',
			);

			foreach ( $default_compatibility_classes as $file_name => $compatibility_class ) {
				// Include file.
				include 'class-' . $file_name . '.php';

				// Add compatibility.
				self::add_compatibility( new $compatibility_class() );
			}
		}

		/**
		 * Add a compatibility.
		 * 
		 * @since 6.4.0
		 */
		public static function add_compatibility( $compatibility ) {
			self::$compatibilities[ $compatibility->get_id() ] = $compatibility;
		}

		/**
		 * Get the compatibility by ID.
		 *
		 * @var object/bool
		 * @since 6.4.0
		 */
		public static function get_compatibility_by_id( $compatibility_id ) {
			$compatibilities = self::instance();

			return isset( $compatibilities[ $compatibility_id ] ) ? $compatibilities[ $compatibility_id ] : false;
		}
	}

}
