<?php
/**
 * Plugin Name: SUMO Discounts
 * Plugin URI:
 * Description: SUMO Discounts is a Complete WooCommerce Discount System
 * Version: 6.8.0
 * Author:Fantastic Plugins
 * Author URI:http://fantasticplugins.com/
 * Text Domain: sumodiscounts
 * Domain Path: /languages
 * Tested up to: 6.8.3
 * WC tested up to: 10.3.3
 *
 * @package Sumo Discounts
 */

if ( ! class_exists( 'SUMODiscounts' ) ) {
	/**
	 * Class SumoDiscounts
	 */
	class SUMODiscounts {

		/**
		 * SumoDiscounts Version
		 *
		 * @var String
		 */
		public $version = '6.8.0';

		/**
		 * Construct the class of SUMO Discounts
		 * */
		public function __construct() {
			// Avoid Fatal Error on SUMO Discounts.
			include_once ABSPATH . 'wp-admin/includes/plugin.php';

			$this->define_constants();
			$this->include_files();
                        $this->init_hooks();
			// Avoid Header Already Sent Problem by declaring that function in init hook.
			add_action( 'init', array( $this, 'avoid_header_already_sent_problem' ), 10 );

			// Init the active function to make sure woocommerce is active.
			add_action( 'init', array( $this, 'check_woocommerce_is_active' ) );

			// Screenids alteration.
			if ( isset( $_GET['page'] ) && ( 'sumodiscounts' == wp_unslash( $_GET['page'] ) ) ) {
				add_filter( 'woocommerce_screen_ids', array( $this, 'allow_css_from_woocommerce' ), 1 );
			}

			// Translate Ready Function initialize it in plugins_loaded hook.
			add_action( 'plugins_loaded', array( $this, 'translate_ready' ) );

			if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
				add_action( 'init', array( $this, 'sumo_include_file_for_frontend' ) );
				include_once 'inc/gdpr/class-fpsd-discount-privacy.php';
			}

			register_activation_hook( __FILE__, array( $this, 'update_drag_and_drop_options' ), 999 );
		}

		/**
		 * Check WooCommerce is Active or Not
		 */
		public static function check_woocommerce_is_active() {

			if ( is_multisite() ) {
				// This Condition is for Multi Site WooCommerce Installation.
				if ( ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) && ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) ) {
					if ( is_admin() ) {
						$variable = "<div class='error'><p> SUMO Discounts will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin. </p></div>";
						echo wp_kses_post( $variable );
					}
					return;
				}
			} else {
				// This Condition is for Single Site WooCommerce Installation.
				if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
					if ( is_admin() ) {
						$variable = "<div class='error'><p> SUMO Discounts will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin. </p></div>";
						echo wp_kses_post( $variable );
					}
					return;
				}
			}
		}

		/**
		 * Avoid Header Already Sent Problem
		 */
		public static function avoid_header_already_sent_problem() {
			ob_start();
		}

		/**
		 * Include files.
		 * 
		 * @since 6.4.0
		 * */
		private function include_files() {
			// Instances.
			include_once 'inc/compatibility/class-fpsd-compatibility-instances.php';
		}

		/**
		 *  Allow CSS from WooCommerce
		 */
		public static function allow_css_from_woocommerce() {
			global $my_admin_page;
			$array        = array();
			$newscreenids = get_current_screen();

			if ( isset( $_GET['page'] ) && ( 'sumodiscounts' == $_GET['page'] ) ) {
				$array[] = $newscreenids->id;
			}

			return $array;
		}

		/**
		 * Translate Ready
		 */
		public static function translate_ready() {
			load_plugin_textdomain( 'sumodiscounts', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
		}

		/**
		 * Prepare the Constants value array.
		 */
		private function define_constants() {
			$constant_array = array(
				'FP_SD_VERSION'          => $this->version,
				'FP_SD_PLUGIN_FILE'      => __FILE__,
				'FP_SD_PLUGIN_BASE_NAME' => plugin_basename( __FILE__ ),
				'FP_SD_PLUGIN_PATH'      => untrailingslashit( plugin_dir_path( __FILE__ ) ),
				'FP_SD_PLUGIN_URL'       => untrailingslashit( plugins_url( '/', __FILE__ ) ),
				'FP_SD_ADMIN_URL'        => admin_url( 'admin.php' ),
				'FP_SD_ADMIN_AJAX_URL'   => admin_url( 'admin-ajax.php' ),
			);
			$constant_array = apply_filters( 'fp_sd_define_constants', $constant_array );

			if ( is_array( $constant_array ) && ! empty( $constant_array ) ) {
				foreach ( $constant_array as $name => $value ) {
					$this->define_constant( $name, $value );
				}
			}
		}

		/**
		 * Define the Constants value.
		 *
		 * @since 1.0
		 * @param String $name Constant Name.
		 * @param String $value Constant Value.
		 */
		private function define_constant( $name, $value ) {
			if ( ! defined( $name ) ) {
				define( $name, $value );
			}
		}
                
                /**
		 * Define the hooks.
                 * @since 6.1.0
		 * */
		private function init_hooks() {
			//Compatibility with WC HPOS.
			add_action('before_woocommerce_init', array($this, 'declare_compatibility_with_hpos'));
			// Plugins loaded.
			add_action('plugins_loaded', array( $this, 'plugins_loaded' ));
                }
                
                /*
		 * Declare compatibility with HPOS.
		 * @since 6.1.0
		 * 
		 * @return void
		 */
		public function declare_compatibility_with_hpos() {
			if (class_exists(\Automattic\WooCommerce\Utilities\FeaturesUtil::class)) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
			}
		}

		/**
		 * Plugins Loaded.
		 * 
		 * @since 6.4.0
		 * */
		public function plugins_loaded() {
			// Compatibilities.
			FPSD_Compatibility_Instances::instance();
		}
                               
		/**
		 * Include Files
		 *
		 * @since 1.0
		 */
		public static function sumo_include_file_for_frontend() {
			include_once 'admin/class-fpsd-admin-menu.php';
			include_once 'admin/class-fpsd-admin-assets.php';
			include_once 'inc/class-fpsd-frontend-assets.php';
			include_once 'inc/fpsd-common-functions.php';
			include_once 'inc/fpsd-get-applied-discount-rule.php';
			include_once 'inc/fpsd-main-functions-for-sumodiscount.php';
			include_once 'inc/quantitypricing/class-fpsd-quantity-pricing-tab.php';
			include_once 'inc/carttotalpricing/class-fpsd-cart-total-pricing-tab.php';
			include_once 'inc/specialofferpricing/class-fpsd-specialofferpricing-tab.php';

			if ( class_exists( 'FPRewardSystem' ) ) {
				include_once 'inc/rewardpointpricing/class-fpsd-rewardpointspricing-tab.php';
			}

			include_once 'inc/categoryproductpricing/class-fpsd-category-discount.php';
			include_once 'inc/categoryproductpricing/class-fpsd-categoryproductpricing-tab.php';
			include_once 'inc/class-fpsd-query.php';
		}

		/**
		 * Update Drag and drop Options
		 *
		 * @since 1.0
		 */
		public static function update_drag_and_drop_options() {
			add_option(
				'drag_and_drop_rule_priority_for_site_wide_discounts',
				array(
					'0' => 'fp_sp_userrole_pricing_settings',
					'1' => 'sumo_cat_pro_pricing',
					'3' => 'fp_sp_rpelpricing',
				)
			);

			$sitewide_priority = get_option( 'drag_and_drop_rule_priority_for_site_wide_discounts' );

			if ( ! in_array( 'sumo_cat_pro_pricing', $sitewide_priority ) ) {
				$new_array = array_merge( $sitewide_priority, array( 'sumo_cat_pro_pricing' ) );
				update_option( 'drag_and_drop_rule_priority_for_site_wide_discounts', $new_array );
			}

			add_option(
				'drag_and_drop_rule_priority_for_bulk_discounts',
				array(
					'0' => 'sumo_quantity_pricing',
					'1' => 'sumo_offer_pricing',
				)
			);

			add_option( 'sp_cart_discount_fees_label', 'Cart Discount' );
		}

	}
	new SUMODiscounts();

}

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}