/* global fp_donation_admin_params, ajaxurl */

jQuery( function ( $ ) {
	'use strict' ;

	if ( typeof fp_donation_admin_params === 'undefined' ) {
		return false ;
	}

	var FP_Donation_Admin = {
		init : function ( ) {
			// General Tab.
			// Trigger product type.
			$( document ).on( 'change' , '#_fp_donation_product_selection' , this.trigger_donation_product_type ) ;
			// Create a donation product.
			$( document ).on( 'click' , '.fp_donation_new_product' , this.create_donation_product ) ;

			// Donation Form Tab.
			$( document ).on( 'change' , '#_fp_show_donation_form_in_product' , this.trigger_donation_form_product_selection ) ;
			$( document ).on( 'change' , '.fp-donation-form-type-product' , this.trigger_donation_form_type_product ) ;
			$( document ).on( 'change' , '.fp-donation-form-type-cart' , this.trigger_donation_form_type_cart ) ;
			$( document ).on( 'change' , '.fp-donation-form-type-checkout' , this.trigger_donation_form_type_checkout ) ;
			$( document ).on( 'change' , '.fp-donation-form-type-shortcode' , this.trigger_donation_form_type_shortcode ) ;

			// Fly Box Tab.
			$( document ).on( 'change' , '.fp-donation-form-type-flybox' , this.trigger_donation_form_type_flybox ) ;

			// Automatic Donation Tab.
			// Trigger a automatic donation product selection.
			$( document ).on( 'change' , '#_fp_donation_product_selection_automatic' , this.trigger_automatic_donation_product_selection ) ;
			// Trigger automatic product type.
			$( document ).on( 'change' , '#_fp_donation_automatic_product_type' , this.trigger_automatic_product_type ) ;
			// Trigger a user restriction.
			$( document ).on( 'change' , '#_fp_automatic_donation_value' , this.trigger_automatic_donation_value ) ;
			// Create a automatic donation product.
			$( document ).on( 'click' , '.fp_donation_new_product_automatic' , this.create_automatic_donation_product ) ;

			// Donation Rewards Tab.
			// Add a reward rule.
			$( document ).on( 'click' , '.fp-donation-add-reward-rule' , this.add_reward_rule ) ;
			// Remove a reward rule.
			$( document ).on( 'click' , '.fp-donation-remove-reward-rule' , this.remove_reward_rule ) ;

			// Reset Tab.
			// Reset all settings data.
			$( document ).on( 'click' , '#fp_reset_settings_data' , this.reset_settings_data ) ;

			this.trigger_on_page_load( ) ;

		} , trigger_on_page_load : function ( ) {
			// General Tab.
			FP_Donation_Admin.donation_product_type( "#_fp_donation_product_selection" ) ;

			// Donation Form Tab.
			FP_Donation_Admin.donation_form_product_selection( "#_fp_show_donation_form_in_product" ) ;
			FP_Donation_Admin.donation_form_type_product( ".fp-donation-form-type-product" ) ;
			FP_Donation_Admin.donation_form_type_cart( ".fp-donation-form-type-cart" ) ;
			FP_Donation_Admin.donation_form_type_checkout( ".fp-donation-form-type-checkout" ) ;
			FP_Donation_Admin.donation_form_type_shortcode( ".fp-donation-form-type-shortcode" ) ;

			// Donation Form Tab.
			FP_Donation_Admin.donation_form_type_flybox( ".fp-donation-form-type-flybox" ) ;

			// Automatic Donation Tab.
			FP_Donation_Admin.automatic_donation_product_selection( "#_fp_donation_product_selection_automatic" ) ;
			FP_Donation_Admin.automatic_product_type( "#_fp_donation_automatic_product_type" ) ;
			FP_Donation_Admin.automatic_donation_value( "#_fp_automatic_donation_value" ) ;

		} , trigger_donation_product_type : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_product_type( $this ) ;
		} , trigger_donation_form_product_selection : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_product_selection( $this ) ;
		} , trigger_donation_form_type_product : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_type_product( $this ) ;
		} , trigger_donation_form_type_cart : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_type_cart( $this ) ;
		} , trigger_donation_form_type_checkout : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_type_checkout( $this ) ;
		} , trigger_donation_form_type_shortcode : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_type_shortcode( $this ) ;
		} , trigger_donation_form_type_flybox : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.donation_form_type_flybox( $this ) ;
		} , trigger_automatic_donation_product_selection : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.automatic_donation_product_selection( $this ) ;
		} , trigger_automatic_product_type : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.automatic_product_type( $this ) ;
		} , trigger_automatic_donation_value : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;

			FP_Donation_Admin.automatic_donation_value( $this ) ;
		} , donation_product_type : function ( $this ) {

			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp_donation_new_product' ).closest( 'tr' ).show() ;
					$( '#_fp_donation_new_product_title' ).closest( 'tr' ).show() ;
					$( '#ds_select_particular_products' ).closest( 'tr' ).hide() ;
					break ;
				default:
					$( '.fp_donation_new_product' ).closest( 'tr' ).hide() ;
					$( '#_fp_donation_new_product_title' ).closest( 'tr' ).hide() ;
					$( '#ds_select_particular_products' ).closest( 'tr' ).show() ;
					break ;
			}

		} , donation_form_product_selection : function ( $this ) {
			switch ( $( $this ).val() ) {
				case '2':
					$( '#_fp_donation_form_included_selected_products' ).closest( 'tr' ).show() ;
					$( '#_fp_donation_form_excluded_selected_products' ).closest( 'tr' ).hide() ;
					break ;
				case '3':
					$( '#_fp_donation_form_included_selected_products' ).closest( 'tr' ).hide() ;
					$( '#_fp_donation_form_excluded_selected_products' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '#_fp_donation_form_included_selected_products' ).closest( 'tr' ).hide() ;
					$( '#_fp_donation_form_excluded_selected_products' ).closest( 'tr' ).hide() ;
					break ;
			}

		} , donation_form_type_product : function ( $this ) {
			$( '.fp-donation-form-type-product-field' ).closest( 'tr' ).hide() ;
			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp-donation-form-type-product-button-field' ).closest( 'tr' ).show() ;
					break ;
				case '3':
					$( '.fp-donation-form-type-product-list-field' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp-donation-form-type-product-edit-field' ).closest( 'tr' ).show() ;
					break ;
			}

		} , donation_form_type_cart : function ( $this ) {
			$( '.fp-donation-form-type-cart-field' ).closest( 'tr' ).hide() ;
			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp-donation-form-type-cart-button-field' ).closest( 'tr' ).show() ;
					break ;
				case '3':
					$( '.fp-donation-form-type-cart-list-field' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp-donation-form-type-cart-edit-field' ).closest( 'tr' ).show() ;
					break ;
			}

		} , donation_form_type_checkout : function ( $this ) {
			$( '.fp-donation-form-type-checkout-field' ).closest( 'tr' ).hide() ;
			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp-donation-form-type-checkout-button-field' ).closest( 'tr' ).show() ;
					break ;
				case '3':
					$( '.fp-donation-form-type-checkout-list-field' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp-donation-form-type-checkout-edit-field' ).closest( 'tr' ).show() ;
					break ;
			}

		} , donation_form_type_shortcode : function ( $this ) {
			$( '.fp-donation-form-type-shortcode-field' ).closest( 'tr' ).hide() ;
			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp-donation-form-type-shortcode-button-field' ).closest( 'tr' ).show() ;
					break ;
				case '3':
					$( '.fp-donation-form-type-shortcode-list-field' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp-donation-form-type-shortcode-edit-field' ).closest( 'tr' ).show() ;
					break ;
			}

		} , donation_form_type_flybox : function ( $this ) {
			$( '.fp-donation-form-type-flybox-field' ).closest( 'tr' ).hide() ;
			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp-donation-form-type-flybox-button-field' ).closest( 'tr' ).show() ;
					break ;
				case '3':
					$( '.fp-donation-form-type-flybox-list-field' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp-donation-form-type-flybox-edit-field' ).closest( 'tr' ).show() ;
					break ;
			}

		} , automatic_donation_product_selection : function ( $this ) {
			if ( '2' == $( $this ).val() ) {
				$( '.fp_donation_new_product_automatic' ).closest( 'tr' ).show() ;
				$( '#_fp_donation_new_product_title_automatic' ).closest( 'tr' ).show() ;
				$( '#ds_select_particular_products_automatic' ).closest( 'tr' ).hide() ;
			} else {
				$( '.fp_donation_new_product_automatic' ).closest( 'tr' ).hide() ;
				$( '#_fp_donation_new_product_title_automatic' ).closest( 'tr' ).hide() ;
				$( '#ds_select_particular_products_automatic' ).closest( 'tr' ).show() ;
			}

		} , automatic_product_type : function ( $this ) {

			switch ( $( $this ).val() ) {
				case '2':
					$( '#_fp_donation_automatic_include_selected_products' ).closest( 'tr' ).show() ;
					$( '#_fp_donation_automatic_exclude_selected_products' ).closest( 'tr' ).hide() ;
					break ;
				case '3':
					$( '#_fp_donation_automatic_include_selected_products' ).closest( 'tr' ).hide() ;
					$( '#_fp_donation_automatic_exclude_selected_products' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '#_fp_donation_automatic_include_selected_products' ).closest( 'tr' ).hide() ;
					$( '#_fp_donation_automatic_exclude_selected_products' ).closest( 'tr' ).hide() ;
					break ;
			}

		} , automatic_donation_value : function ( $this ) {

			switch ( $( $this ).val() ) {
				case '2':
					$( '.fp_donation_value_is_percentage' ).closest( 'tr' ).hide() ;
					$( '.fp_donation_value_is_percentage_tax' ).closest( 'tr' ).hide() ;
					$( '.fp_donation_value_is_fixed' ).closest( 'tr' ).show() ;
					break ;
				default:
					$( '.fp_donation_value_is_percentage' ).closest( 'tr' ).show() ;
					$( '.fp_donation_value_is_percentage_tax' ).closest( 'tr' ).show() ;
					$( '.fp_donation_value_is_fixed' ).closest( 'tr' ).hide() ;
					break ;
			}
		} , create_donation_product : function ( event ) {
			event.preventDefault( ) ;

			var $this = $( event.currentTarget ) ,
					product_name = $( '#_fp_donation_new_product_title' ).val() ;

			FP_Donation_Admin.block( $this ) ;

			var data = ( {
				action : 'fp_donation_create_new_product' ,
				product_name : product_name ,
				type : 'manual' ,
				fp_donation_security : fp_donation_admin_params.product_creation_nonce ,
			} ) ;

			$.post( ajaxurl , data , function ( res ) {
				if ( true === res.success ) {
					$( '#ds_select_particular_products' ).append( $( '<option></option>' ).attr( 'value' , res.data.product_id ).text( res.data.product_name ).prop( 'selected' , true ) )
					$( '#_fp_donation_product_selection' ).val( "1" ).trigger( "change" ) ;
				} else {
					alert( res.data.error ) ;
				}

				FP_Donation_Admin.unblock( $this ) ;
			} ) ;


		} , create_automatic_donation_product : function ( event ) {
			event.preventDefault( ) ;

			var $this = $( event.currentTarget ) ,
					product_name = $( '#_fp_donation_new_product_title_automatic' ).val() ;

			FP_Donation_Admin.block( $this ) ;

			var data = ( {
				action : 'fp_donation_create_new_product' ,
				product_name : product_name ,
				type : 'automatic' ,
				fp_donation_security : fp_donation_admin_params.product_creation_nonce ,
			} ) ;

			$.post( ajaxurl , data , function ( res ) {
				if ( true === res.success ) {
					$( '#ds_select_particular_products_automatic' ).append( $( '<option></option>' ).attr( 'value' , res.data.product_id ).text( res.data.product_name ).prop( 'selected' , true ) )
					$( '#_fp_donation_product_selection_automatic' ).val( "1" ).trigger( "change" ) ;
				} else {
					alert( res.data.error ) ;
				}

				FP_Donation_Admin.unblock( $this ) ;
			} ) ;

		} , add_reward_rule : function ( event ) {
			event.preventDefault( ) ;

			var $this = $( event.currentTarget ) ,
					wrapper = $( $this ).closest( '.donationrule_rewards' ) ,
					counter = Math.round( new Date().getTime() + ( Math.random() * 100 ) ) ;


			FP_Donation_Admin.block( wrapper ) ;

			var data = ( {
				action : 'fp_donation_add_reward_rule' ,
				uniq_id : counter ,
				fp_donation_security : fp_donation_admin_params.rule_nonce ,
			} ) ;

			$.post( ajaxurl , data , function ( res ) {
				if ( true === res.success ) {
					$( '#fpdonationrewardsrule' ).append( res.data.html ) ;
					$( 'body' ).trigger( 'wc-enhanced-select-init' ) ;
				} else {
					alert( res.data.error ) ;
				}

				FP_Donation_Admin.unblock( wrapper ) ;
			} ) ;

		} , remove_reward_rule : function ( event ) {
			event.preventDefault( ) ;

			var $this = $( event.currentTarget ) ;

			$( $this ).closest( 'tr' ).remove() ;
		} , reset_settings_data : function ( event ) {
			event.preventDefault( ) ;

			var $this = $( event.currentTarget ) ,
					donation_table = $( '#_fp_reset_donar_info' ) ,
					entire_settings = $( '#_fp_reset_entire_settings' ) ,
					master_log = null ,
					settings = null ;

			if ( !donation_table.is( ':checked' ) && !entire_settings.is( ':checked' ) ) {
				alert( fp_donation_admin_params.reset_no_selection_msg ) ;
				return false ;
			}

			if ( !confirm( fp_donation_admin_params.reset_confirm_msg ) ) {
				return false ;
			}

			if ( donation_table.is( ':checked' ) ) {
				master_log = '1' ;
			}

			if ( entire_settings.is( ':checked' ) ) {
				settings = '1' ;
			}

			FP_Donation_Admin.block( $this ) ;

			var data = ( {
				action : 'fp_donation_reset_settings_data' ,
				master_log : master_log ,
				settings : settings ,
				fp_donation_security : fp_donation_admin_params.reset_nonce ,
			} ) ;

			$.post( ajaxurl , data , function ( res ) {
				if ( true === res.success ) {
					alert( res.data.msg ) ;
				} else {
					alert( res.data.error ) ;
				}

				FP_Donation_Admin.unblock( $this ) ;
			} ) ;

		} , block : function ( id ) {
			if ( !FP_Donation_Admin.is_blocked( id ) ) {
				$( id ).addClass( 'processing' ).block( {
					message : null ,
					overlayCSS : {
						background : '#fff' ,
						opacity : 0.7
					}
				} ) ;
			}
		} , unblock : function ( id ) {
			$( id ).removeClass( 'processing' ).unblock() ;
		} , is_blocked : function ( id ) {
			return $( id ).is( '.processing' ) || $( id ).parents( '.processing' ).length ;
		}
	} ;
	FP_Donation_Admin.init( ) ;
} ) ;
