/* global fp_donation_frontend_params, fp_donation_flybox_params */
jQuery( function ( $ ) {
	'use strict' ;
	if ( typeof fp_donation_frontend_params === 'undefined' || typeof fp_donation_flybox_params === 'undefined' ) {
		return false ;
	}

	function fp_donation_setCookie( key , value ) {
		var expires = new Date( ) ;

		expires.setTime( expires.getTime( ) + ( fp_donation_flybox_params.expired_value * 24 * 60 * 60 * 1000 ) ) ;
		document.cookie = key + '=' + value + ';expires=' + expires.toUTCString( ) ;
	}

	function fp_donation_getCookie( key ) {
		var keyValue = document.cookie.match( '(^|;) ?' + key + '=([^;]*)(;|$)' ) ;
		return keyValue ? keyValue[2] : null ;
	}

	var FP_Donation_Frontend = {
		init : function ( ) {
			// Trigger donation reason type.
			$( document ).on( 'change' , '.fp_donation_reason_type' , this.trigger_donation_reason_type ) ;
			// Trigger predefined list box.
			$( document ).on( 'change' , '.fp_input_predefined_listbox' , this.trigger_predefined_listbox ) ;
			// Toggle predefined buttons.
			$( document ).on( 'click' , '.fp_input_predefined_buttons' , this.toggle_predefined_buttons ) ;
			// Handle donation anonymous.
			$( document ).on( 'change' , '.donation_anonymous_enable' , this.handle_donation_anonymous ) ;
			// Display the fly box.
			$( window ).on( 'scroll' , this.display_flybox ) ;
			// Close the fly box.
			$( document ).on( 'click' , '.fpdonationflyboxclose' , this.close_flybox ) ;
			// Add Donation rewards.
			$( document ).on( 'click' , '.sumo_donation_manual_free_product' , this.manually_add_donation_rewards ) ;

			$(document).on('keyup mouseup change blur keydown' , '.fp_donation_amount' , this.validate_donation_amout);

			this.trigger_on_page_load( ) ;
		} , trigger_on_page_load : function ( ) {
			// Trigger donation reason type.
			FP_Donation_Frontend.donation_reason_type( ".fp_donation_reason_type" ) ;
			// Trigger predefined list box.
			FP_Donation_Frontend.predefined_listbox( ".fp_input_predefined_listbox" ) ;

			FP_Donation_Frontend.initialize_footable( ) ;
			FP_Donation_Frontend.initialize_flybox( ) ;
		} , 

		validate_donation_amout(e){
			let $msg_field = $(this).closest('td').find('.fp_donation_inp_field_msg');
			let $submit_btn = $(this).closest('table').find('#fp_donation_submit');
			let $min_donation = parseFloat($(this).attr('min'));
			let $max_donation = parseFloat($(this).attr('max'));
			let $val = parseFloat($(this).val());

			if( $min_donation !== '' && $min_donation > $val){
				$msg_field.html(fp_donation_frontend_params.min_donation_msg);
				$msg_field.removeClass('fp_donation_hide');
				$submit_btn.attr('disabled', true);
			} else if( $max_donation !== '' && $max_donation < $val){
				$msg_field.html(fp_donation_frontend_params.max_donation_msg);
				$msg_field.removeClass('fp_donation_hide');
				$submit_btn.attr('disabled', true);
			} else {
				if(!$msg_field.hasClass('fp_donation_hide')){
					$msg_field.addClass('fp_donation_hide');
				}

				$submit_btn.attr('disabled', false);
			}
		},
		
		initialize_footable : function ( ) {
			if ( !$( '.donationtable' ).length ) {
				return ;
			}

			$( '.donationtable' ).footable( ) ;
			$( '#pagination_size' ).val( 5 ) ;
			$( '#pagination_size' ).on( 'change' , function ( ) {
				$( '.donationtable' ).data( 'page-size' , this.value ) ;
				$( '.donationtable' ).trigger( 'footable_initialized' ) ;
			} ) ;
		} , initialize_flybox : function () {
			if ( fp_donation_getCookie( 'fpdonationflybox' ) !== '1' ) {
				var get_current_width = $( '.fp_donation_flybox' ).outerWidth( ) ;

				if ( fp_donation_flybox_params.position == '1' ) {
					$( '.fp_donation_flybox' ).css( 'left' , '-' + get_current_width + 'px' ) ;
				} else {
					$( '.fp_donation_flybox' ).css( 'right' , '-' + get_current_width + 'px' ) ;
				}

				$( '.fp_donation_flybox' ).css( 'visibility' , 'visible' ) ;
			} else {
				$( '.fp_donation_flybox' ).css( 'display' , 'none' ) ;
			}
		} , display_flybox : function ( e ) {
			$( '.fp_donation_flybox' ).css( 'visibility' , 'visible' ) ;
			var currY = $( this ).scrollTop( ) ,
					postHeight    = $( this ).height( ) ,
					scrollHeight  = $( document ).height( ) ,
					scrollPercent = ( currY / ( scrollHeight - postHeight ) ) * 100 ;                                        

			if ( fp_donation_flybox_params.position == '2' ) {
				if ( fp_donation_getCookie( 'fpdonationflybox' ) !== '1' ) {
					if ( scrollPercent >= fp_donation_flybox_params.scroll_percentage ) {
						$( '.fp_donation_flybox' ).stop( ).animate( { right : "40px" , bottom : "30px" } , 600 ) ;
					} else {
						var width = $( '.fp_donation_flybox' ).outerWidth( ) ;
						$( '.fp_donation_flybox' ).stop( ).animate( { right : '-' + width , easing : "swing" } , 600 ) ;
					}
				}
			} else {
				if ( fp_donation_getCookie( 'fpdonationflybox' ) !== '1' ) {
					if ( scrollPercent >= fp_donation_flybox_params.scroll_percentage ) {
						$( '.fp_donation_flybox' ).stop( ).animate( { left : "40px" , bottom : "30px" } , 600 ) ;
					} else {
						var width = $( '.fp_donation_flybox' ).outerWidth( ) ;
						$( '.fp_donation_flybox' ).stop( ).animate( { left : '-' + width , easing : "swing" } , 600 ) ;
					}
				}
			}
		} , trigger_donation_reason_type : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;
			FP_Donation_Frontend.donation_reason_type( $this ) ;
		} , trigger_predefined_listbox : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;
			FP_Donation_Frontend.predefined_listbox( $this ) ;
		} , donation_reason_type : function ( $this ) {

			switch ( $( $this ).val( ) ) {
				case '2':
					$( $this ).closest( '.fp_donation_reason_table' ).find( '.fp_reason_for_fields' ).show( ) ;
					break ;
				default:
					$( $this ).closest( '.fp_donation_reason_table' ).find( '.fp_reason_for_fields' ).hide( ) ;
					break ;
			}

		} , predefined_listbox : function ( $this ) {
			$( '.fp_donation_amount_predefined_listbox' ).val( $( $this ).val( ) ) ;
		} , toggle_predefined_buttons : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ,
					dataprice = $( $this ).attr( 'data-price' ) ;
			$( '.fp_input_predefined_buttons' ).removeClass( 'fp_input_predefined_buttons_selected' ) ;
			$( $this ).addClass( 'fp_input_predefined_buttons_selected' ) ;
			$( '.fp_donation_amount_predefined_buttons' ).val( dataprice ) ;
		} , handle_donation_anonymous : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ,
					anonymous = 'no' ;
			FP_Donation_Frontend.block( $this ) ;
			if ( $( $this ).is( ":checked" ) ) {
				anonymous = 'yes' ;
			}

			var data = ( {
				action : 'fp_donation_handle_anonymous' ,
				anonymous : anonymous ,
				fp_donation_security : fp_donation_frontend_params.anonymous_nonce ,
			} ) ;
			$.post( fp_donation_frontend_params.ajax_url , data , function ( res ) {
				if ( true !== res.success ) {
					alert( res.data.error ) ;
				}

				FP_Donation_Frontend.unblock( $this ) ;
			} ) ;
		} , close_flybox : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ,
					getwidth = $( '.fp_donation_flybox' ).outerWidth() ;

			if ( fp_donation_flybox_params.position == '1' ) {
				$( '.fp_donation_flybox' ).stop().animate( { left : '-' + getwidth , easing : "swing" } , 600 ) ;
			} else {
				$( '.fp_donation_flybox' ).stop().animate( { right : '-' + getwidth , easing : "swing" } , 600 ) ;
			}

			if ( fp_donation_flybox_params.enable_cookies == 'yes' ) {
				fp_donation_setCookie( 'fpdonationflybox' , '1' ) ;
			}

		} , manually_add_donation_rewards : function ( event ) {
			event.preventDefault( ) ;
			var $this = $( event.currentTarget ) ;
			var data = {
				action : 'fp_donation_reward_product' ,
				product_id : $( $this ).data( 'product_id' ) ,
				donation_security : fp_donation_frontend_params.reward_nonce ,
			} ;
			$.ajax( {
				type : 'POST' ,
				url : fp_donation_frontend_params.ajax_url ,
				data : data
			} ).done( function ( response ) {
				if ( true === response.success ) {
					window.location.reload( ) ;
				}
			} ) ;
		} , block : function ( id ) {
			if ( !FP_Donation_Frontend.is_blocked( id ) ) {
				$( id ).addClass( 'processing' ).block( {
					message : null ,
					overlayCSS : {
						background : '#fff' ,
						opacity : 0.7
					}
				} ) ;
			}
		} , unblock : function ( id ) {
			$( id ).removeClass( 'processing' ).unblock( ) ;
		} , is_blocked : function ( id ) {
			return $( id ).is( '.processing' ) || $( id ).parents( '.processing' ).length ;
		}
	} ;
	FP_Donation_Frontend.init( ) ;
} ) ;
