<?php

/*
 * Plugin Name: SUMO Donations
 * Plugin URI:
 * Description: Complete Donation System for WooCommerce
 * Version: 3.9.0
 * Author: FantasticPlugins
 * Author URI: http://fantasticplugins.com
 * Text Domain: donationsystem
 * Domain Path: /languages
 *
 * WC tested up to: 10.3.3
 */

class FP_Donation_System {

	/**
	 * Version.
	 *
	 * @var string
	 * */
	private $version = '3.9.0';

	// Construct the Donation System.
	public function __construct() {

		// Try to Avoid the Fatal Error when calling init hook
		include_once ABSPATH . 'wp-admin/includes/plugin.php';
		add_action( 'init', array( $this, 'check_woocommerce_is_active' ) );
		add_action( 'init', array( $this, 'avoid_header_already_sent_problem' ) );

		add_action( 'plugins_loaded', array( $this, 'plugins_loaded' ) );

		$this->define_constants();
		$this->include_files();
		$this->init_hooks();
	}

	/**
	 * Define the constant values.
	 *
	 * @return void
	 * */
	private function define_constants() {

		$constant_array = array(
			'FP_DONATION_VERSION'        => $this->version,
			'FP_DONATION_LOCALE'         => 'donationsystem',
			'FP_DONATION_FOLDER_NAME'    => 'donationsystem',
			'FP_DONATION_ABSPATH'        => __DIR__ . '/',
			'FP_DONATION_ADMIN_URL'      => admin_url( 'admin.php' ),
			'FP_DONATION_ADMIN_AJAX_URL' => admin_url( 'admin-ajax.php' ),
			'FP_DONATION_PLUGIN_SLUG'    => plugin_basename( __FILE__ ),
			'FP_DONATION_PLUGIN_PATH'    => untrailingslashit( plugin_dir_path( __FILE__ ) ),
			'FP_DONATION_PLUGIN_URL'     => untrailingslashit( plugins_url( '/', __FILE__ ) ),
		);

		$constant_array = apply_filters( 'fp_donation_define_constants', $constant_array );

		if ( is_array( $constant_array ) && ! empty( $constant_array ) ) {
			foreach ( $constant_array as $name => $value ) {
				if ( defined( $name ) ) {
					continue;
				}

				define( $name, $value );
			}
		}
	}

	/**
	 * Include required files.
	 * */
	private function include_files() {
		// Include the File from Subfolder
		include 'inc/class-donation-main-system.php'; // For Cart Page
		include 'inc/class-donation-checkout-function.php';
		include 'inc/class-donation-product-function.php';
		include 'inc/class-donation-shortcode-product.php';
		include 'inc/admin/class-donation-menu-management.php';
		include 'inc/admin/class-donation-wp-list-table.php';
		include 'inc/class-donation-rewards-cart.php';
		include 'inc/class-donation-common-function.php';
		include 'inc/class-donation-flybox-function.php';
		include 'inc/class-donation-compatibility-function.php';
		include 'inc/gdpr/class-sumo-donations-privacy.php';
		include 'inc/class-donation-admin-ajax-function.php';
		include 'inc/admin/class-donation-admin-assets.php';
		include 'inc/class-donation-frontend-assets.php';
	}

	// Check WooCommerce is Active or Not

	public static function check_woocommerce_is_active() {

		if ( is_multisite() ) {
			// This Condition is for Multi Site WooCommerce Installation
			if ( ! is_plugin_active_for_network( 'woocommerce/woocommerce.php' ) && ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) ) {
				if ( is_admin() ) {
					$variable = "<div class='error'><p> SUMO Donations will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin. </p></div>";
					echo wp_kses_post( $variable );
				}
				return;
			}
		} else {
			// This Condition is for Single Site WooCommerce Installation
			if ( ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
				if ( is_admin() ) {
					$variable = "<div class='error'><p> SUMO Donations will not work until WooCommerce Plugin is Activated. Please Activate the WooCommerce Plugin. </p></div>";
					echo wp_kses_post( $variable );
				}
				return;
			}
		}
	}

	// Avoid Header Already Sent Problem

	public static function avoid_header_already_sent_problem() {
		ob_start();
	}

		/**
		 * Define the hooks.
		 * */
	private function init_hooks() {
			// Compatibility with WC HPOS.
			add_action( 'before_woocommerce_init', array( $this, 'declare_compatibility_with_hpos' ) );
	}

		/*
	* Declare compatibility with HPOS.
	* @since 3.5.0
	*
	* @return void
	*/
	public function declare_compatibility_with_hpos() {
		if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}

	/*
	 *  Allow CSS from WooCommerce
	 */

	public static function allow_css_from_woocommerce() {

		$newscreenids = get_current_screen();

		if ( isset( $_GET['page'] ) ) {
			if ( 'donationsystem' == wc_clean( wp_unslash( $_GET['page'] ) ) ) {
				$array[] = $newscreenids->id;
				return $array;
			} else {
				$array[] = '';
				return $array;
			}
		}
	}

	/*
	 * Plugins loaded.
	 */

	public static function plugins_loaded() {
		// Screenids alteration
		if ( isset( $_GET['page'] ) ) {
			if ( 'donationsystem' == ( wc_clean( wp_unslash( $_GET['page'] ) ) ) ) {
				add_filter( 'woocommerce_screen_ids', array( __CLASS__, 'allow_css_from_woocommerce' ), 1 );
			}
		}

		add_filter( 'plugin_action_links_' . FP_DONATION_PLUGIN_SLUG, array( __CLASS__, 'settings_link' ) );

		// Translation.
		load_plugin_textdomain( 'donationsystem', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );
	}

	/**
	 * Add the plugin settings link.
	 *
	 * @return array
	 */
	public static function settings_link( $links ) {
		$setting_page_link = '<a href="' . fp_donation_get_settings_page_url() . '">' . esc_html__( 'Settings', 'donationsystem' ) . '</a>';

		array_unshift( $links, $setting_page_link );

		return $links;
	}
}

new FP_Donation_System();

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}