<?php

/**
 * Admin Assets.
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit ; // Exit if accessed directly.
}
if ( ! class_exists( 'FP_Donation_Admin_Assets' ) ) {

	/**
	 * Class.
	 */
	class FP_Donation_Admin_Assets {

		/**
		 * Suffix.
		 * 
		 * @var string
		 */
		private static $suffix ;

		/**
		 * Class Initialization.
		 */
		public static function init() {
			self::$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min' ;

			add_action( 'admin_enqueue_scripts' , array( __CLASS__, 'external_js_files' ) , 20 ) ;
			add_action( 'admin_enqueue_scripts' , array( __CLASS__, 'external_css_files' ) ) ;
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_css_files() {
			$screen_ids   = fp_donation_page_screen_ids() ;
			$newscreenids = get_current_screen() ;
			$screenid     = str_replace( 'edit-' , '' , $newscreenids->id ) ;

			if ( ! in_array( $screenid , $screen_ids ) ) {
				return ;
			}

			wp_enqueue_style( 'fp-donation-admin' , FP_DONATION_PLUGIN_URL . '/assets/css/admin.css' , array() , FP_DONATION_VERSION ) ;
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_js_files() {
			$screen_ids   = fp_donation_page_screen_ids() ;
			$newscreenids = get_current_screen() ;
			$screenid     = str_replace( 'edit-' , '' , $newscreenids->id ) ;

			$enqueue_array = array(
				'fp-donation-admin'   => array(
					'callable' => array( 'FP_Donation_Admin_Assets', 'admin' ),
					'restrict' => in_array( $screenid , $screen_ids ),
				),
				'fp-donation-select2' => array(
					'callable' => array( 'FP_Donation_Admin_Assets', 'select2' ),
					'restrict' => in_array( $screenid , $screen_ids ),
				),
					) ;

			$enqueue_array = apply_filters( 'fp_donation_admin_assets' , $enqueue_array ) ;
			if ( ! fp_donation_check_is_array( $enqueue_array ) ) {
				return ;
			}

			foreach ( $enqueue_array as $key => $enqueue ) {
				if ( ! fp_donation_check_is_array( $enqueue ) ) {
					continue ;
				}

				if ( $enqueue[ 'restrict' ] ) {
					call_user_func_array( $enqueue[ 'callable' ] , array() ) ;
				}
			}
		}

		/**
		 * Enqueue Admin end required JS files.
		 */
		public static function admin() {
			// JS Color.
			wp_enqueue_script( 'jscolor' , FP_DONATION_PLUGIN_URL . '/assets/lib/jscolor/jscolor.js' , array( 'jquery' ) , FP_DONATION_VERSION ) ;

			// Admin.   
			wp_enqueue_script( 'fp-donation-admin' , FP_DONATION_PLUGIN_URL . '/assets/js/admin/admin.js' , array( 'jquery', fp_donation_get_wc_script_handle_name('blockui') ) , FP_DONATION_VERSION ) ;
			wp_localize_script(
					'fp-donation-admin' , 'fp_donation_admin_params' , array(
				'product_creation_nonce' => wp_create_nonce( 'product-creation-nonce' ),
				'rule_nonce'             => wp_create_nonce( 'rule-nonce' ),
				'reset_nonce'            => wp_create_nonce( 'reset-nonce' ),
				'reset_no_selection_msg' => esc_html__( 'Please select any one settings' , 'donationsystem' ),
				'reset_confirm_msg'      => esc_html__( 'Are you sure want to reset the data?' , 'donationsystem' ),
					)
			) ;
		}

		/**
		 * Enqueue select2 scripts and CSS.
		 */
		public static function select2() {

			wp_enqueue_script( 'fp-donation-enhanced' , FP_DONATION_PLUGIN_URL . '/assets/js/donation-enhanced.js' , array( 'jquery', fp_donation_get_wc_script_handle_name('select2') ) , FP_DONATION_VERSION ) ;
			wp_localize_script(
					'fp-donation-enhanced' , 'fp_donation_enhanced_select_params' , array(
				'i18n_no_matches'           => esc_html__( 'No matches found' , 'donationsystem' ),
				'i18n_input_too_short_1'    => esc_html__( 'Please enter 1 or more characters' , 'donationsystem' ),
				'i18n_input_too_short_n'    => esc_html__( 'Please enter %qty% or more characters' , 'donationsystem' ),
				'i18n_input_too_long_1'     => esc_html__( 'Please delete 1 character' , 'donationsystem' ),
				'i18n_input_too_long_n'     => esc_html__( 'Please delete %qty% characters' , 'donationsystem' ),
				'i18n_selection_too_long_1' => esc_html__( 'You can only select 1 item' , 'donationsystem' ),
				'i18n_selection_too_long_n' => esc_html__( 'You can only select %qty% items' , 'donationsystem' ),
				'i18n_load_more'            => esc_html__( 'Loading more results&hellip;' , 'donationsystem' ),
				'i18n_searching'            => esc_html__( 'Searching&hellip;' , 'donationsystem' ),
				'search_nonce'              => wp_create_nonce( 'donation-search-nonce' ),
				'ajax_url'                  => FP_DONATION_ADMIN_AJAX_URL,
					)
			) ;
		}
	}

	FP_Donation_Admin_Assets::init() ;
}
