<?php
/*
 * Control Over Menu System in Admin Settings
 */

class FP_Donation_Menu_Management {

	// Construct the Donation System Admin Menu

	public function __construct() {

		// Register Admin Submenu
		add_action( 'admin_menu' , array( $this, 'add_sub_menu' ) ) ;

		// Include tab one by one
		include 'tab/class-donation-general-tab.php' ;
		include 'tab/class-donation-form-tab.php' ;
		include 'tab/class-donation-form-flybox-tab.php' ;
		include 'tab/class-donation-form-automatic.php' ;
		include 'tab/class-donation-rewards-tab.php' ;
		include 'tab/class-donation-table-tab.php' ;
		include 'tab/class-donation-shortcode-tab.php' ;
		include 'tab/class-donation-labels-tab.php' ;
		include 'tab/class-donation-messages-tab.php' ;
		include 'tab/class-donation-reset-tab.php' ;
		include 'tab/class-donation-form-support-tab.php' ;
	}

	// Add Sub-Menu under WooCommerce for Admin Menu

	public static function add_sub_menu() {
		// Submenu for donation System
		add_submenu_page( 'woocommerce' , __( 'SUMO Donations' , 'donationsystem' ) , __( 'SUMO Donations' , 'donationsystem' ) , 'manage_woocommerce' , 'donationsystem' , array( 'FP_Donation_Menu_Management', 'main_sub_menu_settings' ) ) ;
	}

	public static function main_sub_menu_settings() {
		global $woocommerce, $woocommerce_settings, $current_section, $current_tab ;
		$tabs        = '' ;
		do_action( 'woocommerce_donationsystem_settings_start' ) ;
		$current_tab = ( empty( $_GET[ 'tab' ] ) ) ? 'fp_donationsystem' : sanitize_title( wp_unslash( $_GET[ 'tab' ] ) ) ;

		$current_section = ( empty( $_REQUEST[ 'section' ] ) ) ? '' : sanitize_title( wp_unslash( $_REQUEST[ 'section' ] ) ) ;
		if ( ! empty( $_POST[ 'save' ] ) ) {
			$nonce = isset( $_REQUEST[ '_wpnonce' ] ) ? wc_clean( wp_unslash( $_REQUEST[ '_wpnonce' ] ) ) : '' ;
			if ( empty( $nonce ) || ! wp_verify_nonce( $nonce , 'woocommerce-settings' ) ) {
				die( esc_html__( 'Action failed. Please refresh the page and retry.' , 'donationsystem' ) ) ;
			}

			if ( ! $current_section ) {
				//include_once('settings/settings-save.php');
				switch ( $current_tab ) {
					default:
						if ( isset( $woocommerce_settings[ $current_tab ] ) ) {
							woocommerce_update_options( $woocommerce_settings[ $current_tab ] ) ;
						}

						// Trigger action for tab
						do_action( 'woocommerce_update_options_' . $current_tab ) ;
						break ;
				}

				do_action( 'woocommerce_update_options' ) ;
			} else {
				// Save section onlys
				do_action( 'woocommerce_update_options_' . $current_tab . '_' . $current_section ) ;
			}

			// Clear any unwanted data
			//$woocommerce->clear_product_transients();
			delete_transient( 'woocommerce_cache_excluded_uris' ) ;
			// Redirect back to the settings page
			$redirect = add_query_arg( array( 'saved' => 'true' ) ) ;
			//  $redirect .= add_query_arg('noheader', 'true');

			if ( isset( $_POST[ 'subtab' ] ) ) {
				wp_safe_redirect( esc_url_raw( $redirect ) ) ;
				exit ;
			}
		}
		// Get any returned messages
		$error   = ( empty( $_GET[ 'wc_error' ] ) ) ? '' : wc_clean( wp_unslash( $_GET[ 'wc_error' ] ) ) ;
		$message = ( empty( $_GET[ 'wc_message' ] ) ) ? '' : wc_clean( wp_unslash( $_GET[ 'wc_message' ] ) ) ;

		if ( $error || $message ) {

			if ( $error ) {
				echo '<div id="message" class="error fade"><p><strong>' . esc_html( $error ) . '</strong></p></div>' ;
			} else {
				echo '<div id="message" class="updated fade"><p><strong>' . esc_html( $message ) . '</strong></p></div>' ;
			}
		} elseif ( ! empty( $_GET[ 'saved' ] ) ) {

			echo '<div id="message" class="updated fade"><p><strong>' . esc_html__( 'Your settings have been saved.' , 'donationsystem' ) . '</strong></p></div>' ;
		}
		?>
		<div class="wrap woocommerce">
			<form method="post" id="mainform" action="" enctype="multipart/form-data">
				<div class="icon32 icon32-woocommerce-settings" id="icon-woocommerce"><br /></div><h2 class="nav-tab-wrapper woo-nav-tab-wrapper">
					<?php
					$tabs = apply_filters( 'woocommerce_donationsystem_settings_tabs_array' , $tabs ) ;

					foreach ( $tabs as $name => $label ) {
						//echo $current_tab;
						echo '<a href="' . esc_url( admin_url( 'admin.php?page=donationsystem&tab=' . $name ) ) . '" class="nav-tab ' ;
						if ( $current_tab == $name ) {
							echo 'nav-tab-active' ;
						}
						echo '">' . esc_html( $label ) . '</a>' ;
					}
					do_action( 'woocommerce_donationsystem_settings_tabs' ) ;
					?>
				</h2>

				<?php
				switch ( $current_tab ) :

					default:
						do_action( 'woocommerce_donationsystem_settings_tabs_' . $current_tab ) ;
						break ;
				endswitch ;
				?>

				<p class="submit">
					<?php if ( ! isset( $GLOBALS[ 'hide_save_button' ] ) ) : ?>
						<input name="save" class="button-primary" type="submit" value="<?php esc_html_e( 'Save Changes' , 'donationsystem' ) ; ?>" />
					<?php endif ; ?>
					<input type="hidden" name="subtab" id="last_tab" />
					<?php wp_nonce_field( 'woocommerce-settings' , '_wpnonce' , true , true ) ; ?>
					<?php
					if ( 'fp_donationsystem' == $current_tab ) {
						?>
						<input class="button-secondary fp-donation-reset-button" type="submit" value="<?php esc_html_e( 'Reset this Page' , 'donationsystem' ) ; ?>" name="reset_fp_donationsystem">
						<?php
					}

					if ( 'fp_donationsystem_form' == $current_tab ) {
						?>
						<input class="button-secondary fp-donation-reset-button" type="submit" value="<?php esc_html_e( 'Reset this Page' , 'donationsystem' ) ; ?>" name="reset_fp_donationsystem_form">
						<?php
					}

					if ( 'fp_donationsystem_flybox' == $current_tab ) {
						?>
						 
						<input  class="button-secondary fp-donation-reset-button" type="submit" value="<?php esc_html_e( 'Reset this Page' , 'donationsystem' ) ; ?>" name="reset_fp_donationsystem_flybox">
						<?php
					}

					if ( 'fp_donationsystem_labels' == $current_tab ) {
						?>
						<input  class="button-secondary fp-donation-reset-button" type="submit" value="<?php esc_html_e( 'Reset this Page' , 'donationsystem' ) ; ?>" name="reset_fp_donationsystem_labels">
						<?php
					}

					if ( 'fp_donationsystem_messages' == $current_tab ) {
						?>
						<input class="button-secondary fp-donation-reset-button" type="submit" value="<?php esc_html_e( 'Reset this Page' , 'donationsystem' ) ; ?>" name="reset_fp_donationsystem_messages">
						<?php
					}
					?>
				</p>
			</form>
		</div>
		<?php
	}
}

new FP_Donation_Menu_Management() ;
