<?php

class FP_Donation_Automatic_Tab {

	// Construct the Automatic Donation
	public function __construct() {

		add_action( 'woocommerce_donationsystem_settings_tabs_array' , array( $this, 'initialize_tab' ) ) ;

		add_action( 'woocommerce_donationsystem_settings_tabs_fp_donationsystem_automatic' , array( $this, 'initialize_visual_appearance_admin_fields' ) ) ;

		add_action( 'woocommerce_update_options_fp_donationsystem_automatic' , array( $this, 'update_data_from_admin_fields' ) ) ;

		add_action( 'woocommerce_admin_field__fp_donation_new_product_automatic' , array( $this, 'initialize_button_to_make_new_product' ) ) ;

		add_action( 'woocommerce_admin_field__fp_choose_existing_product_automatic' , array( $this, 'initialize_function_for_single_selection_product' ) ) ;

		add_action( 'woocommerce_admin_field__fp_donation_automatic_include_selected_products' , array( $this, 'add_donation_include_products' ) ) ;

		add_action( 'woocommerce_admin_field__fp_donation_automatic_exclude_selected_products' , array( $this, 'add_donation_exclude_products' ) ) ;

		add_action( 'admin_init' , array( $this, 'add_option_to_donationsystem' ) ) ;

		add_action( 'woocommerce_add_to_cart' , array( $this, 'add_automatic_product_in_cart' ) , 999 ) ;

		add_action( 'wp_head' , array( $this, 'add_automatic_product_to_cart_for_force_option' ) , 999 ) ;

		add_action( 'woocommerce_before_calculate_totals' , array( $this, 'calculate_funtion_for_automatic_donation' ) , 999 ) ;

		add_action( 'woocommerce_cart_item_removed' , array( $this, 'remove_automatic_product_from_cart' ) , 10 , 2 ) ;

		add_filter( 'woocommerce_product_is_taxable' , array( $this, 'make_product_not_taxable' ) , 10 , 2 ) ;

		add_filter( 'woocommerce_cart_item_quantity' , array( $this, 'cart_item_quantity' ) , 10 , 2 ) ;
	}

	// Initialize the Settings from Donation Messages

	public static function initialize_tab( $settings_tab ) {
		if ( ! is_array( $settings_tab ) ) {
			$settings_tab = ( array ) $settings_tab ;
		}
		$settings_tab[ 'fp_donationsystem_automatic' ] = __( 'Automatic Donation' , 'donationsystem' ) ;
		return array_filter( $settings_tab ) ;
	}

	// Initialize Settings Page array

	public static function initialize_admin_fields() {
		global $woocommerce ;

		$categories      = get_terms( 'product_cat' , 'orderby=name&hide_empty=0' ) ;
		$list_categories = array() ;

		if ( is_array( $categories ) && ! empty( $categories ) ) {
			foreach ( $categories as $key => $value ) {
				$list_categories[ $value->term_id ] = $value->name ;
			}
		}

		return apply_filters( 'woocommerce_donationsystem_automatic_settings' , array(
			array(
				'name' => __( 'Automatic Donation Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_donationsystem_automatic_settings',
			),
			array(
				'name'     => __( 'Enable Automatic Donation' , 'donationsystem' ),
				'id'       => '_fp_donation_automatic_enable',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_donation_automatic_enable',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Donation Product Setup' , 'donationsystem' ),
				'desc'     => __( 'Choose Donation Product from Existing/New' , 'donationsystem' ),
				'id'       => '_fp_donation_product_selection_automatic',
				'css'      => 'min-width:150px;',
				'std'      => '1',
				'class'    => '_fp_donation_product_selection_automatic',
				'default'  => '1',
				'newids'   => '_fp_donation_product_selection_automatic',
				'type'     => 'select',
				'options'  => array(
					'1' => __( 'Existing Product' , 'donationsystem' ),
					'2' => __( 'Create New Product' , 'donationsystem' ),
				),
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Title for New Donation Product' , 'donationsystem' ),
				'desc'     => __( 'Enter Title for New Donation Product' , 'donationsystem' ),
				'id'       => '_fp_donation_new_product_title_automatic',
				'css'      => 'min-width:150px;',
				'std'      => 'Donation',
				'class'    => '',
				'default'  => 'Donation',
				'newids'   => '_fp_donation_new_product_title_automatic',
				'type'     => 'text',
				'desc_tip' => true,
			),
			array(
				'name' => __( 'Create New Product' , 'donationsystem' ),
				'type' => '_fp_donation_new_product_automatic',
			),
			array(
				'name'     => __( 'Choose Existing Product for Donation' , 'donationsystem' ),
				'id'       => '_fp_donation_existing_product_automatic',
				'css'      => 'min-width:150px;',
				'std'      => '',
				'class'    => '',
				'default'  => '',
				'newids'   => '_fp_donation_existing_product_automatic',
				'type'     => '_fp_choose_existing_product_automatic',
				'desc_tip' => false,
			),
			array(
				'name'     => __( 'Force Automatic Donation' , 'donationsystem' ),
				'id'       => '_fp_force_donation_automatic',
				'desc'     => __( 'Removing the Automatic Donation when you Turn On this Option' , 'donationsystem' ),
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_force_donation_automatic',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Automatic Donation Value' , 'donationsystem' ),
				'id'       => '_fp_automatic_donation_value',
				'css'      => '',
				'std'      => '1',
				'class'    => '',
				'default'  => '1',
				'newids'   => '_fp_automatic_donation_value',
				'options'  => array(
					'1' => __( '% of Cart Total' , 'donationsystem' ),
					'2' => __( 'Fixed Value' , 'donationsystem' ),
				),
				'type'     => 'select',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Percentage of Cart Total as Donation' , 'donationsystem' ),
				'id'       => '_fp_donation_automatic_percentage_value',
				'css'      => '',
				'std'      => '',
				'class'    => 'fp_donation_value_is_percentage',
				'newids'   => '_fp_donation_automatic_percentage_value',
				'type'     => 'text',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Include Tax' , 'donationsystem' ),
				'id'       => '_fp_donation_automatic_including_tax',
				'css'      => '',
				'std'      => 'no',
				'class'    => 'fp_donation_value_is_percentage_tax',
				'newids'   => '_fp_donation_automatic_including_tax',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Fixed Value as Donation' , 'donationsystem' ),
				'id'       => '_fp_donation_automatic_fixed_value',
				'css'      => '',
				'std'      => '',
				'class'    => 'fp_donation_value_is_fixed',
				'newids'   => '_fp_donation_automatic_fixed_value',
				'type'     => 'text',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Donation Value Added/Subtracted' , 'donationsystem' ),
				'id'       => '_fp_donation_value_add_sub',
				'css'      => '',
				'std'      => '1',
				'default'  => '1',
				'class'    => 'fp_donation_value_is_percentage',
				'newids'   => '_fp_donation_value_add_sub',
				'type'     => 'select',
				'options'  => array(
					'1' => __( 'Donation Value Subtracted from Cart Total' , 'donationsystem' ),
					'2' => __( 'Donation Value Added to Existing Cart Total' , 'donationsystem' ),
				),
				'desc_tip' => true,
			),
			array(
				'type' => 'sectionend',
				'id'   => '_donationsystem_automatic_settings',
			),
			array(
				'name' => __( 'Automatic Donation Valid for' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donationsystem_automatic_validation',
			),
			array(
				'name'    => __( 'Product' , 'donationsystem' ),
				'id'      => '_fp_donation_automatic_product_type',
				'css'     => '',
				'std'     => '1',
				'default' => '1',
				'class'   => '',
				'newids'  => '_fp_donation_automatic_product_type',
				'type'    => 'select',
				'options' => array(
					'1' => __( 'All Products' , 'donationsystem' ),
					'2' => __( 'Include Selected Products' , 'donationsystem' ),
					'3' => __( 'Exclude Selected Products' , 'donationsystem' ),
				),
			),
			array(
				'type' => '_fp_donation_automatic_include_selected_products',
			),
			array(
				'type' => '_fp_donation_automatic_exclude_selected_products',
			),
			array( 'type' => 'sectionend', 'id' => '_fp_donationsystem_automatic_validation' ),
				) ) ;
	}

	public static function initialize_visual_appearance_admin_fields() {
		woocommerce_admin_fields( self::initialize_admin_fields() ) ;
	}

	public static function update_data_from_admin_fields() {
		woocommerce_update_options( self::initialize_admin_fields() ) ;

		$automatic_product = isset( $_REQUEST[ 'ds_select_particular_products_automatic' ][ 0 ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'ds_select_particular_products_automatic' ][ 0 ] ) ) : array() ;
		update_option( 'ds_select_particular_products_automatic' , $automatic_product ) ;

		$include_selected_products = isset( $_REQUEST[ '_fp_donation_automatic_include_selected_products' ] ) ? wc_clean( wp_unslash( $_REQUEST[ '_fp_donation_automatic_include_selected_products' ] ) ) : array() ;
		update_option( '_fp_donation_automatic_include_selected_products' , $include_selected_products ) ;

		$exclude_selected_products = isset( $_REQUEST[ '_fp_donation_automatic_exclude_selected_products' ] ) ? wc_clean( wp_unslash( $_REQUEST[ '_fp_donation_automatic_exclude_selected_products' ] ) ) : array() ;
		update_option( '_fp_donation_automatic_exclude_selected_products' , $exclude_selected_products ) ;
	}

	public static function add_option_to_donationsystem() {
		foreach ( self::initialize_admin_fields() as $setting ) {
			if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
				add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
			}
		}
	}

	public static function reset_option_to_donationsystem() {
		foreach ( self::initialize_admin_fields()as $setting ) {
			if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
				delete_option( $setting[ 'newids' ] ) ;
				add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
			}
		}
	}

	// Admin Field of Donation System for Create New Products
	public static function initialize_button_to_make_new_product() {
		?>
		<tr>
			<th>
				<?php esc_html_e( 'Create New Donation Product' , 'donationsystem' ) ; ?>
			</th>
			<td>
				<input type="submit" class="fp_donation_new_product_automatic button-primary" value="Create New Donation Product" name="fp_donation_new_product"/>
			</td>
		</tr>

		<?php
	}

	// Choose Single Selection New Product
	public static function initialize_function_for_single_selection_product() {
		global $woocommerce ;
		ob_start() ;
		?>
		<tr valign="top">
			<th class="titledesc" scope="row">
				<label for="ds_select_particular_products_automatic"><?php esc_html_e( 'Product that should be used for Donation (Product should be non-taxable and non-shippable)' , 'donationsystem' ) ; ?></label>
			</th>
			<td class="forminp forminp-select">
				<?php
				$selected_val = array_filter( ( array ) get_option( 'ds_select_particular_products_automatic' ) ) ;

				$product_selection_args = array(
					'id'          => 'ds_select_particular_products_automatic',
					'class'       => 'ds_select_particular_products_automatic',
					'name'        => 'ds_select_particular_products_automatic',
					'action'      => 'fp_donation_simple_product_search',
					'placeholder' => esc_html__( 'Search a Product' , 'donationsystem' ),
					'multiple'    => false,
					'options'     => $selected_val,
						) ;
				donation_system_select2_html( $product_selection_args ) ;
				?>
			</td>
		</tr>
		<?php
	}

	// Admin Field of Donation System for Include Products
	public static function add_donation_include_products() {
		?>
		<tr>
			<th>
				<label for="fp_donation_automatic_include_selected_products">
					<?php esc_html_e( 'Include Selected Products' , 'donationsystem' ) ; ?>
				</label>
			</th>
			<td>
				<?php
				$product_and_variation = '1' ;
				$multiple              = true ;
				$name                  = '_fp_donation_automatic_include_selected_products' ;
				$iteration             = '' ;
				$value                 = '' ;
				$subname               = '' ;
				FP_Donation_Common_Function::search_product_selection( $product_and_variation , $multiple , $name , $iteration , $value , $subname ) ;
				?>
			</td>
		</tr>
		<?php
	}

	// Add Admin Field Donation for Exclude Products
	public static function add_donation_exclude_products() {
		?>
		<tr>
			<th>
				<label for="fp_donation_automatic_exclude_selected_products">
					<?php esc_html_e( 'Exclude Selected Products' , 'donationsystem' ) ; ?>
				</label>
			</th>
			<td>
				<?php
				$product_and_variation = '1' ;
				$multiple              = true ;
				$name                  = '_fp_donation_automatic_exclude_selected_products' ;
				$iteration             = '' ;
				$value                 = '' ;
				$subname               = '' ;
				FP_Donation_Common_Function::search_product_selection( $product_and_variation , $multiple , $name , $iteration , $value , $subname ) ;
				?>
			</td>
		</tr>
		<?php
	}

	// automatic product add functionality when add to cart button click.
	public static function add_automatic_product_in_cart() {
		$automatic_donation_is_enabled = get_option( '_fp_donation_automatic_enable' ) ;
		$automatic_donation_product    = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;

		// check automatic donation enabled or not and product selected was empty or not
		if ( ( 'yes' != $automatic_donation_is_enabled ) || ( empty( $automatic_donation_product ) ) ) {
			return ;
		}

		// check cart content
		$get_available_cart_contents = WC()->cart->cart_contents ;
		if ( ! fp_donation_check_is_array( $get_available_cart_contents ) ) {
			return ;
		}

		// remove old donation product when donation product was changed in settings
		$already_donated_products = WC()->session->get( 'fp_donation_cart_product_auto' ) ? WC()->session->get( 'fp_donation_cart_product_auto' ) : '' ;
		if ( ! empty( $already_donated_products ) && ( $already_donated_products != $automatic_donation_product ) ) {
			$find_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $already_donated_products ) ;

			if ( ! empty( $find_product_in_cart ) ) {
				WC()->cart->remove_cart_item( $find_product_in_cart ) ;
			}
		}

		// remove manual donation from cart.
		$manual_donation_product = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products' ) ) ;
		if ( $manual_donation_product != $automatic_donation_product ) {
			$find_manual_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $manual_donation_product ) ;
			if ( $find_manual_product_in_cart ) {
				WC()->cart->remove_cart_item( $find_manual_product_in_cart ) ;
			}
		}

		foreach ( $get_available_cart_contents as $key => $value ) {

			$find_automatic_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $automatic_donation_product ) ;

			// include or exclude product check
			if ( ! self::filter_by_product( $value ) ) {
				if ( ! empty( $find_automatic_product_in_cart ) ) {
					WC()->cart->remove_cart_item( $find_automatic_product_in_cart ) ;
				}

				return ;
			}

			// add automatic donation to cart.
			if ( empty( $find_automatic_product_in_cart ) ) {
				WC()->cart->add_to_cart( $automatic_donation_product ) ;
			}
		}
	}

	// automatic product add functionality for force option enabled.
	public static function add_automatic_product_to_cart_for_force_option() {
		$automatic_donation_is_enabled = get_option( '_fp_donation_automatic_enable' ) ;
		$automatic_donation_product    = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;
		$manual_donation_product       = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products' ) ) ;
		$force_donation                = get_option( '_fp_force_donation_automatic' ) ;
		$get_available_cart_contents   = WC()->cart->cart_contents ;
		$already_donated_products      = WC()->session->get( 'fp_donation_cart_product_auto' ) ? WC()->session->get( 'fp_donation_cart_product_auto' ) : '' ;

		if ( ! fp_donation_check_is_array( $get_available_cart_contents ) ) {
			return ;
		}

		foreach ( $get_available_cart_contents as $key => $value ) {

			if ( ( 'yes' == $automatic_donation_is_enabled ) && ( ! empty( $automatic_donation_product ) ) ) {

				// remove old donation product when donation product was changed.
				if ( ! empty( $already_donated_products ) && ( $already_donated_products != $automatic_donation_product ) ) {
					$find_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $already_donated_products ) ;

					if ( ! empty( $find_product_in_cart ) ) {
						WC()->cart->remove_cart_item( $find_product_in_cart ) ;
					}
				}

				// include or exclude product check
				if ( ! self::filter_by_product( $value ) ) {
					$find_automatic_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $automatic_donation_product ) ;

					if ( ! empty( $find_automatic_product_in_cart ) ) {
						WC()->cart->remove_cart_item( $find_automatic_product_in_cart ) ;
					}

					return ;
				}

				// remove manual donation from cart.
				if ( ! empty( $manual_donation_product ) && ( $manual_donation_product != $automatic_donation_product ) ) {
					$find_manual_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $manual_donation_product ) ;

					if ( ! empty( $find_manual_product_in_cart ) ) {
						WC()->cart->remove_cart_item( $find_manual_product_in_cart ) ;
					}
				}

				// add automatic donation to cart.
				$find_automatic_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $automatic_donation_product ) ;

				if ( empty( $find_automatic_product_in_cart ) ) {
					if ( 'no' != $force_donation ) {
						WC()->cart->add_to_cart( $automatic_donation_product ) ;
					}
				}
			} else {
				// remove automatic donation from cart when automatic was disabled.
				if ( $manual_donation_product != $automatic_donation_product ) {
					if ( $value[ 'product_id' ] == $automatic_donation_product ) {
						$cart_item_key = FP_Donation_Rewards_Cart::generate_cart_item_key( $value[ 'product_id' ] ) ;
						WC()->cart->remove_cart_item( $cart_item_key ) ;
					}
				}
			}
		}
	}

	// remove automatic product from cart
	public static function remove_automatic_product_from_cart( $removed_cart_item_key, $cart ) {

		// check automatic donation enabled or not.
		$automatic_donation_is_enabled = get_option( '_fp_donation_automatic_enable' ) ;
		if ( ( 'yes' != $automatic_donation_is_enabled ) ) {
			return ;
		}

		// check cart content
		$get_available_cart_contents = WC()->cart->cart_contents ;
		if ( ! fp_donation_check_is_array( $get_available_cart_contents ) ) {
			return ;
		}

		$force_donation             = get_option( '_fp_force_donation_automatic' ) ;
		$automatic_donation_product = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;

		foreach ( $get_available_cart_contents as $key => $value ) {

			if ( 'no' == $force_donation ) {

				if ( $value[ 'product_id' ] == $automatic_donation_product ) {
					WC()->cart->remove_cart_item( $removed_cart_item_key ) ;
				}
			}

			// get available product ids from cart
			if ( version_compare( WC_VERSION , '3.0' , '<' ) ) {
				$product_ids[] = $value[ 'data' ]->id ; // Before version 3.0
			} else {
				$product_ids[] = $value[ 'data' ]->get_id() ; // For version 3 or more
			}
		}

		// check available product from cart either donation product
		if ( in_array( $automatic_donation_product , $product_ids ) ) {
			$automatic_donation_array = array( $automatic_donation_product ) ;
			$remaining_cart_ids       = array_diff( $product_ids , $automatic_donation_array ) ;

			// if no product found remove donation product
			if ( ! fp_donation_check_is_array( $remaining_cart_ids ) ) {
				$cart_item_key = FP_Donation_Rewards_Cart::generate_cart_item_key( $automatic_donation_product ) ;
				WC()->cart->remove_cart_item( $cart_item_key ) ;
			}
		}
	}

	// Automatic Donation Calculate function.
	public static function calculate_funtion_for_automatic_donation() {
		global $wp ;
		$new_auto_donation             = array() ;
		$another_alteration            = array() ;
		$price_product                 = '' ;
		$current_page                  = home_url( $wp->request ) ;
		$donation_for_person           = isset( $_REQUEST[ 'fp_donation_person' ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'fp_donation_person' ] ) ) : '' ;
		$automatic_donation_is_enabled = get_option( '_fp_donation_automatic_enable' ) ;
		$automatic_donation_product    = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;
		$list_of_ids                   = array( $automatic_donation_product ) ;
		$auto_donation_type            = get_option( '_fp_automatic_donation_value' ) ; // Percentage of Cart Total/Fixed Value(1/2)
		$get_percentage_charity        = get_option( '_fp_donation_automatic_percentage_value' ) ;
		$auto_donation_fixed_value     = get_option( '_fp_donation_automatic_fixed_value' ) ;
		$force_donation                = get_option( '_fp_force_donation_automatic' ) ;
		$auto_donation_value_add_sub   = get_option( '_fp_donation_value_add_sub' ) ; // Sub from CT/Add to ExCT 1/2
		$get_available_cart_contents   = WC()->cart->cart_contents ;

		if ( fp_donation_check_is_array( $get_available_cart_contents ) ) {
			$count = 0 ;

			foreach ( $get_available_cart_contents as $key => $value ) {

				if ( ( 'yes' == $automatic_donation_is_enabled ) && ( ! empty( $automatic_donation_product ) ) ) {

					if ( ! in_array( $value[ 'product_id' ] , $list_of_ids ) ) {
						if ( self::filter_by_product( $value ) ) {
							$find_automatic_product_in_cart = sumo_check_auto_donation_pro_is_in_cart( $automatic_donation_product ) ;

							if ( $find_automatic_product_in_cart ) {
								$product_id = $value[ 'variation_id' ] ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;
								$each_price = get_post_meta( $product_id , '_price' , true ) ;

								// bundled product compatibility.
								if ( function_exists( 'wc_pb_get_bundled_cart_item_container' ) ) {
									if ( wc_pb_get_bundled_cart_item_container( $value ) ) {
										continue ;
									} elseif ( wc_pb_is_bundle_container_cart_item( $value ) ) {
										$each_price = FP_Donation_Compatibility_Function::get_bundled_product_cart_item_price( $value ) ;
									}
								}

								$quantity      = $value[ 'quantity' ] ;
								$price_product = $each_price * $quantity ;

								if ( '1' == $auto_donation_type ) {
									$percentage_calculation                      = $price_product * ( $get_percentage_charity / 100 ) ;
									$new_auto_donation[ $value[ 'product_id' ] ] = isset( $new_auto_donation[ $value[ 'product_id' ] ] ) ? $new_auto_donation[ $value[ 'product_id' ] ] + $percentage_calculation : $percentage_calculation ;

									if ( '1' == $auto_donation_value_add_sub ) {
										$altered_price = ( $price_product - $percentage_calculation ) / $quantity ;
										$value[ 'data' ]->set_price( $altered_price ) ;
									}
								}
							}
							$count++ ;
						}
					} elseif ( $value[ 'product_id' ] == $automatic_donation_product ) {
							$another_alteration[ $value[ 'product_id' ] ] = $value[ 'data' ] ;
					}
				} else {
					// Added subscription product compatibility.
					if ( ( $value[ 'data' ]->is_type( 'subscription' ) ) || ( $value[ 'data' ]->is_type( 'variable-subscription' ) ) ) {
						continue ;
					}

					$price_product = $value[ 'data' ]->get_price() ;
					$value[ 'data' ]->set_price( $price_product ) ;
					continue ;
				}
			}

			if ( $another_alteration ) {
				$new_object = $another_alteration[ $automatic_donation_product ] ;

				if ( '1' == $auto_donation_type ) {
					$new_object->set_price( array_sum( $new_auto_donation ) ) ;
				} else {
					$new_object->set_price( '' != $auto_donation_fixed_value ? $auto_donation_fixed_value : '0'  ) ;
				}

				WC()->session->set( 'fp_donation_cart_amount_auto' , $new_object->get_price() ) ;
				WC()->session->set( 'fp_donation_cart_product_auto' , $automatic_donation_product ) ;
				// donors table record functionality
				WC()->session->set( 'fp_donation_product' , $automatic_donation_product ) ;
				WC()->session->set( 'fp_donation_person' , $donation_for_person ) ;
				WC()->session->set( 'fp_donation_amount' , $new_object->get_price() ) ;
				WC()->session->set( 'fp_donation_url' , $current_page ) ;
			}

			WC()->session->set( 'fp_donation_amount_auto' , array_sum( $new_auto_donation ) ) ;
			WC()->session->set( 'fp_donation_product_auto' , $automatic_donation_product ) ;
		}
	}

	// Product shouldn't be taxable
	public static function make_product_not_taxable( $taxable, $product ) {
		$automatic_donation_product = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;

		// check automatic product was empty
		if ( ! isset( $automatic_donation_product ) ) {
			return $taxable ;
		}

		// check tax option enable or not
		$product_id = sumo_donation_get_product_id( $product ) ;

		if ( $product_id == $automatic_donation_product ) {
			if ( 'no' === get_option( '_fp_donation_automatic_including_tax' ) ) {
				return false ;
			}
		}

		return $taxable ;
	}

	// Function to make filtering option by product as well as category
	public static function filter_by_product( $value ) {
		$check_type_for_product = get_option( '_fp_donation_automatic_product_type' ) ;

		// include Products.
		if ( '2' == $check_type_for_product ) {
			$get_included_products = get_option( '_fp_donation_automatic_include_selected_products' ) ;

			if ( ! fp_donation_check_is_array( $get_included_products ) ) {
				return false ;
			}

			$productid = '' != $value[ 'variation_id' ] ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;

			if ( in_array( $productid , ( array ) $get_included_products ) ) {
				return true ;
			}

			return false ;
		}
		// Exclude Products.
		if ( '3' == $check_type_for_product ) {
			$get_excluded_products = get_option( '_fp_donation_automatic_exclude_selected_products' ) ;

			if ( ! fp_donation_check_is_array( $get_excluded_products ) ) {
				return true ;
			}

			$productid = $value[ 'variation_id' ] ? $value[ 'variation_id' ] : $value[ 'product_id' ] ;

			if ( in_array( $productid , $get_excluded_products ) ) {
				return false ;
			}

			return true ;
		}

		return true ;
	}

	// quantity set as read only
	public function cart_item_quantity( $quantity, $cart_item_key ) {
		// check automatic donation enabled or not.
		$automatic_donation_is_enabled = get_option( '_fp_donation_automatic_enable' ) ;
		if ( ( 'yes' != $automatic_donation_is_enabled ) ) {
			return $quantity ;
		}

		// check cart content
		$get_available_cart_contents = WC()->cart->cart_contents ;
		if ( ! fp_donation_check_is_array( $get_available_cart_contents ) ) {
			return ;
		}

		// automatic product in cart.
		$automatic_donation_product = sumo_product_id_from_other_lang( get_option( 'ds_select_particular_products_automatic' ) ) ;

		//compare reward product in cart
		foreach ( WC()->cart->get_cart() as $cart_item ) {
			if ( $cart_item[ 'key' ] == $cart_item_key ) {
				$product_id = ! empty( $cart_item[ 'variation_id' ] ) ? $cart_item[ 'variation_id' ] : $cart_item[ 'product_id' ] ;

				if ( $product_id == $automatic_donation_product ) {
					$quantity = $cart_item[ 'quantity' ] ;
				}
			}
		}
		return $quantity ;
	}
}

new FP_Donation_Automatic_Tab() ;
