<?php

class FP_Donation_General_Tab {

	// Construct the Class
	public function __construct() {

		add_action( 'woocommerce_donationsystem_settings_tabs_array' , array( $this, 'initialize_tab' ) ) ;

		add_action( 'woocommerce_donationsystem_settings_tabs_fp_donationsystem' , array( $this, 'initialize_visual_appearance_admin_fields' ) ) ;

		add_action( 'woocommerce_update_options_fp_donationsystem' , array( $this, 'update_data_from_admin_fields' ) ) ;

		if ( isset( $_REQUEST[ 'reset_fp_donationsystem' ] ) ) {
			add_action( 'admin_head' , array( $this, 'reset_option_to_donationsystem' ) ) ;
		}

		add_action( 'woocommerce_admin_field__fp_donation_new_product' , array( $this, 'initialize_button_to_make_new_product' ) ) ;

		add_action( 'woocommerce_admin_field__fp_choose_existing_product' , array( $this, 'initialize_function_for_single_selection_product' ) ) ;

		add_action( 'admin_init' , array( $this, 'add_option_to_donationsystem' ) ) ;

		add_action( 'woocommerce_admin_field_fp_info_shortcode' , array( $this, 'info_shortcode_donation_form' ) ) ;

		add_action( 'woocommerce_admin_field_fp_info_shortcode_table' , array( $this, 'info_shortcode_donation_table' ) ) ;
	}

	public static function initialize_tab( $settings_tab ) {
		if ( ! is_array( $settings_tab ) ) {
			$settings_tab = ( array ) $settings_tab ;
		}
		$settings_tab[ 'fp_donationsystem' ] = __( 'General' , 'donationsystem' ) ;
		return array_filter( $settings_tab ) ;
	}

	public static function initialize_admin_fields() {
		global $woocommerce ;
		return apply_filters( 'woocommerce_donationsystem_general_settings' , array(
			array(
				'name' => __( 'Donation Product Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_donationsystem_general_settings',
			),
			array(
				'name'     => __( 'Donation Product Setup' , 'donationsystem' ),
				'desc'     => __( 'Choose Donation Product from Existing/New' , 'donationsystem' ),
				'id'       => '_fp_donation_product_selection',
				'css'      => 'min-width:150px;',
				'std'      => '1',
				'class'    => '_fp_donation_product_selection',
				'default'  => '1',
				'newids'   => '_fp_donation_product_selection',
				'type'     => 'select',
				'options'  => array(
					'1' => __( 'Existing Product' , 'donationsystem' ),
					'2' => __( 'Create New Product' , 'donationsystem' ),
				),
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Title for New Donation Product' , 'donationsystem' ),
				'desc'     => __( 'Enter Title for New Donation Product' , 'donationsystem' ),
				'id'       => '_fp_donation_new_product_title',
				'css'      => 'min-width:150px;',
				'std'      => 'Donation',
				'class'    => '',
				'default'  => 'Donation',
				'newids'   => '_fp_donation_new_product_title',
				'type'     => 'text',
				'desc_tip' => true,
			),
			array(
				'name' => __( 'Create New Product' , 'donationsystem' ),
				'type' => '_fp_donation_new_product',
			),
			array(
				'name'     => __( 'Choose Existing Product for Donation' , 'donationsystem' ),
				'id'       => '_fp_donation_existing_product',
				'css'      => 'min-width:150px;',
				'std'      => '',
				'class'    => '',
				'default'  => '',
				'newids'   => '_fp_donation_existing_product',
				'type'     => '_fp_choose_existing_product',
				'desc_tip' => false,
			),
			array(
				'type' => 'sectionend',
				'id'   => '_donationsystem_general_settings',
			),
			array(
				'name' => __( 'Donation Restriction Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donation_restriction_settings',
			),
			array(
				'name'     => __( 'Hide Donation Form & Fly Box when Donation product already is in Cart' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_form_when_dp_aisin_cart',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_form_when_dp_aisin_cart',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'type' => 'sectionend',
				'id'   => '_fp_donation_restriction_settings',
			),
			array(
				'name' => __( 'Donation Settings for Manual' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donation_settings_manual',
			),
			array(
				'name'     => __( 'Force Manual Donation' , 'donationsystem' ),
				'id'       => '_fp_force_donation_manual',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_force_donation_manual',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'type' => 'sectionend',
				'id'   => '_fp_donation_settings_manual',
			),
			array(
				'name' => __( 'Donation Table Shortcode Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donation_product_table_settings',
			),
			array(
				'name'     => __( 'Show Donation Table using Shortcode' , 'donationsystem' ),
				'id'       => '_fp_donation_display_table',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_donation_display_table',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'type' => 'fp_info_shortcode_table',
			),
			array(
				'name'     => __( 'Show S.No Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_sno',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_table_sno',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Donor Name Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_name',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_table_name',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Donor Email Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_email',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_table_email',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Donated Amount Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_amount',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_table_amount',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Status Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_status',
				'css'      => '',
				'std'      => 'yes',
				'class'    => '',
				'default'  => 'yes',
				'newids'   => '_fp_hide_donation_table_status',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Donor Memorable Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_memorable',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_hide_donation_table_memorable',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Donated Honorable Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_honorable',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_hide_donation_table_honorable',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Show Reason For Column from Donation Table' , 'donationsystem' ),
				'id'       => '_fp_hide_donation_table_reason',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_hide_donation_table_reason',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array( 'type' => 'sectionend', 'id' => '_fp_donation_product_table_settings' ),
			array(
				'name' => __( 'Donate Button Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donation_button_settings',
			),
			array(
				'name'     => __( 'Add Custom Class Name for Donate Button' , 'donationsystem' ),
				'type'     => 'textarea',
				'id'       => '_fp_donation_custom_class_name',
				'css'      => '',
				'std'      => '',
				'class'    => '',
				'default'  => '',
				'newids'   => '_fp_donation_custom_class_name',
				'desc'     => __( 'Enter Class Name for Donate Button and you can add multiple class name with one space' , 'donationsystem' ),
				'desc_tip' => true,
			),
			array( 'type' => 'sectionend', 'id' => '_fp_donation_button_settings' ),
			array(
				'name' => __( 'Donation Reason' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_fp_donation_reason',
			),
			array(
				'name'     => __( 'Enable to Display the Donation Reason' , 'donationsystem' ),
				'id'       => '_fp_show_donation_reason',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_show_donation_reason',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'    => __( 'Label for Donation Reason Type' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_reason_type',
				'css'     => '',
				'std'     => 'Select Reason Type',
				'class'   => '',
				'default' => 'Select Reason Type',
				'newids'  => '_fp_donation_form_label_reason_type',
				'type'    => 'text',
			),
			array(
				'name'    => __( 'Label for Donation Choose an Option' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_choose_option',
				'std'     => 'Choose an Option',
				'default' => 'Choose an Option',
				'newids'  => '_fp_donation_form_label_choose_option',
				'type'    => 'text',
			),
			array(
				'name'    => __( 'Label for Donation Memorable' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_memorable',
				'std'     => 'Memorable',
				'default' => 'Memorable',
				'newids'  => '_fp_donation_form_label_memorable',
				'type'    => 'text',
			),
			array(
				'name'    => __( 'Label for Donation Honorable' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_honorable',
				'std'     => 'Honorable',
				'default' => 'Honorable',
				'newids'  => '_fp_donation_form_label_honorable',
				'type'    => 'text',
			),
			array(
				'name'    => __( 'Label for Donation Reason' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_reason',
				'css'     => '',
				'std'     => 'Reason',
				'class'   => '',
				'default' => 'Reason',
				'newids'  => '_fp_donation_form_label_reason',
				'type'    => 'text',
			),
			array(
				'name'    => __( 'Label for Name' , 'donationsystem' ),
				'id'      => '_fp_donation_form_label_donating_to',
				'css'     => '',
				'std'     => 'Name',
				'class'   => '',
				'default' => 'Name',
				'newids'  => '_fp_donation_form_label_donating_to',
				'type'    => 'text',
			),
			array(
				'name'     => __( 'Enable Anonymous' , 'donationsystem' ),
				'desc'     => __( 'Enable this option to display the donor name as anonymous in the Donation table if the donor accepts anonymous in the frontend.' , 'donationsystem' ),
				'id'       => 'fp_doantion_anonymous_field_enable',
				'std'      => 'no',
				'default'  => 'no',
				'newids'   => 'fp_doantion_anonymous_field_enable',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'    => __( 'Enter custom caption of Anonymous text(only for frontend display)' , 'donationsystem' ),
				'id'      => 'fp_donation_anonymous_label',
				'std'     => 'Mark as Anonymous (optional)',
				'default' => 'Mark as Anonymous (optional)',
				'newids'  => 'fp_donation_anonymous_label',
				'type'    => 'text',
			),
			array( 'type' => 'sectionend', 'id' => '_fp_donation_reason' ),
				) ) ;
	}

	public static function initialize_visual_appearance_admin_fields() {
		woocommerce_admin_fields( self::initialize_admin_fields() ) ;
	}

	public static function update_data_from_admin_fields() {
		woocommerce_update_options( self::initialize_admin_fields() ) ;
		$manual_donation_product = isset( $_REQUEST[ 'ds_select_particular_products' ][ 0 ] ) ? wc_clean( wp_unslash( $_REQUEST[ 'ds_select_particular_products' ][ 0 ] ) ) : '' ;
		update_option( 'ds_select_particular_products' , $manual_donation_product ) ;
	}

	public static function info_shortcode_donation_form() {
		?>
		<tr>
			<td class="fp_info_donation_form">
				<h3>[fp_donation_form]</h3>
				<p><?php esc_html_e( 'Use this Shortcode in any Post/Page to display Donation Form' , 'donationsystem' ) ; ?></p>
			</td>
		</tr>
		<?php
	}

	public static function info_shortcode_donation_table() {
		?>
		<tr>
			<td class="fp_info_donation_table">
				<h3>[fp_donation_table]</h3>
				<p><?php esc_html_e( 'Use this Shortcode in any Post/Page to display Donation Table' , 'donationsystem' ) ; ?></p>
			</td>
		</tr>
		<?php
	}

	public static function initialize_button_to_make_new_product() {
		ob_start() ;
		?>
		<tr>
			<th>
				<?php esc_html_e( 'Create New Donation Product' , 'donationsystem' ) ; ?>
			</th>
			<td>
				<input type="submit" class="fp_donation_new_product button-primary" value="Create New Donation Product" name="fp_donation_new_product"/>

			</td>
		</tr>

		<?php
	}

	// Choose Single Selection New Product
	public static function initialize_function_for_single_selection_product() {
		global $woocommerce ;
		?>
		<tr valign="top">
			<th class="titledesc" scope="row">
				<label for="ds_select_particular_products"><?php esc_html_e( 'Product that should be used for Donation (Product should be non-taxable and non-shippable)' , 'donationsystem' ) ; ?></label>
			</th>
			<td class="forminp forminp-select">
				<?php
				$selected_val = array_filter( ( array ) get_option( 'ds_select_particular_products' ) ) ;

				$product_selection_args = array(
					'id'          => 'ds_select_particular_products',
					'class'       => 'ds_select_particular_products',
					'name'        => 'ds_select_particular_products',
					'action'      => 'fp_donation_simple_product_search',
					'placeholder' => esc_html__( 'Search a Product' , 'donationsystem' ),
					'multiple'    => false,
					'options'     => $selected_val,
						) ;
				donation_system_select2_html( $product_selection_args ) ;
				?>
			</td>
		</tr>
		<?php
	}

	// Create Product with all the meta values


	public static function add_option_to_donationsystem() {
		foreach ( self::initialize_admin_fields() as $setting ) {
			if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
				add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
			}
		}
	}

	public static function reset_option_to_donationsystem() {
		foreach ( self::initialize_admin_fields()as $setting ) {
			if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
				delete_option( $setting[ 'newids' ] ) ;
				add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
			}
		}
	}
}

new FP_Donation_General_Tab() ;
