<?php

class FP_Donation_Reset_Tab {

	// Construct the Donation Reset
	public function __construct() {

		add_action( 'woocommerce_donationsystem_settings_tabs_array' , array( $this, 'initialize_tab' ) ) ;

		add_action( 'woocommerce_donationsystem_settings_tabs_fp_donationsystem_reset' , array( $this, 'initialize_visual_appearance_admin_fields' ) ) ;

		add_action( 'woocommerce_update_options_fp_donationsystem_reset' , array( $this, 'update_data_from_admin_fields' ) ) ;

		add_action( 'admin_init' , array( $this, 'add_option_to_donationsystem' ) ) ;

		add_action( 'woocommerce_admin_field_fp_reset_data' , array( $this, 'add_reset_button_in_tab' ) ) ;
	}

	// Initialize the Settings from Donation Messages

	public static function initialize_tab( $settings_tab ) {
		if ( ! is_array( $settings_tab ) ) {
			$settings_tab = ( array ) $settings_tab ;
		}
		$settings_tab[ 'fp_donationsystem_reset' ] = __( 'Reset' , 'donationsystem' ) ;
		return array_filter( $settings_tab ) ;
	}

	// Initialize Settings Page array

	public static function initialize_admin_fields() {
		global $woocommerce ;
		return apply_filters( 'woocommerce_donationsystem_reset_settings' , array(
			array(
				'name' => __( 'Reset Settings' , 'donationsystem' ),
				'type' => 'title',
				'id'   => '_donationsystem_reset_settings',
			),
			array(
				'name'     => __( 'Reset Donation Table' , 'donationsystem' ),
				'id'       => '_fp_reset_donar_info',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_reset_donar_info',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'name'     => __( 'Reset Plugin Settings (All Tabs)' , 'donationsystem' ),
				'id'       => '_fp_reset_entire_settings',
				'css'      => '',
				'std'      => 'no',
				'class'    => '',
				'default'  => 'no',
				'newids'   => '_fp_reset_entire_settings',
				'type'     => 'checkbox',
				'desc_tip' => true,
			),
			array(
				'type' => 'fp_reset_data',
			),
			array(
				'type' => 'sectionend',
				'id'   => '_donationsystem_reset_settings',
			),
				) ) ;
	}

	public static function initialize_visual_appearance_admin_fields() {
		woocommerce_admin_fields( self::initialize_admin_fields() ) ;
	}

	public static function update_data_from_admin_fields() {
		woocommerce_update_options( self::initialize_admin_fields() ) ;
	}

	public static function add_option_to_donationsystem() {
		foreach ( self::initialize_admin_fields() as $setting ) {
			if ( isset( $setting[ 'newids' ] ) && isset( $setting[ 'std' ] ) ) {
				add_option( $setting[ 'newids' ] , $setting[ 'std' ] ) ;
			}
		}
	}

	public static function add_reset_button_in_tab() {
		?>
		<tr>
			<td>
				<input type="submit" value="<?php esc_html_e( 'Reset' , 'donationsystem' ) ; ?>" id="fp_reset_settings_data" class="fp-reset-settings-data button-primary"/>
				<div class="fp_reset_response"></div>
			</td>
		</tr>
		<?php
	}
}

new FP_Donation_Reset_Tab() ;
