<?php

class FP_Donation_Common_Function {

	// Construct the Common Function
	public function __construct() {
	}

	/*
	 * Function for searching Product with backward compatibility
	 * @params
	 * $product_and_variation = 1; // If one means it is for only simple product, if it is 2 then both product and variation should apply
	 * $multiple = true/false, if false it allow single selection, if it is true then it will allow multiple
	 */

	public static function search_product_selection( $product_and_variation, $multiple, $name, $iteration, $value, $subname, $required = '' ) {
		global $woocommerce ;

		if ( $multiple ) {
			$new_attribute = 'multiple' ;

			if ( '' != $iteration ) {
				$multiple_name = $name . '[' . $iteration . ']'
						. '[' . $subname . ']' ;
			} else {
				$multiple_name = $name ;
			}
		} else {
			$new_attribute = '' ;

			if ( '' != $iteration ) {
				$multiple_name = $name . '[' . $iteration . ']'
						. '[' . $subname . ']' ;
			} else {
				$multiple_name = $name ;
			}
		}

		if ( '' == $iteration ) {
			$option_name = get_option( $name ) ;
		} else {
			$option_name = $value[ $subname ] ;
		}

		$list_of_produts = $option_name ;

		if ( ! is_array( $list_of_produts ) ) {
			$product_ids = array_filter( array_map( 'absint' , ( array ) explode( ',' , $list_of_produts ) ) ) ;
		} else {
			$product_ids = $list_of_produts ;
		}

		$class    = '' ;
		$selected = $product_ids ;
		sumo_donation_product_select2( $multiple_name , $name , $class , $selected , $multiple , $product_and_variation , $required ) ;
	}

	public static function create_new_product( $title ) {
		$args          = array(
			'post_author'  => get_current_user_id(),
			'post_content' => '',
			'post_status'  => 'publish',
			'post_title'   => $title,
			'post_parent'  => '',
			'post_type'    => 'product',
				) ;
		$post_id       = wp_insert_post( $args ) ;
		$meta_updation = array(
			'_visibility'        => 'visible',
			'_stock_status'      => 'instock',
			'total_sales'        => '0',
			'_downloadable'      => 'no',
			'_virtual'           => 'yes',
			'_regular_price'     => '0',
			'_price'             => '0',
			'_sale_price'        => '',
			'_featured'          => '',
			'_sold_individually' => 'yes',
			'_manage_stock'      => 'no',
			'_backorders'        => 'no',
			'_stock'             => '',
				) ;
		foreach ( $meta_updation as $key => $value ) {
			update_post_meta( $post_id , $key , $value ) ;
		}
		return $post_id ;
	}

	// Worth Cost of All Products
	public static function worth_of_products( $products ) {
		$amount = 0 ;
		if ( ! is_array( $products ) ) {
			$explode = explode( ',' , $products ) ;
			if ( is_array( $explode ) && ! empty( $explode ) ) {

				foreach ( $explode as $key => $value ) {
					if ( $value ) {
						$product = sumo_donation_get_product( $value ) ;
						$amount  += $product->get_price() ;
					} else {
						$amount += 0 ;
					}
				}
			}
		} elseif ( is_array( $products ) && ( ! empty( $products ) ) ) {
			foreach ( $products as $key => $value ) {
				if ( $value ) {
					$product = sumo_donation_get_product( $value ) ;
					$amount  += $product->get_price() ;
				} else {
					$amount += 0 ;
				}
			}
		}
		return $amount ;
	}

	// List of Product Title
	public static function list_of_product_title( $products ) {
		ob_start() ;
		echo '<ul>' ;
		if ( ! is_array( $products ) ) {
			$explode = explode( ',' , $products ) ;
			if ( is_array( $explode ) && ! empty( $explode ) ) {

				foreach ( $explode as $value ) {
					if ( $value ) {
						$product = sumo_donation_get_product( $value ) ;
						$id      = sumo_donation_get_product_parent_id( $product ) ;
						$product = get_permalink( $id ) ;
						$title   = get_the_title( $value ) ;
						echo '<li><a href=' . esc_url( $product ) . '>' . esc_html( $title ) . '</a></li>' ;
					}
				}
			}
		} elseif ( fp_donation_check_is_array( $products ) ) {
			foreach ( $products as $value ) {
				if ( $value ) {
					$product = sumo_donation_get_product( $value ) ;
					$id      = sumo_donation_get_product_parent_id( $product ) ;
					$product = get_permalink( $id ) ;
					$title   = get_the_title( $value ) ;
					echo '<li><a href=' . esc_url( $product ) . '>' . esc_html( $title ) . '</a></li>' ;
				}
			}
		}
		echo '</ul>' ;
		return ob_get_clean() ;
	}
}

new FP_Donation_Common_Function() ;

function sumo_donation_product_select2( $name, $id, $class, $selected, $multiple, $product_and_variation, $required = '' ) {
	$array         = $multiple ? '[]' : '' ;
	$data_multiple = $multiple ? 'multiple="multiple"' : '' ;

	if ( '1' == $product_and_variation ) {
		$product_selection = 'woocommerce_json_search_products' ;
	} else {
		$product_selection = 'woocommerce_json_search_products_and_variations' ;
	}

	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		?>
		<select <?php echo esc_attr( $required ) ; ?> class="wc-product-search fp-donation-select-search <?php echo esc_attr( $class ) ; ?>" data-action="<?php echo esc_attr( $product_selection ) ; ?>" name="<?php echo esc_attr( $name . $array ) ; ?>" id="<?php echo esc_attr( $id ) ; ?>" <?php echo esc_attr( $data_multiple ) ; ?> data-placeholder="<?php esc_attr_e( 'Search for a product&hellip;' , 'woocommerce' ) ; ?>">
			<?php
			if ( ! empty( $selected ) ) {
				foreach ( $selected as $each_value ) {
					$product = sumo_donation_get_product( $each_value ) ;
					if ( is_object( $product ) ) {
						echo '<option value="' . esc_attr( $each_value ) . '" ' . selected( 1 , 1 ) . '>' . wp_kses_post( $product->get_formatted_name() ) . '</option>' ;
					}
				}
			}
			?>
		</select>
		<?php
	} elseif ( ( float ) WC()->version > ( float ) '2.2.0' && ( float ) WC()->version < ( float ) '3.0.0' ) {
		?>
		<input type="hidden" class="wc-product-search fp-donation-input-search <?php echo esc_attr( $class ) ; ?>" data-action="<?php echo esc_attr( $product_selection ) ; ?>" name="<?php echo esc_attr( $name ) ; ?>" id="<?php echo esc_attr( $id ) ; ?>" data-placeholder="<?php esc_attr_e( 'Search for a product&hellip;' , 'woocommerce' ) ; ?>" data-multiple="<?php echo esc_attr( $multiple ) ; ?>" data-selected="
		<?php
		$json_ids = array() ;
		if ( ! empty( $selected ) ) {
			foreach ( $selected as $product_id ) {
				$product = sumo_donation_get_product( $product_id ) ;
				if ( is_object( $product ) ) {
					$json_ids[ $product_id ] = wp_kses_post( $product->get_formatted_name() ) ;
				}
			}
		}
		echo esc_attr( json_encode( $json_ids ) ) ;
		?>
			   " value="<?php echo esc_attr( implode( ',' , array_keys( $json_ids ) ) ) ; ?>" />
			   <?php
	} else {
		?>
		<select <?php echo esc_attr( $required ) ; ?> id='<?php echo esc_attr( $id ) ; ?>' name="<?php echo esc_attr( $name . $array ) ; ?>" class="<?php echo esc_attr( $class ) ; ?>" <?php echo esc_attr( $data_multiple ) ; ?>>
			<?php
			if ( ! empty( $selected ) ) {
				$list_of_produts = $selected ;
				foreach ( $list_of_produts as $rs_free_id ) {
					$product = sumo_donation_get_product( $product_id ) ;
					if ( is_object( $product ) ) {
						echo '<option value="' . esc_attr( $rs_free_id ) . '" ' . selected( 1 , 1 )
						. '> #' . esc_html( $rs_free_id ) . ' &ndash; ' . esc_html( get_the_title( $rs_free_id ) ) . '</option>' ;
					}
				}
			} else {
				?>
				<option value=""></option> 
				<?php
			}
			?>
		</select>
		<?php
	}
}

function sumo_donation_get_product_id( $product ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$id = $product->get_id() ;
	} else {
		$id = $product->variation_id ? $product->variation_id : $product->id ;
	}
	return $id ;
}

function sumo_donation_get_product_parent_id( $product ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$id = $product->is_type( 'variation' ) ? $product->get_parent_id() : $product->get_id() ;
	} else {
		$id = $product->id ;
	}
	return $id ;
}

function sumo_donation_get_product( $product_id ) {
	if ( function_exists( 'wc_get_product' ) ) {
		$product = wc_get_product( $product_id ) ;
	} elseif ( function_exists( 'get_product' ) ) {
			$product = get_product( $product_id ) ;
	}
	return $product ;
}

function sumo_donation_get_product_type( $product ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$type = $product->get_type() ;
	} else {
		$type = $product->product_type ;
	}
	return $type ;
}

function sumo_donation_get_order_billing_last_name( $order ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$billing_last_name = $order->get_billing_last_name() ;
	} else {
		$billing_last_name = $order->billing_last_name ;
	}
	return $billing_last_name ;
}

function sumo_donation_get_order_billing_first_name( $order ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$billing_first_name = $order->get_billing_first_name() ;
	} else {
		$billing_first_name = $order->billing_first_name ;
	}
	return $billing_first_name ;
}

function sumo_donation_get_order_billing_email( $order ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$billing_email = $order->get_billing_email() ;
	} else {
		$billing_email = $order->billing_email ;
	}
	return $billing_email ;
}

function sumo_donation_get_order_status( $order ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$status = $order->get_status() ;
	} else {
		$status = $order->status ;
	}
	return $status ;
}

function sumo_donation_get_order_date( $order ) {
	if ( ( float ) WC()->version >= ( float ) '3.0.0' ) {
		$date_created = wc_rest_prepare_date_response( $order->get_date_created() , false ) ;
	} else {
		$date_created = $order->order_date ;
	}
	return $date_created ;
}

function sumo_check_global_settings_to_display_df() {
	if ( 'yes' == get_option( '_fp_hide_donation_form_when_dp_aisin_cart' ) ) {

		// Automatic donation product in cart check
		if ( 'yes' == get_option( '_fp_donation_automatic_enable' ) ) {
			return false ;
		}

		// manual donation product in cart check
		$product_id           = get_option( 'ds_select_particular_products' ) ;
		$find_product_in_cart = '' ;

		if ( $product_id ) {
			$cart_id              = FP_Donation_Rewards_Cart::generate_cart_item_key( $product_id ) ;
			$find_product_in_cart = WC()->cart->find_product_in_cart( $cart_id ) ;
		}

		if ( $find_product_in_cart ) {
			return false ;
		}
	}
	return true ;
}

function sumo_product_id_from_other_lang( $product_id ) {
	global $sitepress ;
	$id_from_other_lang = '' ;
	if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && is_object( $sitepress ) ) {
		$trid         = $sitepress->get_element_trid( $product_id ) ;
		$translations = $sitepress->get_element_translations( $trid ) ;
		foreach ( $translations as $translation ) {
			if ( ICL_LANGUAGE_CODE == $translation->language_code ) {
				$id_from_other_lang = $translation->element_id ;
			}
		}
		$product_id = $id_from_other_lang ;
	}
	return $product_id ;
}

function sumo_check_auto_donation_pro_is_in_cart( $product_id ) {
	global $sitepress, $woocommerce ;
	$find_product_in_cart = '' ;
	$id_from_other_lang   = '' ;

	if ( is_plugin_active( 'sitepress-multilingual-cms/sitepress.php' ) && is_object( $sitepress ) ) {
		$trid         = $sitepress->get_element_trid( $product_id ) ;
		$translations = $sitepress->get_element_translations( $trid ) ;
		foreach ( $translations as $translation ) {
			$id_from_other_lang = $translation->element_id ;
			if ( $id_from_other_lang ) {
				$cart_id              = FP_Donation_Rewards_Cart::generate_cart_item_key( $id_from_other_lang ) ;
				$find_product_in_cart = $woocommerce->cart->find_product_in_cart( $cart_id ) ;
			}
			if ( $find_product_in_cart ) {
				return $find_product_in_cart ;
			}
		}
		$product_id = $id_from_other_lang ;
	} elseif ( $product_id ) {
			$cart_id              = FP_Donation_Rewards_Cart::generate_cart_item_key( $product_id ) ;
			$find_product_in_cart = $woocommerce->cart->find_product_in_cart( $cart_id ) ;
	}
	return $find_product_in_cart ;
}

if ( ! function_exists( 'fp_donation_check_is_array' ) ) {

	/**
	 * Function to check given a variable is array and not empty
	 * */
	function fp_donation_check_is_array( $array ) {
		if ( is_array( $array ) && ! empty( $array ) ) {
			return true ;
		} else {
			return false ;
		}
	}

}

if ( ! function_exists( 'donation_system_select2_html' ) ) {

	/**
	 * Function to create select2 field
	 * */
	function donation_system_select2_html( $args, $echo = true ) {

		$args = wp_parse_args( $args , array(
			'class'             => '',
			'id'                => '',
			'name'              => '',
			'list_type'         => '',
			'action'            => '',
			'placeholder'       => '',
			'css'               => '',
			'custom_attributes' => '',
			'multiple'          => true,
			'allow_clear'       => true,
			'selected'          => true,
			'options'           => array(),
				) ) ;

		$multiple     = $args[ 'multiple' ] ? 'multiple="multiple"' : '' ;
		$name         = esc_attr( '' !== $args[ 'name' ] ? $args[ 'name' ] : $args[ 'id' ] ) . '[]' ;
		$allowed_html = array(
			'select' => array(
				'id'                           => array(),
				'class'                        => array(),
				'data-placeholder'             => array(),
				'data-allow_clear'             => array(),
				'data-exclude-global-variable' => array(),
				'data-nonce'                   => array(),
				'data-action'                  => array(),
				'multiple'                     => array(),
				'name'                         => array(),
			),
			'option' => array(
				'value'    => array(),
				'selected' => array(),
			),
				) ;
		ob_start() ;
		?>
		<select <?php esc_html_e( $multiple ) ; ?>
			name="<?php echo esc_attr( $name ) ; ?>"
			id="<?php echo esc_attr( $args[ 'id' ] ) ; ?>"
			data-action="<?php echo esc_attr( $args[ 'action' ] ) ; ?>"
			class="donation_select2_search <?php echo esc_attr( $args[ 'class' ] ) ; ?>"
			data-placeholder="<?php echo esc_attr( $args[ 'placeholder' ] ) ; ?>"
			<?php echo $args[ 'allow_clear' ] ? 'data-allow_clear="true"' : '' ; ?> >
				<?php
				if ( is_array( $args[ 'options' ] ) ) {
					foreach ( $args[ 'options' ] as $option_id ) {
						$product = sumo_donation_get_product( $option_id ) ;
						if ( is_object( $product ) ) {
							echo '<option value="' . esc_attr( $option_id ) . '" ' . selected( 1 , 1 ) . '>' . wp_kses_post( $product->get_formatted_name() ) . '</option>' ;
						}
					}
				}
				?>
		</select>
		<?php
		$html = ob_get_clean() ;

		if ( $echo ) {
			echo wp_kses( $html , $allowed_html ) ;
		}

		return $html ;
	}

}

if ( ! function_exists( 'sumo_donation_reward_product_in_cart' ) ) {

	function sumo_donation_reward_product_in_cart() {
		$free_product = '' ;
		$product_ids  = array() ;

		foreach ( WC()->cart->get_cart() as $cart_item ) {
			$free_product = isset( $cart_item[ 'sumo_donation' ] ) ? $cart_item[ 'sumo_donation' ] : '' ;

			if ( isset( $free_product ) ) {
				$product_ids[] = ! empty( $cart_item[ 'variation_id' ] ) ? $cart_item[ 'variation_id' ] : $cart_item[ 'product_id' ] ;
			}
		}

		return array_filter( array_unique( $product_ids ) ) ;
	}

}

if ( ! function_exists( 'sumo_donation_manual_product_in_cart' ) ) {

	function sumo_donation_manual_product_in_cart() {

		// check donation product was empty or not.
		$get_product_id           = get_option( 'ds_select_particular_products' ) ;
		$generate_cart_item_key   = WC()->cart->generate_cart_id( $get_product_id ) ;
		$check_product            = WC()->cart->find_product_in_cart( $generate_cart_item_key ) ;
		$get_session_productvalue = WC()->session->get( 'fp_donation_amount' ) ;

		if ( isset( $get_product_id ) && isset( $check_product ) && isset( $get_session_productvalue ) ) {
			return true ;
		}

		return false ;
	}

}

if ( ! function_exists( 'fp_donation_page_screen_ids' ) ) {

	/**
	 * Get the page screen IDs.
	 *
	 * @return array
	 */
	function fp_donation_page_screen_ids() {
		$screen_id = sanitize_title( __( 'WooCommerce' , 'woocommerce' ) ) ;

		return apply_filters(
				'fp_donation_page_screen_ids' , array(
			$screen_id . '_page_donationsystem',
				)
				) ;
	}

}

if ( ! function_exists( 'fp_donation_get_settings_page_url' ) ) {

	/**
	 * Get the settings page URL.
	 *
	 * @return URL
	 */
	function fp_donation_get_settings_page_url( $args = array() ) {

		$url = add_query_arg( array( 'page' => 'donationsystem' ) , admin_url( 'admin.php' ) ) ;

		if ( fp_donation_check_is_array( $args ) ) {
			$url = add_query_arg( $args , $url ) ;
		}

		return $url ;
	}

}

if (!function_exists('fp_donation_get_wc_script_handle_name')) {

	/**
	 * Get the WooCommerce script handle name.
	 * 
	 * @since 3.9.0
	 * @param string $handle_key
	 * @return string
	 */
	function fp_donation_get_wc_script_handle_name( $handle_key ) {
		if (version_compare(get_option('woocommerce_version'), '10.3.0', '<')) {
			$handle_names=array( 'blockui'=>'jquery-blockui' );
		} else {
			$handle_names=array( 'blockui'=>'wc-jquery-blockui' );
		}

		return isset($handle_names[$handle_key])?$handle_names[$handle_key]:''; 
	}

}
