<?php

// Declare the Flybox Class
class FP_Donation_Compatibility_Function {

	public static function get_bundled_product_cart_item_price( $cart_item ) {

		if ( wc_pb_is_bundle_container_cart_item( $cart_item ) ) {

			$aggregate_prices = WC_Product_Bundle::group_mode_has( $cart_item[ 'data' ]->get_group_mode() , 'aggregated_prices' ) ;

			if ( $aggregate_prices ) {

				$tax_display_cart    = get_option( 'woocommerce_tax_display_cart' ) ;
				$calc_type           = 'excl' === $tax_display_cart ? 'excl_tax' : 'incl_tax' ;
				$bundle_price        = WC_PB_Product_Prices::get_product_price( $cart_item[ 'data' ] , array( 'price' => $cart_item[ 'data' ]->get_price(), 'calc' => $calc_type ) ) ;
				$bundled_cart_items  = wc_pb_get_bundled_cart_items( $cart_item , WC()->cart->cart_contents ) ;
				$bundled_items_price = 0.0 ;

				foreach ( $bundled_cart_items as $bundled_cart_item ) {

					$bundled_item_id        = $bundled_cart_item[ 'bundled_item_id' ] ;
					$bundled_item_raw_price = $bundled_cart_item[ 'data' ]->get_price() ;

					if ( WC_PB()->compatibility->is_subscription( $bundled_cart_item[ 'data' ] ) ) {

						$bundled_item = $cart_item[ 'data' ]->get_bundled_item( $bundled_item_id ) ;

						if ( $bundled_item ) {
							$bundled_item_raw_recurring_fee = $bundled_cart_item[ 'data' ]->get_price() ;
							$bundled_item_raw_sign_up_fee   = ( float ) WC_Subscriptions_Product::get_sign_up_fee( $bundled_cart_item[ 'data' ] ) ;
							$bundled_item_raw_price         = $bundled_item->get_up_front_subscription_price( $bundled_item_raw_recurring_fee , $bundled_item_raw_sign_up_fee , $bundled_cart_item[ 'data' ] ) ;
						}
					}

					$bundled_item_qty    = $bundled_cart_item[ 'data' ]->is_sold_individually() ? 1 : $bundled_cart_item[ 'quantity' ] / $cart_item[ 'quantity' ] ;
					$bundled_item_price  = WC_PB_Product_Prices::get_product_price( $bundled_cart_item[ 'data' ] , array( 'price' => $bundled_item_raw_price, 'calc' => $calc_type, 'qty' => $bundled_item_qty ) ) ;
					$bundled_items_price += wc_format_decimal( ( float ) $bundled_item_price , wc_get_price_decimals() ) ;
				}

				$price = $bundle_price + $bundled_items_price ;
			} elseif ( 0 == $cart_item[ 'line_subtotal' ] ) {

				$bundled_items          = wc_pb_get_bundled_cart_items( $cart_item , WC()->cart->cart_contents ) ;
				$bundled_item_subtotals = wp_list_pluck( $bundled_items , 'line_subtotal' ) ;

				if ( array_sum( $bundled_item_subtotals ) > 0 ) {
					$price = '' ;
				}
			}
		}

		return $price ;
	}
}

new FP_Donation_Compatibility_Function() ;
