<?php

// Declare the Flybox Class
class FP_Donation_FlyBox_Function {

	public function __construct() {
		// Construct the Flybox Functionality
		if ( get_option( '_fp_donation_display_flybox' ) == 'yes' && get_option( '_fp_donation_automatic_enable' ) != 'yes' ) {
			add_action( 'wp_head' , array( $this, 'donation_flybox_visibility' ) ) ;
		}
	}

	public static function donation_flybox_visibility() {
		if ( ( get_option( '_fp_donation_flybox_display_cart' ) == 'yes' ) ) {
			if ( function_exists( 'is_cart' ) ) {
				if ( is_cart() ) {
					self::donation_flybox() ;
				}
			}
		}
		if ( ( get_option( '_fp_donation_flybox_display_checkout' ) == 'yes' ) ) {
			if ( function_exists( 'is_checkout' ) ) {
				if ( is_checkout() ) {
					self::donation_flybox() ;
				}
			}
		}
	}

	public static function donation_flybox() {
		global $woocommerce ;

		if ( sumo_check_global_settings_to_display_df() ) {
			if ( ! isset( $_COOKIE[ 'fpdonationflybox' ] ) ) {
				?>
				<div class='fp_donation_flybox'>
					<span class='fpdonationflyboxclose'>X</span>
					<form name="fp_donation_form" method="post">
						<?php
						do_action( 'fp_donatation_form_validation_msg' ) ;
						FP_Donation_Main_Function::add_donation_amount_fields( 'flybox' ) ;
						?>
					</form>
				</div>
				<?php
			}
		}
	}
}

new FP_Donation_FlyBox_Function() ;
