<?php

/**
 * Frontend Assets.
 * */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( ! class_exists( 'FP_Donation_Fronend_Assets' ) ) {

	/**
	 * Class.
	 */
	class FP_Donation_Fronend_Assets {

		/**
		 * Suffix.
		 *
		 * @var string
		 */
		private static $suffix;

		/**
		 * Class Initialization.
		 */
		public static function init() {

			self::$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'external_css_files' ) );
			add_action( 'wp_enqueue_scripts', array( __CLASS__, 'external_js_files' ) );
		}

		/**
		 * Enqueue external JS files.
		 */
		public static function external_js_files() {
			$min_donation = get_option( '_fp_donation_amount_minimum_product' );
			$max_donation = get_option( '_fp_donation_amount_maximum_product' );
			// Frontend.
			wp_enqueue_script( 'fp-donation-frontend', FP_DONATION_PLUGIN_URL . '/assets/js/frontend/frontend.js', array( 'jquery', fp_donation_get_wc_script_handle_name('blockui') ), FP_DONATION_VERSION );

			wp_localize_script(
				'fp-donation-frontend',
				'fp_donation_frontend_params',
				array(
					'ajax_url'         => FP_DONATION_ADMIN_AJAX_URL,
					'reward_nonce'     => wp_create_nonce( 'donation-reward-nonce' ),
					'anonymous_nonce'  => wp_create_nonce( 'donation-anonymous-nonce' ),
					'min_donation'     => $min_donation,
					'max_donation'     => $max_donation,
					'min_donation_msg' => str_replace( '{minimum_donation}', wc_price( $min_donation ), get_option( '_fp_donation_minimum_error_message' ) ),
					'max_donation_msg' => str_replace( '{maximum_donation}', wc_price( $max_donation ), get_option( '_fp_donation_maximum_error_message' ) ),
				)
			);

			wp_localize_script(
				'fp-donation-frontend',
				'fp_donation_flybox_params',
				array(
					'position'          => get_option( '_fp_donation_flybox_position' ),
					'scroll_percentage' => get_option( '_fp_donation_flybox_scroll_percentage' ),
					'enable_cookies'    => get_option( '_fp_donation_flybox_enable_cookies' ),
					'expired_value'     => get_option( '_fp_donation_flybox_enable_cookies' ) == 'yes' ? get_option( '_fp_donation_flybox_click_to_close' ) : 0,
				)
			);

			// Footable JS.
			wp_enqueue_script( 'footable', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable.js', array( 'jquery' ), FP_DONATION_VERSION );
			wp_enqueue_script( 'footable_sort', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable.sort.js', array( 'jquery' ), FP_DONATION_VERSION );
			wp_enqueue_script( 'footable_filter', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable.filter.js', array( 'jquery' ), FP_DONATION_VERSION );
			wp_enqueue_script( 'footable_initialize', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable_initialize.js', array( 'jquery' ), FP_DONATION_VERSION );
			wp_enqueue_script( 'footable_paging', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable.paginate.js', array( 'jquery' ), FP_DONATION_VERSION );
		}

		/**
		 * Enqueue external CSS files.
		 */
		public static function external_css_files() {

			// Add inline style.
			self::add_inline_style();

			// Fornt end.
			wp_enqueue_style( 'fp-donation-frontend', FP_DONATION_PLUGIN_URL . '/assets/css/frontend.css', array(), FP_DONATION_VERSION );
			// Boostrap.
			wp_enqueue_style( 'bootstrap_css', FP_DONATION_PLUGIN_URL . '/assets/lib/bootstrap/bootstrap.css', array(), FP_DONATION_VERSION );
			// Footable.
			wp_enqueue_style( 'footable_css', FP_DONATION_PLUGIN_URL . '/assets/lib/footable/footable.core.css', array(), FP_DONATION_VERSION );
		}

		/**
		 * Add Inline style.
		 */
		public static function add_inline_style() {
			if ( is_cart() ) {
				// Add cart donation inline style.
				self::add_cart_inline_style();
			} elseif ( is_checkout() ) {
				// Add checkout donation inline style.
				self::add_checkout_inline_style();
			} elseif ( is_product() ) {
				// Add product donation inline style.
				self::add_product_inline_style();
			} else {
				// Add shortcode donation inline style.
				self::add_shortcode_inline_style();
			}
			// Add flybox donation inline style.
			self::add_flybox_inline_style();
		}

		/**
		 * Add cart inline style.
		 */
		public static function add_cart_inline_style() {
			// Add cart donation inline style.
			$contents = '#fp_predefined_buttons div.fp_input_predefined_buttons_in_cart {
                    background-color:#' . get_option( '_fp_donation_button_bg_color_cart' ) . ';
                    color: #' . get_option( '_fp_donation_button_text_color_shortcode' ) . ';
                }

                .fp_input_predefined_buttons_selected {
                    background-color:#' . get_option( '_fp_donation_button_selected_color_cart' ) . ' !important;
                }
                
                #fp_predefined_buttons div.fp_input_predefined_buttons_in_cart:hover {
                    background-color:#' . get_option( '_fp_donation_button_hover_color_cart' ) . ';
                }' . get_option( '_fp_donation_cart_css', '' );

			// Add custom css as cart inline style.
			wp_register_style('fp-donation-cart-inline-style', false, array(), FP_DONATION_VERSION); // phpcs:ignore
			wp_enqueue_style( 'fp-donation-cart-inline-style' );
			wp_add_inline_style( 'fp-donation-cart-inline-style', $contents );
		}

		/**
		 * Add checkout inline style.
		 */
		public static function add_checkout_inline_style() {

			// Add checkout donation inline style.
			$contents = ' #fp_predefined_buttons div.fp_input_predefined_buttons_in_checkout {
                    background-color: #' . get_option( '_fp_donation_button_bg_color_checkout' ) . ';
                    color: #' . get_option( '_fp_donation_button_text_color_shortcode' ) . ';
                }

                .fp_input_predefined_buttons_selected {
                    background-color:#' . get_option( '_fp_donation_button_selected_color_checkout' ) . ' !important;
                }
                
                #fp_predefined_buttons div.fp_input_predefined_buttons_in_checkout:hover {
                    background-color:#' . get_option( '_fp_donation_button_hover_color_checkout' ) . ';
                }' . get_option( '_fp_donation_checkout_css', '' );

			// Add custom css as checkout inline style.
			wp_register_style('fp-donation-checkout-inline-style', false, array(), FP_DONATION_VERSION); // phpcs:ignore
			wp_enqueue_style( 'fp-donation-checkout-inline-style' );
			wp_add_inline_style( 'fp-donation-checkout-inline-style', $contents );
		}

		/**
		 * Add product inline style.
		 */
		public static function add_product_inline_style() {
			// Add product donation inline style.
			$contents = ' #fp_predefined_buttons div.fp_input_predefined_buttons_in_product {
                    background-color: #' . get_option( '_fp_donation_button_bg_color_product' ) . ';
                    color: #' . get_option( '_fp_donation_button_text_color_shortcode' ) . ';
                }

                .fp_input_predefined_buttons_selected {
                    background-color:#' . get_option( '_fp_donation_button_selected_color_product' ) . ' !important;
                }
                
                #fp_predefined_buttons div.fp_input_predefined_buttons_in_product:hover {
                    background-color:#' . get_option( '_fp_donation_button_hover_color_product' ) . ';
                }' . get_option( '_fp_donation_product_css', '' );

			// Add custom css as product inline style.
			wp_register_style('fp-donation-product-inline-style', false, array(), FP_DONATION_VERSION); // phpcs:ignore
			wp_enqueue_style( 'fp-donation-product-inline-style' );
			wp_add_inline_style( 'fp-donation-product-inline-style', $contents );
		}

		/**
		 * Add shortcode inline style.
		 */
		public static function add_shortcode_inline_style() {
			// Add shortcode donation inline style.
			$contents = ' #fp_donation_form {
                    background:#' . get_option( '_fp_donation_form_background_color' ) . ' ;
                } 
                
                #fp_predefined_buttons div.fp_input_predefined_buttons {
                    background-color: #' . get_option( '_fp_donation_button_bg_color_shortcode' ) . ';
                    color: #' . get_option( '_fp_donation_button_text_color_shortcode' ) . ';
                }

                .fp_input_predefined_buttons_selected {
                    background-color:#' . get_option( '_fp_donation_button_selected_color_shortcode' ) . ' !important;
                }
                
                #fp_predefined_buttons div.fp_input_predefined_buttons:hover {
                    background-color:#' . get_option( '_fp_donation_button_hover_color_shortcode' ) . ';
                }' . get_option( '_fp_donation_shortcode_css', '' );

			// Add custom css as shortcode inline style.
			wp_register_style('fp-donation-shortcode-inline-style', false, array(), FP_DONATION_VERSION); // phpcs:ignore
			wp_enqueue_style( 'fp-donation-shortcode-inline-style' );
			wp_add_inline_style( 'fp-donation-shortcode-inline-style', $contents );
		}

		/**
		 * Add flybox inline style.
		 */
		public static function add_flybox_inline_style() {

			if ( '1' == get_option( '_fp_donation_flybox_position' ) ) {
				$border = 'border: 1px solid #' . get_option( '_fp_donation_flybox_border_color' ) . ';';
			} else {
				$border = 'border: 1px solid #' . get_option( '_fp_donation_flybox_border_color' ) . ';';
			}

			if ( '1' == get_option( '_fp_donation_flybox_position' ) ) {
				$flybox_close = 'right:0px;top:0px;';
			} else {
				$flybox_close = 'left:0px;top:0px;';
			}

			$media                = '';
			$get_hide_screen_size = get_option( '_fp_donation_flybox_hide_screen_size' );
			// check it is not empty
			if ( ! empty( $get_hide_screen_size ) ) {
				$explode_size = explode( ',', $get_hide_screen_size );
				if ( fp_donation_check_is_array( $explode_size ) ) {
					foreach ( $explode_size as $eachsize ) {
						$each_size_explode = explode( 'x', $eachsize );
						$min               = $each_size_explode[0];
						$max               = $each_size_explode[1];

						$media .= '@media (width:' . $min . 'px) and (height:' . $max . 'px) {
                                .fp_donation_flybox{
                                    display:none;
                                }
                            }';
					}
				}
			}

			// Add flybox donation inline style.
			$contents = '.fp_donation_flybox {
						background:#' . get_option( '_fp_donation_flybox_bgcolor' ) . ';
						border: 1px solid #' . get_option( '_fp_donation_flybox_border_color' ) . ';
                                                    ' . $border . '
					}

					.fp_donation_flybox .fp_donation_heading {
						color: #' . get_option( '_fp_donation_flybox_head_text_color' ) . ';
					}

					.fp_donation_flybox .fp_donation_description {
						color: #' . get_option( '_fp_donation_flybox_description_text_color' ) . ';
					}

					.fpdonationflyboxclose {
                                        ' . $flybox_close . '
					}
                                        
                            #fp_predefined_buttons div {
                                 background-color: #' . get_option( '_fp_donation_button_bg_color_flybox' ) . ';
                                 color: #' . get_option( '_fp_donation_button_text_color_shortcode' ) . ';
                           }

                           .fp_input_predefined_buttons_selected {
                                background-color:#' . get_option( '_fp_donation_button_selected_color_flybox' ) . ' !important;
                           }
                
                             #fp_predefined_buttons div:hover {
                                background-color:#' . get_option( '_fp_donation_button_hover_color_flybox' ) . ';
                           }' . get_option( '_fp_donation_flybox_css', '' ) . $media;

			// Add custom css as flybox inline style.
			wp_register_style('fp-donation-flybox-inline-style', false, array(), FP_DONATION_VERSION); // phpcs:ignore
			wp_enqueue_style( 'fp-donation-flybox-inline-style' );
			wp_add_inline_style( 'fp-donation-flybox-inline-style', $contents );
		}
	}

	FP_Donation_Fronend_Assets::init();
}
