<?php

class FP_Donation_Product_Function {

	public function __construct() {
		if ( get_option( '_fp_donation_display_product' ) == 'yes' && get_option( '_fp_donation_automatic_enable' ) != 'yes' ) {
			add_action( 'woocommerce_after_add_to_cart_form' , array( $this, 'donation_product_function' ) ) ;
		}
	}

	// Donation Product Function

	public static function donation_product_function() {
		if ( sumo_check_global_settings_to_display_df() ) {
			global $post ;
			if ( is_product() ) {
				if ( get_option( '_fp_show_donation_form_in_product' ) == '1' ) {
					?>
					<form name="fp_donation_form" method="post">
						<?php
						do_action( 'fp_donatation_form_validation_msg' ) ;
						FP_Donation_Main_Function::add_donation_amount_fields( 'product' ) ;
						?>
					</form>
					<?php
				} else if ( get_option( '_fp_show_donation_form_in_product' ) == '2' ) {
					// For Included Products alone
					$post_id                    = $post->ID ;
					$get_included_products_data = get_option( '_fp_donation_form_included_selected_products' ) ;
					if ( ! is_array( $get_included_products_data ) ) {
						$get_included_products_data = explode( ',' , $get_included_products_data ) ;
					}
					if ( is_array( $get_included_products_data ) && ( ! empty( $get_included_products_data ) ) ) {
						if ( in_array( $post_id , $get_included_products_data ) ) {
							?>
							<form name="fp_donation_form" method="post">
								<?php
								do_action( 'fp_donatation_form_validation_msg' ) ;
								FP_Donation_Main_Function::add_donation_amount_fields( 'product' ) ;
								?>
							</form>
							<?php
						}
					}
				} else {
					// For Excluded Products alone
					$post_id                    = $post->ID ;
					$get_excluded_products_data = get_option( '_fp_donation_form_included_selected_products' ) ;
					if ( ! is_array( $get_excluded_products_data ) ) {
						$get_excluded_products_data = explode( ',' , $get_excluded_products_data ) ;
					}
					if ( is_array( $get_excluded_products_data ) && ( ! empty( $get_excluded_products_data ) ) ) {
						if ( ! in_array( $post_id , $get_excluded_products_data ) ) {
							?>
							<form name="fp_donation_form" method="post">
								<?php
								do_action( 'fp_donatation_form_validation_msg' ) ;
								FP_Donation_Main_Function::add_donation_amount_fields( 'product' ) ;
								?>
							</form>
							<?php
						}
					}
				}
			}
		}
	}

	// Get the Table of whoever contributed
	public static function get_donated_order_ids() {
		$get_product_id = get_option( 'ds_select_particular_products' ) ;

		if ( ( '' != $get_product_id ) && ( $get_product_id ) ) {
			return get_option( '_fp_donated_order_ids' ) ;
		} else {
			return false ;
		}
	}

	// Get the Entire Details from Order about donar

	public static function get_entire_details_about_donar() {
		// List of Orderids
		global $post, $woocommerce ;

		$get_orderids = self::get_donated_order_ids() ;
		if ( 'yes' == get_option( '_fp_donation_display_table' ) ) {
			?>

			<h3><?php echo esc_html( get_option( '_fp_donar_details_heading' ) ) ; ?></h3>

			<select id='pagination_size'>
				<option value="5">5</option>
				<option value="10">10</option>
				<option value="50">50</option>
				<option value="100">100</option>
			</select>
			<table class="donationtable examples">
				<thead>
					<tr>
						<?php if ( get_option( '_fp_hide_donation_table_sno' ) == 'yes' ) { ?>
							<th data-toggle="true" data-sort-initial ="true" >
								<?php echo esc_html( get_option( '_fp_donar_details_sno' ) ) ; ?>
							</th>
						<?php } if ( get_option( '_fp_hide_donation_table_name' ) == 'yes' ) { ?>
							<th>
								<?php echo esc_html( get_option( '_fp_donar_details_name' ) ) ; ?>
							</th>
						<?php } if ( get_option( '_fp_hide_donation_table_email' ) == 'yes' ) { ?>
							<th>
								<?php echo esc_html( get_option( '_fp_donar_details_email' ) ) ; ?>
							</th>
						<?php } if ( get_option( '_fp_hide_donation_table_amount' ) == 'yes' ) { ?>
							<th>
								<?php echo esc_html( get_option( '_fp_donar_details_amount' ) ) ; ?>
							</th>
						<?php } if ( get_option( '_fp_hide_donation_table_memorable' ) == 'yes' ) { ?>
							<th data-hide="phone,tablet">
								<?php echo esc_html( get_option( '_fp_donar_details_memorable' ) ) ; ?>
							</th >
						<?php } if ( get_option( '_fp_hide_donation_table_honorable' ) == 'yes' ) { ?>
							<th data-hide="phone,tablet">
								<?php echo esc_html( get_option( '_fp_donar_details_Honorable' ) ) ; ?>
							</th>
						<?php } if ( get_option( '_fp_hide_donation_table_reason' ) == 'yes' ) { ?>
							<th data-hide="phone,tablet">
								<?php echo esc_html( get_option( '_fp_donar_details_reason' ) ) ; ?>
							</th>

						<?php } if ( get_option( '_fp_hide_donation_table_status' ) == 'yes' ) { ?>
							<th>
								<?php echo esc_html( get_option( '_fp_donar_details_status' ) ) ; ?>
							</th>
						<?php } ?>
					</tr>
				</thead>
				<tbody>
					<?php
					if ( is_array( ( array ) $get_orderids ) ) {
						$i = 1 ;
						foreach ( $get_orderids as $each_order ) {
							$order              = wc_get_order( $each_order ) ;
							if ( is_object( $order ) ) {
								$donation_anonymous = $order->get_meta('fp_donation_anonymous') ;
								$reason_type        = $order->get_meta('fp_donation_reason_type') ;
								$donate_for_person  = $order->get_meta('fp_donation_person') ;
								$donation_reason    = $order->get_meta('fp_donation_reason_to_donate') ;
								?>
								<tr>
								<?php if ( 'yes' == get_option( '_fp_hide_donation_table_sno' ) ) { ?>
										<td data-value="<?php echo esc_attr( $i ) ; ?>">
																<?php echo esc_html( $i ) ; ?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_name' ) ) { ?>
										<td>
																<?php
																echo wp_kses_post( ( 'yes' == $donation_anonymous ) ? esc_html__( 'Anonymous' , 'donationsystem' ) : sumo_donation_get_order_billing_first_name( $order ) . ' ' . sumo_donation_get_order_billing_last_name( $order )  ) ;
																?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_email' ) ) { ?>
										<td>
											<?php
											echo wp_kses_post( ( 'yes' == $donation_anonymous ) ? '-' : sumo_donation_get_order_billing_email( $order )  ) ;
											?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_amount' ) ) { ?>
										<td>
											<?php
											$donatedamount = $order->get_meta('fp_donation_value') ;
											echo wp_kses_post( FP_Donation_Main_Function::format_price( $donatedamount ) ) ;
											?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_memorable' ) ) { ?>
										<td>
											<?php echo ( 'memorable' == $reason_type ) ? wp_kses_post( $donate_for_person ) : '-' ; ?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_honorable' ) ) { ?>
										<td>
											<?php echo ( 'Honorable' == $reason_type ) ? wp_kses_post( $donate_for_person ) : '-' ; ?>
										</td>
									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_reason' ) ) { ?>
										<td>
											<?php echo $donation_reason ? wp_kses_post( $donation_reason ) : '-' ; ?>
										</td>

									<?php } if ( 'yes' == get_option( '_fp_hide_donation_table_status' ) ) { ?>
										<td>
											<?php echo wp_kses_post( sumo_donation_get_order_status( $order ) ) ; ?>
										</td>
									<?php } ?>
								</tr>
								<?php
								$i++ ;
							}
						}
					}
					?>

				</tbody>
				<tfoot>
					<tr class="fp-donation-reward-table-footer">
						<td colspan="8">
							<div class="pagination pagination-centered"></div>
						</td>
					</tr>
				</tfoot>
			</table>

			<?php
		}
	}

	// Get Price of Corresponding Item

	public static function get_item_of_corresponding_order( $order, $product_id ) {
		$items = $order->get_items() ;
		foreach ( $items as $each_item ) {
			if ( $each_item[ 'product_id' ] == $product_id ) {
				return $each_item ;
			}
		}

		return false ;
	}
}

new FP_Donation_Product_Function() ;
