<?php

class FP_Donation_Rewards_Cart {

	// Construct the Function

	public function __construct() {
		if (get_option('_fp_donation_automatic_enable') != 'yes') {
			add_action('woocommerce_after_cart_table', array( $this, 'list_free_products_in_cart' ), 9);
			add_action('woocommerce_before_calculate_totals', array( $this, 'update_free_product_price_in_cart' ));
			add_filter('woocommerce_cart_item_quantity', array( $this, 'cart_item_quantity' ), 10, 2);
		}
	}

	// Display Free Product in that Page

	public static function list_free_products_in_cart() {
		global $woocommerce;

		if (!sumo_donation_manual_product_in_cart()) {
			return;
		}
		// check donation reward rules empty or not
		$donation_rewards = get_option('fp_donation_rewards_rule');
		if (!fp_donation_check_is_array($donation_rewards)) {
			return;
		}

		// get Matched rule check.
		$get_session_productvalue = WC()->session->get('fp_donation_amount');
		$priority = get_option('_fp_donation_rule_priority');
		$return_value = self::apply_which_level($get_session_productvalue, $priority);
		if (!fp_donation_check_is_array($return_value)) {
			return;
		}

		$return_value = $return_value[0];
		$count = self::get_product_count($return_value);

		if ($count > 0) {
			// check cart item contain free product.
			$reward_product_in_cart = sumo_donation_reward_product_in_cart();
			if (!fp_donation_check_is_array($reward_product_in_cart)) {
				return;
			}

			echo wp_kses_post('<h3>' . get_option('_fp_donation_free_products_caption') . '</h3>');

			// check free product in rules
			if (!isset($donation_rewards[$return_value]['product'])) {
				return;
			}

			echo '<ul>';
			foreach ($donation_rewards[$return_value]['product'] as $eachvalue) {
				if (!in_array($eachvalue, $reward_product_in_cart)) {
					$product_object = sumo_donation_get_product($eachvalue);

					if ($product_object->is_in_stock()) {
						$link = get_the_title($eachvalue);
						echo "<li> <a class='sumo_donation_manual_free_product' href='#' data-product_id = " . esc_attr($eachvalue) . ' > ' . esc_html($link) . ' </a> </li>';
					}
				}
			}
			echo '</ul>';
		}
	}

	// Get Product Count
	public static function get_product_count( $key ) {
		global $woocommerce;

		$count = array();
		$get_option = get_option('fp_donation_rewards_rule');
		$product_ids = $get_option[$key]['product'];
		$reward_product_in_cart = sumo_donation_reward_product_in_cart();

		foreach ($product_ids as $eachvalue) {
			if (!in_array($eachvalue, $reward_product_in_cart)) {
				$count[] = $eachvalue;
			}
		}

		return count($count);
	}

	// It can be both product and variation
	public static function add_product_automatically_to_cart( $product_id ) {
		global $woocommerce;

		if (!isset($product_id)) {
			return;
		}

		$cart_item_data = array();
		$qty = '1';
		$product_object = sumo_donation_get_product($product_id);

		if ($product_object) {
			$product_type = sumo_donation_get_product_type($product_object);
			$cart_item_data['sumo_donation'] = array( 'type' => 'free_product' );

			if ('simple' != $product_type) {
				$parent_id = sumo_donation_get_product_parent_id($product_object);
				$variation_id = $product_id;
				$get_variations = $product_object->get_variation_attributes();
				$woocommerce->cart->add_to_cart($parent_id, $qty, $variation_id, $get_variations, $cart_item_data);
			} else {
				$get_product_id = get_option('ds_select_particular_products');

				if ($product_id != $get_product_id) {
					$woocommerce->cart->add_to_cart($product_id, $qty, '', '', $cart_item_data);
				}
			}
		}
	}

	// Add Free Product Automatically to cart
	public static function main_function_free_add_to_cart( $amount ) {
		global $woocommerce;
		$priority = get_option('_fp_donation_rule_priority');
		$return_value = self::apply_which_level($amount, $priority);

		if (!empty($return_value)) {
			$iteration_value = $return_value[0];
			$get_details = self::get_which_rule($iteration_value);

			if (fp_donation_check_is_array($get_details)) {
				foreach ($get_details as $key => $value) {
					foreach ($value['product'] as $eachvalue) {
						$cart_old_key = self::generate_cart_item_key($eachvalue);
						$find_product_in_cart = $woocommerce->cart->find_product_in_cart($cart_old_key);
						if (!$find_product_in_cart) {
							self::add_product_automatically_to_cart($eachvalue);
						}
					}
				}
			}
		}
	}

	// Get the Product Type
	public static function get_product_type( $id ) {
		$product_id = is_array($id) ? implode(',', $id) : $id;
		$product_object = sumo_donation_get_product($product_id);
		$product_type = sumo_donation_get_product_type($product_object);
		return $product_type;
	}

	// generate cart item key for variable Product is in cart
	public static function generate_cart_item_key( $id ) {

		global $woocommerce;
		$variations = array();
		$id = is_array($id) ? implode(',', $id) : $id;
		$get_product_type = self::get_product_type($id);
		if ('simple' != $get_product_type) {
			$object = sumo_donation_get_product($id);
			$parent_id = sumo_donation_get_product_parent_id($object);
			$variation_id = $id;
			$get_available_variations = $object->get_variation_attributes();
			
			foreach ($get_available_variations as $slug => $each_variation) {
				$variations[$slug] = $each_variation[0];
			}
			
			$generate_cart_id = $woocommerce->cart->generate_cart_id($parent_id, $variation_id, $variations, array());
		} else {
			$parent_id = $id;
			$generate_cart_id = $woocommerce->cart->generate_cart_id($parent_id);
		}
		return $generate_cart_id;
	}

	// Function to know which rule should apply
	public static function get_which_rule( $iteration ) {
		$get_detail = get_option('fp_donation_rewards_rule');
		$get_detail = $get_detail[$iteration];

		$additional_array = array();
		foreach ($get_detail as $key => $value) {
			$additional_array[$iteration][$key] = $value;
		}
		return $additional_array;
	}

	//Check which level is first
	public static function apply_which_level( $donated_amount, $priority ) {
		global $woocommerce;
		$main_array = array();
		$get_detail = get_option('fp_donation_rewards_rule');

		if (!fp_donation_check_is_array($get_detail)) {
			return;
		}

		foreach ($get_detail as $keys => $values) {

			if ($values['min'] <= $donated_amount && $values['max'] >= $donated_amount) {
				if (!fp_donation_check_is_array($values['product'])) {
					$explode = explode(',', $values['product']);
					$amount = 0;
					foreach ($explode as $key => $value) {
						if ($value) {
							$product = sumo_donation_get_product($value);
							$amount += $product->get_price();
						} else {
							$amount += 0;
						}
					}
					$main_array[$keys] = $amount;
				} else {
					$amount = 0;
					foreach ($values['product'] as $key => $value) {
						if ($value) {
							$product = sumo_donation_get_product($value);
							$amount += $product->get_price();
						} else {
							$amount += 0;
						}
					}
					$main_array[$keys] = $amount;
				}
			}
		}
		if ('1' == $priority) {
			return array_keys($main_array, reset($main_array));
		} elseif ('2' == $priority) {
			return array_keys($main_array, end($main_array));
		} elseif ('3' == $priority) {
			return array_keys($main_array, min($main_array));
		} else {
			return array_keys($main_array, max($main_array));
		}
	}

	// Calculate Total before cart update
	public static function update_free_product_price_in_cart( $object ) {
		// It is applicable for
		$return_value = array();
		$check_product = '';
		$get_cart_contents = $object->cart_contents;
		$get_product_id = get_option('ds_select_particular_products');

		$get_detail = get_option('fp_donation_rewards_rule');
		if (!fp_donation_check_is_array($get_detail)) {
			return;
		}

		$get_session_productvalue = WC()->session->get('fp_donation_amount');

		if ($get_session_productvalue > 0) {
			$priority = get_option('_fp_donation_rule_priority');
			$return_value = self::apply_which_level($get_session_productvalue, $priority);
		}

		if (!fp_donation_check_is_array($return_value)) {
			return;
		}

		$return_value = $return_value[0];

		if (!isset($get_detail[$return_value]['product'])) {
			return;
		}
		foreach ($get_cart_contents as $cartkey => $value) {
			if (isset($value['sumo_donation'])) {
				foreach ($get_detail[$return_value]['product'] as $eachvalue) {
					$myid = '' != $value['variation_id'] ? $value['variation_id'] : $value['product_id'];
					if (( $myid == $eachvalue ) && ( $myid != $get_product_id )) {
						if ($get_product_id) {
							$generate_cart_item_key = WC()->cart->generate_cart_id($get_product_id);
							$check_product = WC()->cart->find_product_in_cart($generate_cart_item_key);
						}
						if ($check_product) {
							$value['data']->set_price(0);
						} else {
							WC()->cart->set_quantity($cartkey, 0);
							$value['data']->qty = '0';
							// After the Qty is 0 just delete it
							WC()->session->__unset('fp_donation_product');
							WC()->session->__unset('fp_donation_amount');
							WC()->session->__unset('fp_donation_currency');
						}
					}
				}
			}
		}
	}

	public function cart_item_quantity( $quantity, $cart_item_key ) {
		// check manual donation in cart
		if (!sumo_donation_manual_product_in_cart()) {
			return $quantity;
		}

		$reward_product_cart_item_keys = array();

		// check reward Product in cart
		$reward_products = sumo_donation_reward_product_in_cart();
		if (!fp_donation_check_is_array($reward_products)) {
			return $quantity;
		}

		foreach ($reward_products as $reward_product) {
			$reward_product_cart_item_keys[] = WC()->cart->generate_cart_id($reward_product);
		}

		//compare reward product in cart
		foreach (WC()->cart->get_cart() as $cart_item) {
			if ($cart_item['key'] == $cart_item_key) {
				$free_product = isset($cart_item['sumo_donation']) ? $cart_item['sumo_donation'] : '';

				if ($free_product) {
					$product_id = !empty($cart_item['variation_id']) ? $cart_item['variation_id'] : $cart_item['product_id'];
					$cart_key = WC()->cart->generate_cart_id($product_id);

					if (in_array($cart_key, $reward_product_cart_item_keys)) {
						$quantity = $cart_item['quantity'];
					}
				}
			}
		}


		return $quantity;
	}
}

new FP_Donation_Rewards_Cart();
