<?php

class FP_Donation_Shortcode_Function {

	// Construct the Donation Shortcode
	public function __construct() {
		$shortcodes = array(
			'fp_donation_form',
			'fp_donation_table',
			'fp_donation_rewards_table',
		);

		foreach ( $shortcodes as $shortcode_name ) {
			add_shortcode( $shortcode_name, array( __CLASS__, 'process_shortcode' ) );
		}
	}

	public static function process_shortcode( $atts, $content, $tag ) {

		$shortcode_name = str_replace( 'fp_donation_', '', $tag );
		$function       = 'shortcode_' . $shortcode_name;

		switch ( $shortcode_name ) {
			case 'form':
			case 'table':
			case 'rewards_table':
				ob_start();
				self::$function();
				$content = ob_get_contents();
				ob_end_clean();

				break;
		}
		return $content;
	}

	/**
	 * Output Shortcode Dashboard.
	 */
	public static function shortcode_form() {
		if ( get_option( '_fp_donation_automatic_enable', 'no' ) != 'yes' ) {
			do_action( 'fp_before_donatation_form_shortcode' );
			self::set_up_shortcode();
			do_action( 'fp_after_donatation_form_shortcode' );
		}
	}

	public static function shortcode_table() {
		FP_Donation_Product_Function::get_entire_details_about_donar();
	}

	public static function shortcode_rewards_table() {
		FP_Donation_Main_Function::show_donation_rewards_table();
	}

	public static function set_up_shortcode() {

		if ( get_option( '_fp_donation_display_shortcode' ) == 'yes' ) {
			FP_Donation_Main_Function::initialize_post_data_after_submit( 'shortcode' );
			?>
			<form id='fp_donation_form' name="fp_donation_form" method="post">
				<?php
				do_action( 'fp_donatation_form_validation_msg' );
				FP_Donation_Main_Function::add_donation_amount_fields( 'shortcode' );
				?>
			</form>

			<?php
		}
	}
}

new FP_Donation_Shortcode_Function();
