<?php
/**
 * Plugin Name: WooCommerce Checkout Upsell Funnel Premium
 * Plugin URI: https://villatheme.com/extensions/woocommerce-checkout-upsell-funnel/
 * Description: WooCommerce Checkout Upsell Funnel displays product suggestion and smart order bump on checkout page with the attractive discounts
 * Version: 1.0.15
 * Author: VillaTheme
 * Author URI: https://villatheme.com
 * Text Domain: woocommerce-checkout-upsell-funnel
 * Domain Path: /languages
 * Copyright 2021-2025 VillaTheme.com. All rights reserved.
 * Requires Plugins: woocommerce
 * Requires PHP: 7.0
 * Requires at least: 5.0
 * Tested up to: 6.8
 * WC requires at least: 7.0
 * WC tested up to: 10.2
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
define( 'VIWCUF_CHECKOUT_UPSELL_FUNNEL_VERSION', '1.0.15' );
/**
 * Detect plugin. For use on Front End only.
 */
$viwcuf_errors = array();
include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

/**
 * Class VIWCUF_CHECKOUT_UPSELL_FUNNEL
 */
class VIWCUF_CHECKOUT_UPSELL_FUNNEL {

	public function __construct( ) {
		add_action( 'plugins_loaded', array( $this, 'check_environment' ) );
		//compatible with 'High-Performance order storage (COT)'
		add_action( 'before_woocommerce_init', array( $this, 'before_woocommerce_init' ) );
		add_action( 'activated_plugin', array( $this, 'activated_plugin' ), 10, 2  );
	}
	public function check_environment() {
		if ( ! class_exists( 'VillaTheme_Require_Environment' ) ) {
			include_once  WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "woocommerce-checkout-upsell-funnel" . DIRECTORY_SEPARATOR . "includes" . DIRECTORY_SEPARATOR. 'support.php';
		}
		$environment = new VillaTheme_Require_Environment( [
				'plugin_name'     => 'WooCommerce Checkout Upsell Funnel',
				'php_version'     => '7.0',
				'wp_version'      => '5.0',
				'require_plugins' => [
					[
						'slug' => 'woocommerce',
						'name' => 'WooCommerce',
						'defined_version' => 'WC_VERSION',
						'version' => '7.0',
					],
				]
			]
		);
		if ( $environment->has_error() ) {
			return;
		}
		require_once  WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "woocommerce-checkout-upsell-funnel" . DIRECTORY_SEPARATOR . "includes" . DIRECTORY_SEPARATOR . "define.php";
	}

	/*
	 * Create table to save log
	 */
	function activated_plugin( $plugin ,$network_wide) {
		if ( $plugin !== 'woocommerce-checkout-upsell-funnel/woocommerce-checkout-upsell-funnel.php' ) {
			return;
		}
		if (!class_exists('VIWCUF_CHECKOUT_UPSELL_FUNNEL_Report_Table')) {
			require_once  WP_PLUGIN_DIR . DIRECTORY_SEPARATOR . "woocommerce-checkout-upsell-funnel" . DIRECTORY_SEPARATOR . "includes" . DIRECTORY_SEPARATOR . "report-table.php";
		}
		global $wpdb;
		if ( function_exists( 'is_multisite' ) && is_multisite() && $network_wide ) {
			$current_blog = $wpdb->blogid;
			$blogs        = $wpdb->get_col( "SELECT blog_id FROM {$wpdb->blogs}" );// phpcs:ignore WordPress.DB.DirectDatabaseQuery.DirectQuery, WordPress.DB.DirectDatabaseQuery.NoCaching

			//Multi site activate action
			foreach ( $blogs as $blog ) {
				switch_to_blog( $blog );
				/*Create custom table to store tracking data*/
				VIWCUF_CHECKOUT_UPSELL_FUNNEL_Report_Table::create_table();
			}
			switch_to_blog( $current_blog );
		} else {
			//Single site activate action
			/*Create custom table to store tracking data*/
			VIWCUF_CHECKOUT_UPSELL_FUNNEL_Report_Table::create_table();
		}
		$viwcuf_params = get_option( 'viwcuf_woo_checkout_upsell_funnel', array() );
		if ( ! empty( $viwcuf_params['us_redirect_page_endpoint'] ) ) {
			update_option( 'woocommerce_queue_flush_rewrite_rules', 'yes' );
		}
	}
	public function before_woocommerce_init() {
		if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
			\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
		}
	}
}

new VIWCUF_CHECKOUT_UPSELL_FUNNEL(  );

if ( file_exists( __DIR__ . '/inc/plugin-setup.php' ) ) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}
