<?php
use GuzzleHttp\Client;
class wcva_add_colored_variation_metabox {
    /*
	 * Construct
	 * since version 1.0.0
	 */
       public function __construct() {
	   
	     add_action('admin_enqueue_scripts', array(&$this, 'wcva_register_scripts'));
	     add_action('woocommerce_product_write_panel_tabs', array($this, 'wcva_add_colored_variable_metabox'));
	     add_action('woocommerce_product_data_panels', array($this, 'colored_variable_tab_options'));
	     add_action('woocommerce_process_product_meta', array($this, 'process_product_meta_colored_variable_tab'), 10, 2);
	     add_action('wp_ajax_nopriv_wcva_get_colors_ajax', array($this, 'wcva_get_colors_ajax_function') );
	     add_action('wp_ajax_wcva_get_colors_ajax', array($this, 'wcva_get_colors_ajax_function') );

	     add_action('wp_ajax_nopriv_wcva_get_images_ajax1', array($this, 'wcva_get_images_ajax1') );
	     add_action('wp_ajax_wcva_get_images_ajax1', array($this, 'wcva_get_images_ajax1') );
         add_action('wp_ajax_wcva_get_images_ajax2', array($this, 'wcva_get_images_ajax2') );
	     add_action('wp_ajax_nopriv_wcva_get_images_ajax2', array($this, 'wcva_get_images_ajax2') );
	   }


	   public function callOpenAI($endpoint, $data) {
	   	$product_settings = (array) get_option( 'wcva_product_settings' );
	   	$product_settings = array_merge( array(), $product_settings );
        


	   	if (isset($product_settings['wcva_openai_api'])) {
	   		$wcva_openai_api  = $product_settings['wcva_openai_api'];
	   	} else {
	   		$wcva_openai_api  = get_option('wcva_openai_api');
	   	}

	   	$wcva_openai_api = isset($wcva_openai_api) && ($wcva_openai_api != "") ? $wcva_openai_api : "";

	   	

	   	

	   	$OPENAI_API_KEY = $wcva_openai_api;

	   	$client = new Client([
	   		'base_uri' => 'https://api.openai.com/v1/',
	   		'headers' => [
	   			'Content-Type' => 'application/json',
	   			'Authorization' => "Bearer $OPENAI_API_KEY",
	   		],
	   	]);

	   	$response = $client->post($endpoint, [
	   		'json' => $data
	   	]);
	   	return json_decode($response->getBody(), true);
	   }


	   public function wcva_get_images_ajax1() {


	   	    if (isset($_POST['colors'])) {
	   		    $colors      = sanitize_text_field($_POST['colors']);
	   	    }


	   	    if (isset($_POST['prodid'])) {
	   		    $prodid      = sanitize_text_field($_POST['prodid']);
	   	    }


            $colors = explode(",", $colors);
            

            $variations = wcva_get_all_variations_from_product_id($prodid,$colors);


            


	      	$result = array('response'=> $variations );


	     	echo json_encode( $result );

	   	    die();

	   	
	   }


	   public function wcva_get_images_ajax2() {


	   	    if (isset($_POST['colors'])) {
	   		    $colors      = sanitize_text_field($_POST['colors']);
	   	    }


	   	    if (isset($_POST['prodid'])) {
	   		    $prodid      = sanitize_text_field($_POST['prodid']);
	   	    }



            

          
            $data = [
            	'model' => 'gpt-4',
            	'messages' => [
            		['role' => 'user', 'content' => 'provide me hex color code for '.$colors.''],
            	],
            ];

            $response = $this->callOpenAI('chat/completions', $data);

            $result = array('response'=>$response['choices'][0]['message']['content']);

            


	      


	     	echo json_encode( $result );

	   	    die();

	   	
	   }

	   public function wcva_get_colors_ajax_function() {


	   	if (isset($_POST['colors'])) {
            $colors      = sanitize_text_field($_POST['colors']);
        }


	   	$data = [
	   		'model' => 'gpt-4',
	   		'messages' => [
	   			['role' => 'user', 'content' => 'provide me hex color code for '.$colors.''],
	   		],
	   	];

	   	$response = $this->callOpenAI('chat/completions', $data);

	   	$result = array('response'=>$response['choices'][0]['message']['content']);


	   	echo json_encode( $result );

	   	die();

	   	
	   }
	/*
	 * Add metabox tab
	 * since version 1.0.0
	 */

	   public function wcva_register_scripts() {
	   
	      wp_register_script( 'wcva-meta', ''.wcva_PLUGIN_URL.'assets/js/wcva-meta.js' );
	      wp_register_script( 'jquery.accordion', ''.wcva_PLUGIN_URL.'assets/js/jquery.accordion.js' );
	      wp_register_script( 'wcva-iris', ''.wcva_PLUGIN_URL.'assets/js/iris.min.js' );
	      wp_register_style( 'wcva-meta', ''.wcva_PLUGIN_URL.'assets/css/wcva-meta.css' );
	      wp_register_style( 'wcva-spectrum', ''.wcva_PLUGIN_URL.'assets/css/spectrum.css' );
	      wp_register_style( 'jquery.accordion', ''.wcva_PLUGIN_URL.'assets/css/jquery.accordion.css' );
	      wp_register_style( 'example-styles', ''.wcva_PLUGIN_URL.'assets/css/example-styles.css' );
          $translation_array = array( 
		      'uploadimage'    => esc_html__( 'Choose an image' ,'woocommerce-colororimage-variation-select'),
			  'useimage'       => esc_html__( 'Use Image' ,'woocommerce-colororimage-variation-select'),
			  'placeholder'    => wedd_placeholder_img_src(),
			  'ajax_url'       => admin_url( 'admin-ajax.php' )
		    );
           wp_localize_script( 'wcva-meta', 'wcvameta', $translation_array );
	     
	   
	     
	   }
	/*
	 * Add metabox tab
	 * since version 1.0.0
	 */
	   
       public function wcva_add_colored_variable_metabox() {
	   ?>
        <a href="#colored_variable_tab_data"><li class="colored_variable_tab show_if_variable" >&nbsp;&nbsp;<?php echo esc_html__('WooSwatches', 'woocommerce-colororimage-variation-select'); ?></a></li>
	   <?php }
	

	/*
	 * Adds metabox tab content
	 * since version 1.0.0
	 */
	   public function colored_variable_tab_options() {
	     global $post,$woocommerce;
	   
	        $woo_version              =  wcva_get_woo_version_number();
	        $_coloredvariables        =  get_post_meta( $post->ID, '_coloredvariables', true );
			$shop_swatches            =  get_post_meta( $post->ID, '_shop_swatches', true );
			$shop_swatches_attribute  =  get_post_meta( $post->ID, '_shop_swatches_attribute', true );
	        $helpimg                  =  ''.wcva_PLUGIN_URL.'assets/images/help.png';
	        
			
            
			wp_enqueue_script('wcva-iris');
	        wp_enqueue_script('wcva-meta');
	        wp_enqueue_script('jquery.accordion');
	        wp_enqueue_style('wcva-meta');
	        wp_enqueue_style('jquery.accordion');
	        wp_enqueue_style('jquery.accordion');
	        wp_enqueue_style('example-styles');
	        
	        wp_enqueue_media();
	 
	        /**
	         * Includes Metabox form
	         */
	        include('forms/wcva_variation_select_tab_content.php');
      ?>    
            
	        
	  <?php
    }
	
	
	/**
	 * Adds save metabox tab options
	 * @$post_id - product id
	 */
    
    public function process_product_meta_colored_variable_tab($post_id) {
	
	      $shop_swatches          = isset( $_POST['shop_swatches'] ) ? 'yes' : 'no';
	    
	      if (isset($_POST['coloredvariables']))
	         update_post_meta( $post_id, '_coloredvariables', $_POST['coloredvariables'] );
		  
		  if (isset($shop_swatches))
	         update_post_meta( $post_id, '_shop_swatches', $shop_swatches );

	      if (isset($_POST['shop_swatches_attribute']))
	         update_post_meta( $post_id, '_shop_swatches_attribute', $_POST['shop_swatches_attribute'] );
		
	   
        
	}	
	   
}
new wcva_add_colored_variation_metabox();

?>