<?php
/**
 * Track order template.
 *
 * @version  1.0.0
 * @package  Woocommece_Order_Tracker/admin
 *  
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$activated_template = get_option( 'mwb_tyo_activated_template', '' );
$template1 = __( 'Activate', 'woocommerce-order-tracker' );
$template2 = __( 'Activate', 'woocommerce-order-tracker' );
$template3 = __( 'Activate', 'woocommerce-order-tracker' );
$template4 = __( 'Activate', 'woocommerce-order-tracker' );
$new_template1 = __( 'Activate', 'woocommerce-order-tracker' );
$new_template2 = __( 'Activate', 'woocommerce-order-tracker' );
$new_template3 = __( 'Activate', 'woocommerce-order-tracker' );

$template1_class1 = '';
$template1_class2 = '';
$template1_class3 = '';
$template1_class4 = '';
$template1_class_new1 = '';
$template1_class_new2 = '';
$template1_class_new3 = '';

if ( 'template1' == $activated_template ) {
	$template1 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class1 = 'wps_tyo_activated';
} else if ( 'template2' == $activated_template ) {
	$template2 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class2 = 'wps_tyo_activated';
} else if ( 'template3' == $activated_template ) {
	$template3 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class3 = 'wps_tyo_activated';
} else if ( 'template4' == $activated_template ) {
	$template4 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class4 = 'wps_tyo_activated';
} else if ( 'newtemplate1' == $activated_template ) {
	$new_template1 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class_new1 = 'wps_tyo_activated';
} else if ( 'newtemplate2' == $activated_template ) {
	$new_template2 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class_new2 = 'wps_tyo_activated';
} else if ( 'newtemplate3' == $activated_template ) {
	$new_template3 = __( 'Activated', 'woocommerce-order-tracker' );
	$template1_class_new3 = 'wps_tyo_activated';
}
?>
<h2><?php esc_html_e( 'Different templates for your order tracking', 'woocommerce-order-tracker' ); ?></h2>
<div class="mwb_notices_templates_order_tracker">
</div>
<div class="mwb_tyo_template">
	<div id="mwb_tyo_default_template">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class1 ); ?>">
			<img src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/ot02.png'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Classic Tracker', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_third" value=<?php echo esc_attr( $template1 ); ?> data-id='template1'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_third" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_first_template">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class2 ); ?>">
			
			<img  src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/ot03.png'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Compact Status', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_first" value=<?php echo esc_attr( $template2 ); ?> data-id='template2'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_first" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_second_template">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class3 ); ?>">
			<img  src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/ot01.jpg'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Order Status Chain', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_second" value=<?php echo esc_attr( $template3 ); ?> data-id='template3'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_second" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_fourth_template">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class4 ); ?>">
			<img src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/ot04.jpg'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Visual Map View', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_fourth" value=<?php echo esc_attr( $template4 ); ?> data-id='template4'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_fourth" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_new_template_1">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class_new1 ); ?>">
			<img src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/NOt01.jpg'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Timeline Tracker', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_new_template_1" value=<?php echo esc_html( $new_template1 ); ?> data-id='newtemplate1'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_new_template_1" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_new_template_2">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class_new2 ); ?>">
			<img src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/Ot02.jpg'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Simple Timeline', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_new_template_2" value=<?php echo esc_attr( $new_template2 ); ?> data-id='newtemplate2'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_new_template_2" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
	<div id="mwb_tyo_new_template_3">
		<div class="mwb_tyo_template_img_wrap <?php echo esc_attr( $template1_class_new3 ); ?>">
			<img src="<?php echo esc_attr( MWB_TRACK_YOUR_ORDER_URL ) . 'assets/images/Ot03.jpg'; ?>" class="mwb_tyo_template_view">
		</div>
		<div class="mwb_tyo_temlate_main_wrapper">
			<div class="mwb_tyo_temlate_name">
				<h4><?php esc_html_e( 'Flowline Tracker', 'woocommerce-order-tracker' ); ?></h4>
			</div>
			<div class="mwb_tyo_temlate_wrapper">
				<input type="button" class="activate_button" id="mwb_tyo_activate_new_template_3" value=<?php echo esc_html( $new_template3 ); ?> data-id='newtemplate3'>
				<input type="button" class="preview_button" id="mwb_tyo_preview_new_template_3" value=<?php esc_attr_e( 'Preview', 'woocommerce-order-tracker' ); ?> >
			</div>
		</div>
	</div>
</div>

<!-- Modal Structure -->
<div id="wpsimageModal" class="wps-image-modal" style="display:none;">
  <span class="wps-close-modal">&times;</span>
  <img class="wps-modal-content" id="wpsmodalImage" src="">
</div>


<style>.wps-image-modal {
  display: none; /* Hidden by default */
  position: fixed; /* Fixed position to stay centered on scroll */
  z-index: 999999;
  left: 0;
  top: 0;
  width: 100%;
  height: 100%;
  background-color: rgba(0, 0, 0, 0.8);
}

.wps-modal-content {
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%); /* Center horizontally and vertically */
  max-width: 700px;
  width: 80%;
}

.wps-close-modal {
  position: absolute;
  top: 15px;
  right: 35px;
  color: white;
  font-size: 40px;
  font-weight: bold;
  cursor: pointer;
}
.wps_tyo_activated {
    border: 3px solid #37e018;
   
}
</style>