<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link  https://wpswings.com/
 * @since 1.0.0
 *
 * @package    woocommerce-refund-and-exchange
 * @subpackage woocommerce-refund-and-exchange/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Show Exchange Product detail on Order Page on admin Side.

if ( ! is_int( $thepostid ) && isset( $post ) ) {
	$thepostid = $post->ID;
}
if ( isset( $order ) && is_object( $order ) && ! $order instanceof WP_Post ) {
	$theorder = $order;
}

$order_obj = $theorder;

$order_id = $order_obj->get_id();

$exchange_details = wps_wrma_get_meta_data( $order_id, 'ced_rnx_exchange_product', true );
$line_items  = $order_obj->get_items( apply_filters( 'woocommerce_admin_order_item_types', 'line_item' ) );
$save_ex_line_items = wps_wrma_get_meta_data( $order_id, 'ced_rnx_save_ex_line_items', true );
if ( empty( $save_ex_line_items ) ) {
	wps_wrma_update_meta_data( $order_id, 'mwb_rnx_new_refund_line_items', $line_items );
	wps_wrma_update_meta_data( $order_id, 'ced_rnx_save_ex_line_items', 'saved' );
}
$line_items = wps_wrma_get_meta_data( $order_id, 'mwb_rnx_new_refund_line_items', true );
// Get Pending exchange request.
if ( isset( $exchange_details ) && ! empty( $exchange_details ) ) {
	foreach ( $exchange_details as $date => $exchange_detail ) {
		if ( isset( $exchange_details[ $date ]['subject'] ) && $exchange_details[ $date ]['reason'] ) {
				$approve_date = date_create( $date );
				$date_format = get_option( 'date_format' );
				$approve_date = date_format( $approve_date, $date_format );


				$pending_date = '';
			if ( 'pending' == $exchange_detail['status'] ) {
				$pending_date = $date;
			}
				$subject = $exchange_details[ $date ]['subject'];
				$reason = $exchange_details[ $date ]['reason'];
			if ( isset( $exchange_detail['from'] ) ) {
				$exchange_products = $exchange_detail['from'];
			} else {
				$exchange_products = array();
			}
			if ( isset( $exchange_detail['to'] ) ) {
				$exchange_to_products = $exchange_detail['to'];
			} else {
				$exchange_to_products = array();
			}

			if ( isset( $exchange_detail['fee'] ) ) {
				$exchange_fees = $exchange_detail['fee'];
			} else {
				$exchange_fees = array();
			}

				$exchange_status = $exchange_detail['status'];
				$exchange_reason = $exchange_detail['reason'];
				$exchange_subject = $exchange_detail['subject'];

				esc_html_e( 'Following product exchange request is made on', 'woocommerce-refund-and-exchange' ); ?> <b><?php echo esc_html( $approve_date ); ?>.</b>

				<div>
					<div id="ced_rnx_exchange_wrapper">
					<p><b><?php esc_html_e( 'Exchanged Product', 'woocommerce-refund-and-exchange' ); ?></b></p>
					<table>
						<thead>
							<tr>
								<th><?php esc_html_e( 'Item', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Name', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Cost', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Qty', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						if ( isset( $exchange_products ) && ! empty( $exchange_products ) ) {
							$selected_total_price = 0;
							foreach ( $line_items as $item_id => $item ) {
								foreach ( $exchange_products as $key => $exchanged_product ) {
									if ( $item_id == $exchanged_product['item_id'] ) {
										if ( $item_id == $exchanged_product['item_id'] ) {
											$ex_product_data = $order_obj->get_meta_data();
											foreach ( $ex_product_data as $value ) {
												$ex_product_details = $value->get_data();
												if ( 'ced_rnx_exchange_product' == $ex_product_details['key'] ) {
													$ex_product_details_values = $ex_product_details['value'];
													foreach ( $ex_product_details_values as $value ) {
														$ex_product_details_values1 = $value['from'];
														foreach ( $ex_product_details_values1 as $value ) {
															$ex_product_id = $value['product_id'];
															$get_ex_product = wc_get_product( $ex_product_id );
															$image = wp_get_attachment_image_src( get_post_thumbnail_id( $ex_product_id ), 'single-post-thumbnail' );
															if ( isset( $image[0] ) ) {
																$image = $image[0];
															}
															$ex_product_new[] = array(
																'name' => $get_ex_product->get_name(),
																'sku'    => $get_ex_product->get_sku(),
																'image'  => $image,
															);
														}
													}
												}
											}
										}
										$_product  = $item->get_product();
										$item_meta = wc_get_order_item_meta( $item_id, $key );
										$thumbnail     = $_product ? apply_filters( 'woocommerce_admin_order_item_thumbnail', $_product->get_image( 'thumbnail', array( 'title' => '' ), false ), $item_id, $item ) : '';
										?>
										<tr>
											<td class="thumb">
											<?php
											if ( isset( $ex_product_new[ $key ]['image'] ) && ! empty( $ex_product_new[ $key ]['image'] ) ) {
												echo wp_kses_post( '<div class="wc-order-item-thumbnail"><img src="' . $ex_product_new[ $key ]['image'] . '"></div>' );
											}
											?>
											</td>
											<td class="name">
											<?php
											if ( isset( $ex_product_new[ $key ]['name'] ) && ! empty( $ex_product_new[ $key ]['name'] ) ) {
												echo esc_html( $ex_product_new[ $key ]['name'] );
											}
											if ( isset( $ex_product_new[ $key ]['sku'] ) && ! empty( $ex_product_new ) ) {
												echo '<div class="wc-order-item-sku"><strong>' . esc_html__( 'SKU:', 'woocommerce-refund-and-exchange' ) . '</strong> ' . esc_html( $ex_product_new[ $key ]['sku'] ) . '</div>';
											}
											if ( ! empty( $item['variation_id'] ) ) {
												echo '<div class="wc-order-item-variation"><strong>' . esc_html__( 'Variation ID:', 'woocommerce-refund-and-exchange' ) . '</strong> ';
												if ( ! empty( $item['variation_id'] ) && 'product_variation' === get_post_type( $item['variation_id'] ) ) {
													echo esc_html( $item['variation_id'] );
												} elseif ( ! empty( $item['variation_id'] ) ) {
													echo esc_html( $item['variation_id'] ) . ' (' . esc_html__( 'No longer exists', 'woocommerce-refund-and-exchange' ) . ')';
												}
												echo '</div>';
											}

											$item_meta      = new WC_Order_Item_Product( $item, $_product );
											wc_display_item_meta( $item_meta );

											?>
											</td>
											<td><?php echo wp_kses_post( ced_rnx_format_price( $exchanged_product['price'] ) ); ?></td>
											<td><?php echo wp_kses_post( $exchanged_product['qty'] ); ?></td>
											<td><?php echo wp_kses_post( ced_rnx_format_price( $exchanged_product['price'] * $exchanged_product['qty'] ) ); ?></td>
										</tr>
										<?php
										$selected_total_price += $exchanged_product['price'] * $exchanged_product['qty'];
									}
								}
							}
						}
						?>
							<tr>
								<th colspan="4"><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php echo wp_kses_post( ced_rnx_format_price( $selected_total_price ) ); ?></th>
							</tr>
						</tbody>
					</table>	
				</div>
				<div id="ced_rnx_exchange_wrapper">
					<p><b><?php esc_html_e( 'Requested Product', 'woocommerce-refund-and-exchange' ); ?></b></p>
					<table>
						<thead>
							<tr>
								<th><?php esc_html_e( 'Item', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Name', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Cost', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Qty', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
						$ced_woo_tax_enable_setting = get_option( 'woocommerce_calc_taxes' );
						$ced_woo_tax_display_shop_setting = get_option( 'woocommerce_tax_display_shop' );
						$ced_rnx_tax_test = false;


						if ( isset( $exchange_to_products ) && ! empty( $exchange_to_products ) ) {
							$total_price = 0;
							foreach ( $exchange_to_products as $key => $exchange_to_product ) {
								$variation_attributes = array();

								// Variable Product.
								if ( isset( $exchange_to_product['variation_id'] ) ) {
									if ( $exchange_to_product['variation_id'] ) {
										$variation_product = wc_get_product( $exchange_to_product['variation_id'] );
										$variation_attributes = $variation_product->get_variation_attributes();
										$variation_labels = array();
										foreach ( $variation_attributes as $label => $value ) {
											if ( is_null( $value ) || '' == $value ) {
												$variation_labels[] = $label;
											}
										}

										if ( isset( $exchange_to_product['variations'] ) && ! empty( $exchange_to_product['variations'] ) ) {
											$variation_attributes = $exchange_to_product['variations'];
										}
										if ( 'yes' == $ced_woo_tax_enable_setting ) {
											$ced_rnx_tax_test = true;
											if ( isset( $exchange_to_product['price'] ) ) {
												$exchange_to_product_price = $exchange_to_product['price'];
											} else {
												$exchange_to_product_price = wc_get_price_including_tax( $variation_product );
											}
										} else {
											$exchange_to_product_price = $exchange_to_product['price'];
										}
									} $product = wc_get_product( $exchange_to_product['variation_id'] );
								} else {
									$product = wc_get_product( $exchange_to_product['id'] );

									if ( 'yes' == $ced_woo_tax_enable_setting ) {
										$ced_rnx_tax_test = true;
										if ( isset( $exchange_to_product['price'] ) ) {
											$exchange_to_product_price = $exchange_to_product['price'];
										} else {
											$exchange_to_product_price = wc_get_price_including_tax( $product );
										}
									} else {
										$exchange_to_product_price = $exchange_to_product['price'];
									}
								}
								// Grouped Product.
								if ( isset( $exchange_to_product['p_id'] ) ) {
									if ( $exchange_to_product['p_id'] ) {
										$grouped_product = new WC_Product_Grouped( $exchange_to_product['p_id'] );
										$grouped_product_title = $grouped_product->get_title();
									}
								}

								$pro_price = $exchange_to_product['qty'] * $exchange_to_product_price;
								$total_price += $pro_price;
								?>
								<tr>
									<td>
										<?php
										if ( isset( $exchange_to_product['p_id'] ) ) {
											echo wp_kses_post( $grouped_product->get_image() );
										} elseif ( isset( $variation_attributes ) && ! empty( $variation_attributes ) ) {
											echo wp_kses_post( $variation_product->get_image() );
										} else {
											echo wp_kses_post( $product->get_image() );
										}
										?>
									</td>
									<td>
										<?php
										if ( isset( $exchange_to_product['p_id'] ) ) {
											echo esc_html( $grouped_product_title . ' -> ' );
										}
											echo esc_html( $product->get_title() );
										if ( $product && $product->get_sku() ) {
												echo '<div class="wc-order-item-sku"><strong>' . esc_html__( 'SKU:', 'woocommerce-refund-and-exchange' ) . '</strong> ' . esc_html( $product->get_sku() ) . '</div>';
										}
										if ( isset( $variation_attributes ) && ! empty( $variation_attributes ) ) {

											echo wp_kses_post( wc_get_formatted_variation( $variation_attributes ) );
										}
										?>
									</td>
									<td><?php echo wp_kses_post( ced_rnx_format_price( $exchange_to_product_price ) ); ?></td>
									<td><?php echo wp_kses_post( $exchange_to_product['qty'] ); ?></td>
									<td><?php echo wp_kses_post( ced_rnx_format_price( $pro_price ) ); ?></td>
								</tr>
								<?php
							}
						}
						?>
							<tr>
								<th colspan="4"><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php echo wp_kses_post( ced_rnx_format_price( $total_price ) ); ?></th>
							</tr>
						</tbody>
					</table>	
				</div>
				<div class="ced_rnx_extra_reason ced_rnx_extra_reason_for_exchange">
				<?php
					$fee_enable = get_option( 'ced_rnx_exchange_shipcost_enable', false );
				if ( 'yes' == $fee_enable ) {
					?>
						<p><?php esc_html_e( 'Fees amount is added to Paid amount', 'woocommerce-refund-and-exchange' ); ?></p>
						<?php
						$readonly = '';
						if ( 'complete' == $exchange_status ) {
							$readonly = 'readonly="readonly"';
						} else {
							?>
							<div id="ced_rnx_exchange_add_fee">
							<?php
						}

						if ( isset( $exchange_fees ) && ! empty( $exchange_fees ) ) {
							if ( is_array( $exchange_fees ) ) {
								foreach ( $exchange_fees as $fee ) {
									$total_price += $fee['val'];
									if ( 'pending' == $exchange_status ) {
										?>
									<div class="ced_rnx_exchange_add_fee">
										<?php
									}
									?>
										<input type="text" placeholder="<?php esc_html_e( 'Fee Name', 'woocommerce-refund-and-exchange' ); ?>" value="<?php echo esc_html( $fee['text'] ); ?>" name="ced_exchange_fee_txt[]" class="ced_exchange_fee_txt" <?php echo esc_html( $readonly ); ?>>
										<input type="text" name="" placeholder="0" value="<?php echo esc_html( $fee['val'] ); ?>" class="ced_exchange_fee_value wc_input_price" <?php echo esc_html( $readonly ); ?>>
									<?php
									if ( 'pending' == $exchange_status ) {
										?>
										<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-refund-and-exchange' ); ?>" class="button ced_rnx_remove-exchange-product-fee">
									</div>
										<?php
									}
								}
							}
						}
						if ( 'pending' == $exchange_status ) {
							?>
							</div>
							<button class="button ced_rnx_add-exchange-product-fee" type="button"><?php esc_html_e( 'Add fee', 'woocommerce-refund-and-exchange' ); ?></button>
							<button class="button button-primary ced_rnx_save-exchange-product-fee" type="button" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $date ); ?>"><?php esc_html_e( 'Save', 'woocommerce-refund-and-exchange' ); ?></button>
							<?php
						}
				}
					$mwb_cpn_used = wps_wrma_get_meta_data( $order_id, 'mwb_rnx_status_exchanged', true );
				if ( $mwb_cpn_used ) {
					$mwb_dis_tot = $mwb_cpn_used;
				} else {
					$mwb_cpn_dis = $order_obj->get_discount_total();
					$mwb_cpn_tax = $order_obj->get_discount_tax();
					$mwb_dis_tot = $mwb_cpn_dis + $mwb_cpn_tax;
				}
					$mwb_dis_tot = 0;
				if ( $total_price - ( $selected_total_price + $mwb_dis_tot ) > 0 ) {
					?>
						<p><strong><?php esc_html_e( 'Extra Amount Paid', 'woocommerce-refund-and-exchange' ); ?> : <?php echo wp_kses_post( ced_rnx_format_price( $total_price - ( $selected_total_price + $mwb_dis_tot ) ) ); ?></strong></p>
					<?php
				} else {
					if ( $mwb_dis_tot > $total_price ) {
						$total_price = 0;
					} else {
						$total_price = $total_price - $mwb_dis_tot;
					}
					?>
						<p><strong><i class="ced_rnx_left_amu"><?php esc_html_e( 'Left Amount After Exchange', 'woocommerce-refund-and-exchange' ); ?></i> : <?php echo wp_kses_post( ced_rnx_format_price( $selected_total_price - $total_price ) ); ?></strong>
						<input type="hidden" name="ced_rnx_left_amount_for_refund" class="ced_rnx_left_amount_for_refund" value="<?php echo wp_kses_post( ( $selected_total_price - $total_price ) ); ?>">
						</p>
						<?php
				}
				?>
					<div class="ced_rnx_reason">	
						<p><strong><?php esc_html_e( 'Subject', 'woocommerce-refund-and-exchange' ); ?> :</strong><i> <?php echo esc_html( $exchange_subject ); ?></i></p>
						<p><b><?php esc_html_e( 'Reason', 'woocommerce-refund-and-exchange' ); ?> :</b></p>
						<p><?php echo esc_html( $exchange_reason ); ?></p>
						<?php
						$req_attachments = wps_wrma_get_meta_data( $order_id, 'ced_rnx_exchange_attachment', true );

						if ( isset( $req_attachments ) && ! empty( $req_attachments ) ) {
							?>
							<p><b><?php esc_html_e( 'Attachment', 'woocommerce-refund-and-exchange' ); ?> :</b></p>
							<?php
							if ( is_array( $req_attachments ) ) {
								foreach ( $req_attachments as $da => $attachments ) {
									if ( $da == $date ) {
										$count = 1;
										foreach ( $attachments['files'] as $attachment ) {
											if ( $attachment != $order_id . '-' ) {
												?>
												<a href="<?php echo esc_url( home_url() ); ?>/wp-content/attachment/<?php echo esc_html( $attachment ); ?>" target="_blank"><?php esc_html_e( 'Attachment', 'woocommerce-refund-and-exchange' ); ?>-<?php echo esc_html( $count ); ?></a>
												<?php
												$count++;
											}
										}
										break;
									}
								}
							}
						}
						if ( 'pending' == $exchange_status ) {
							?>
						<p>
							<input type="button" value="Accept Request" class="button" id="ced_rnx_accept_exchange" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $date ); ?>">
							<input type="button" value="Cancel Request" class="button" id="ced_rnx_cancel_exchange" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $date ); ?>">
						</p>
							<?php
						}
						?>
					</div>
					<div class="ced_rnx_exchange_loader">
						<img src="<?php echo esc_url( home_url() ); ?>/wp-admin/images/spinner-2x.gif">
					</div>
				</div>	
			</div>
			<p>
			<?php
			if ( 'complete' == $exchange_detail['status'] ) {
				$left_amount = wps_wrma_get_meta_data( $order_id, 'ced_rnx_left_amount', true );
				$ced_refunded = wps_wrma_get_meta_data( $order_id, 'ced_rnx_exchange_approve_refunded', true );
				if ( isset( $left_amount ) && null != $left_amount && $left_amount > 0 ) {

					?>
					<p><strong>
					<?php
					esc_html_e( 'Refundable Amount of this order is ', 'woocommerce-refund-and-exchange' );
						echo wp_kses_post( wc_price( $left_amount ) );
					?>
					</strong><input type="button" name="ced_rnx_left_amount" class="button button-primary" id="ced_rnx_left_amount" data-orderid="<?php echo esc_html( $order_id ); ?>" Value="<?php esc_html_e( 'Refund Amount', 'woocommerce-refund-and-exchange' ); ?>" ></p>
					<input type="hidden" name="left_amount" id="left_amount" value="<?php echo esc_html( $left_amount ); ?>">
					<?php

				}
				$approve_date = date_create( $exchange_detail['approve'] );
				$date_format = get_option( 'date_format' );
				$approve_date = date_format( $approve_date, $date_format );

				esc_html_e( 'Above product exchange request is approved on', 'woocommerce-refund-and-exchange' );
				?>
				<b><?php echo esc_html( $approve_date ); ?>.</b>
				<?php
				$exhanged_order_id = wps_wrma_get_meta_data( $order_id, "date-$date", true );
				?>
				</p><p><?php esc_html_e( 'A new order is generated for your exchange request.', 'woocommerce-refund-and-exchange' ); ?>
				<a href="<?php echo esc_url( home_url( "wp-admin/post.php?post=$exhanged_order_id&action=edit" ) ); ?>">Order #<?php echo esc_html( $exhanged_order_id ); ?></a>
				<?php
				$ced_rnx_manage_stock_for_exchange = wps_wrma_get_meta_data( $order_id, 'ced_rnx_manage_stock_for_exchange', true );
				if ( '' == $ced_rnx_manage_stock_for_exchange ) {
					$ced_rnx_manage_stock_for_exchange = 'yes';
				}
				$manage_stock = get_option( 'ced_rnx_exchange_request_manage_stock' );
				if ( 'yes' == $manage_stock && 'yes' == $ced_rnx_manage_stock_for_exchange ) {
					?>
					<div><?php esc_html_e( 'When Product Back in stock then for stock management click on ', 'woocommerce-refund-and-exchange' ); ?> <input type="button" name="ced_rnx_stock_back" class="button button-primary" id="ced_rnx_stock_back" data-type="ced_rnx_exchange" data-orderid="<?php echo esc_html( $order_id ); ?>" Value="Manage Stock" ></div> 
					<?php
				}
			}
			if ( 'cancel' == $exchange_detail['status'] ) {
				$approve_date = date_create( $exchange_detail['cancel_date'] );
				$approve_date = date_format( $approve_date, 'F d, Y' );
				?>
				</p><p>
				<?php
				esc_html_e( 'The above product exchange request is cancelled on  ', 'woocommerce-refund-and-exchange' );
				?>
				<b><?php echo esc_html( $approve_date ); ?>.</b>
				<?php
			}
			?>
			</p>
			<hr/>
			<?php
		}
	}
} else {
	$ced_rnx_pages = get_option( 'ced_rnx_pages' );
	$page_id = $ced_rnx_pages['pages']['ced_exchange_from'];
	$exchange_url = get_permalink( $page_id );
	$order_id = $order_obj->get_id();
	$ced_rnx_exchange_url = add_query_arg( 'order_id', $order_id, $exchange_url );
	?>
<p><?php esc_html_e( 'No request from customer', 'woocommerce-refund-and-exchange' ); ?></p>
<a target="_blank" href="<?php echo esc_url( $ced_rnx_exchange_url ); ?>" class="button-primary button"><b><?php esc_html_e( 'Initiate Exchange Request', 'woocommerce-refund-and-exchange' ); ?></b></a>
	<?php
}
?>
