<?php
/**
 * The admin-specific functionality of the plugin.
 *
 * @link  https://wpswings.com/
 * @since 1.0.0
 *
 * @package    woocommerce-refund-and-exchange
 * @subpackage woocommerce-refund-and-exchange/admin
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Show Return Product detail on Order Page on admin Side.

if ( ! is_int( $thepostid ) && isset( $post ) ) {
	$thepostid = $post->ID;
}
if ( isset( $order ) && is_object( $order ) && ! $order instanceof WP_Post ) {
	$theorder = $order;
}
$order_obj = $theorder;

$order_id = $order_obj->get_id();

$return_datas = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_product', true );
$line_items  = $order_obj->get_items( apply_filters( 'woocommerce_admin_order_item_types', 'line_item' ) );
$save_ref_line_items = wps_wrma_get_meta_data( $order_id, 'ced_rnx_save_ref_line_items', true );
if ( empty( $save_ref_line_items ) ) {
	wps_wrma_update_meta_data( $order_id, 'mwb_rnx_new_refund_line_items', $line_items );
	wps_wrma_update_meta_data( $order_id, 'ced_rnx_save_ref_line_items', 'saved' );
}
$line_items = wps_wrma_get_meta_data( $order_id, 'mwb_rnx_new_refund_line_items', true );


if ( isset( $return_datas ) && ! empty( $return_datas ) ) {
	foreach ( $return_datas as $key => $return_data ) {
		$date = date_create( $key );
		$date_format = get_option( 'date_format' );
		$date = date_format( $date, $date_format );
		?>
		<p><?php esc_html_e( 'Following product refund request made on', 'woocommerce-refund-and-exchange' ); ?> <b><?php echo esc_html( $date ); ?>.</b></p>
		<div>
		<div id="ced_rnx_return_wrapper">
			<table>
				<thead>
					<tr>
						<th><?php esc_html_e( 'Item', 'woocommerce-refund-and-exchange' ); ?></th>
						<th><?php esc_html_e( 'Name', 'woocommerce-refund-and-exchange' ); ?></th>
						<th><?php esc_html_e( 'Cost', 'woocommerce-refund-and-exchange' ); ?></th>
						<th><?php esc_html_e( 'Qty', 'woocommerce-refund-and-exchange' ); ?></th>
						<th><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
					</tr>
				</thead>
				<tbody>
				<?php
				$total = 0;
				$return_products = $return_data['products'];
				foreach ( $line_items as $item_id => $item ) {
					foreach ( $return_products as $refundkey => $return_product ) {
						if ( $item_id == $return_product['item_id'] ) {
							$refund_product_detail = $order_obj->get_meta_data();
							foreach ( $refund_product_detail as $rpd_value ) {
								$refund_product_data = $rpd_value->get_data();
								if ( 'ced_rnx_return_product' == $refund_product_data['key'] ) {
									$refund_product_values = $refund_product_data['value'];
									foreach ( $refund_product_values as $rpv_value ) {
										$refund_product_values1 = $rpv_value['products'];
										foreach ( $refund_product_values1 as $rpv1_value ) {
											$refund_product_id = $rpv1_value['product_id'];
											$get_return_product = wc_get_product( $refund_product_id );
											$new_refund_image = wp_get_attachment_image_src( get_post_thumbnail_id( $refund_product_id ), 'single-post-thumbnail' );
											$refund_product_new[] = array(
												'name'  => $get_return_product->get_name(),
												'sku'   => $get_return_product->get_sku(),
												'image' => $new_refund_image ? $new_refund_image[0] : null,
											);
										}
									}
								}
							}
							$_product  = $item->get_product();
							$item_meta = wc_get_order_item_meta( $item_id, $key );
							$thumbnail = $_product ? apply_filters( 'woocommerce_admin_order_item_thumbnail', $_product->get_image( 'thumbnail', array( 'title' => '' ), false ), $item_id, $item ) : '';
							?>
							<tr>
								<td class="thumb">
								<?php
								if ( isset( $refund_product_new[ $refundkey ]['image'] ) && ! empty( $refund_product_new[ $refundkey ]['image'] ) ) {
									echo wp_kses_post( '<div class="wc-order-item-thumbnail"><img src ="' . $refund_product_new[ $refundkey ]['image'] . '"></div>' );
								}
								?>
								</td>
								<td class="name">
								<?php
									echo esc_html( $item['name'] );
								if ( isset( $refund_product_new[ $refundkey ]['name'] ) && ! empty( $refund_product_new[ $refundkey ]['name'] ) ) {
									echo esc_html( $refund_product_new[ $refundkey ]['name'] );
								}
								if ( isset( $refund_product_new[ $refundkey ]['sku'] ) && ! empty( $refund_product_new[ $refundkey ]['sku'] ) ) {
									echo '<div class="wc-order-item-sku"><strong>' . esc_html__( 'SKU:', 'woocommerce-refund-and-exchange' ) . '</strong> ' . esc_html( $refund_product_new[ $refundkey ]['sku'] ) . '</div>';
								}
								if ( ! empty( $item['variation_id'] ) ) {
									echo '<div class="wc-order-item-variation"><strong>' . esc_html__( 'Variation ID:', 'woocommerce-refund-and-exchange' ) . '</strong> ';
									if ( ! empty( $item['variation_id'] ) && 'product_variation' === get_post_type( $item['variation_id'] ) ) {
										echo esc_html( $item['variation_id'] );
									} elseif ( ! empty( $item['variation_id'] ) ) {
										echo esc_html( $item['variation_id'] ) . ' (' . esc_html__( 'No longer exists', 'woocommerce-refund-and-exchange' ) . ')';
									}
									echo '</div>';
								}

								$item_meta      = new WC_Order_Item_Product( $item, $_product );
								wc_display_item_meta( $item_meta );

								?>
								</td>
								<td><?php echo wp_kses_post( ced_rnx_format_price( $return_product['price'] ) ); ?></td>
								<td><?php echo wp_kses_post( $return_product['qty'] ); ?></td>
								<td><?php echo wp_kses_post( ced_rnx_format_price( $return_product['price'] * $return_product['qty'] ) ); ?></td>
							</tr>
							<?php
							$total += $return_product['price'] * $return_product['qty'];
						}
					}
				}
				?>
					<tr>
						<th colspan="4"><?php esc_html_e( 'Total Amount', 'woocommerce-refund-and-exchange' ); ?></th>
						<th><?php echo wp_kses_post( ced_rnx_format_price( $total ) ); ?></th>
					</tr>
				</tbody>
			</table>	
		</div>
		<div class="ced_rnx_extra_reason ced_rnx_extra_reason_for_refund">
		<?php

		$fee_enable = get_option( 'ced_rnx_return_shipcost_enable', false );
		if ( 'yes' == $fee_enable ) {
			?>
			<p><?php esc_html_e( 'Fees amount will be deducted from Refund amount', 'woocommerce-refund-and-exchange' ); ?></p>
			<?php
			$disable = '';
			if ( 'pending' != $return_data['status'] ) {
				$disable = 'readonly';
			} else {
				?>
			<div id="ced_rnx_add_fee">
				<?php
			}
			$added_fees = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_added_fee', true );
			$all_product_is_refunded = wps_wrma_get_meta_data( $order_id, 'all_product_is_refunded', true );


			if ( isset( $added_fees ) && ! empty( $added_fees ) ) {
				if ( is_array( $added_fees ) ) {
					foreach ( $added_fees as $da => $added_fee ) {
						if ( $da == $key ) {
							if ( is_array( $added_fee ) ) {
								foreach ( $added_fee as $fee ) {
									$return_data['amount'] -= $fee['val'];
									if ( 'pending' == $return_data['status'] ) {
										?>
									<div class="ced_rnx_add_fee">

										<?php
									}
									?>

										<input type="text" placeholder="<?php esc_html_e( 'Fee Name', 'woocommerce-refund-and-exchange' ); ?>" <?php echo esc_html( $disable ); ?> value="<?php echo esc_html( $fee['text'] ); ?>" name="ced_return_fee_txt[]" class="ced_return_fee_txt">
										<input type="text" name="" placeholder="0" <?php echo esc_html( $disable ); ?> value="<?php echo esc_html( $fee['val'] ); ?>" class="ced_return_fee_value wc_input_price">
										<?php
										if ( 'pending' == $return_data['status'] ) {
											?>
										<input type="button" value="<?php esc_html_e( 'Remove', 'woocommerce-refund-and-exchange' ); ?>" class="button ced_rnx_remove-return-product-fee">
											<?php
										}
										if ( 'pending' == $return_data['status'] ) {
											?>
									</div>
											<?php
										}
								}
							}
							break;
						}
					}
				}
			}
			if ( 'yes' == $all_product_is_refunded ) {
				$shipping_price = $order_obj->get_shipping_total();
				$return_data['amount'] = $return_data['amount'] + $shipping_price;
			}
			if ( 'pending' == $return_data['status'] ) {
				?>
				</div>
				<button class="button ced_rnx_add-return-product-fee" type="button"><?php esc_html_e( 'Add Fee', 'woocommerce-refund-and-exchange' ); ?></button>
				<button class="button button-primary ced_rnx_save-return-product-fee" type="button" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $key ); ?>"><?php esc_html_e( 'Save', 'woocommerce-refund-and-exchange' ); ?></button>
				<?php
			}
		}

		if ( 'pending' == $return_data['status'] ) {
			?>
			<input type="hidden" value="<?php echo isset( $return_data['amount'] ) ? esc_html( $return_data['amount'] ) : 0; ?>" id="ced_rnx_refund_amount">
			<input type="hidden" value="<?php echo isset( $return_data['subject'] ) ? esc_html( $return_data['subject'] ) : ''; ?>" id="ced_rnx_refund_reason">
			<?php
		}
		?>
		<p><strong>
		<?php esc_html_e( 'Refund Amount', 'woocommerce-refund-and-exchange' ); ?> :</strong> <?php echo wp_kses_post( ced_rnx_format_price( $return_data['amount'] ) ); ?> <input type="hidden" name="ced_rnx_total_amount_for_refund" class="ced_rnx_total_amount_for_refund" value="<?php echo esc_html( $return_data['amount'] ); ?>"></p>
		<div class="ced_rnx_reason">
			<p><strong><?php esc_html_e( 'Subject', 'woocommerce-refund-and-exchange' ); ?> :</strong><i> <?php echo isset( $return_data['subject'] ) ? esc_html( $return_data['subject'] ) : ''; ?></i></p></p>
			<p><b><?php esc_html_e( 'Reason', 'woocommerce-refund-and-exchange' ); ?> :</b></p>
			<p><?php echo isset( $return_data['reason'] ) ? esc_html( $return_data['reason'] ) : ''; ?></p>
			<?php
			$bank_details = wps_wrma_get_meta_data( $order_id, 'ced_rnx_bank_details', true );
			if ( ! empty( $bank_details ) ) {
				?>
				<p><strong><?php esc_html_e( 'Bank Details', 'woocommerce-refund-and-exchange' ); ?> :</strong><i> <?php echo esc_html( $bank_details ); ?></i></p>
				<?php
			}
			?>
			<?php
			$req_attachments = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_attachment', true );

			if ( isset( $req_attachments ) && ! empty( $req_attachments ) ) {
				?>
				<p><b><?php esc_html_e( 'Attachment', 'woocommerce-refund-and-exchange' ); ?> :</b></p>
				<?php
				if ( is_array( $req_attachments ) ) {
					foreach ( $req_attachments as $da => $attachments ) {
						if ( $da == $key ) {
							$count = 1;
							foreach ( $attachments['files'] as $attachment ) {
								if ( $attachment != $order_id . '-' ) {
									?>
									<a href="<?php echo esc_url( home_url() ); ?>/wp-content/attachment/<?php echo esc_html( $attachment ); ?>" target="_blank"><?php esc_html_e( 'Attachment', 'woocommerce-refund-and-exchange' ); ?>-<?php echo esc_html( $count ); ?></a>
									<?php
									$count++;
								}
							}
							break;
						}
					}
				}
			}
			if ( 'pending' == $return_data['status'] ) {
				wps_wrma_update_meta_data( $order_id, 'refundable_amount', $return_data['amount'] );
				?>
				<p id="ced_rnx_return_package">
				<input type="button" value="<?php esc_html_e( 'Accept Request', 'woocommerce-refund-and-exchange' ); ?>" class="button" id="ced_rnx_accept_return" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $key ); ?>">
				<input type="button" value="<?php esc_html_e( 'Cancel Request', 'woocommerce-refund-and-exchange' ); ?>" class="button" id="ced_rnx_cancel_return" data-orderid="<?php echo esc_html( $order_id ); ?>" data-date="<?php echo esc_html( $key ); ?>">
				</p>
				<?php
			}
			?>
		</div>
		<div class="ced_rnx_return_loader">
			<img src="<?php echo esc_url( home_url() ); ?>/wp-admin/images/spinner-2x.gif">
		</div>
		</div>	
		</div>
		<p>
		<?php
		if ( 'complete' === $return_data['status'] ) {
			?>
			<input type="hidden" value="<?php echo wp_kses_post( ced_rnx_currency_seprator( $return_data['amount'] ) ); ?>" id="ced_rnx_refund_amount">
			<input type="hidden" value="<?php echo isset( $return_data['subject'] ) ? esc_html( $return_data['subject'] ) : ''; ?>" id="ced_rnx_refund_reason">
			<?php
			$refundable_amount = 0;
			$refundable_amount = wps_wrma_get_meta_data( $order_id, 'refundable_amount', true );
			$approve_date = date_create( $return_data['approve_date'] );
			$date_format = get_option( 'date_format' );
			$approve_date = date_format( $approve_date, $date_format );
			$ced_refunded = wps_wrma_get_meta_data( $order_id, 'ced_rnx_refund_approve_refunded', true );

			if ( $refundable_amount > 0 ) {
				esc_html_e( 'Following product refund request is approved on', 'woocommerce-refund-and-exchange' );
				?>
				 <b><?php echo esc_html( $approve_date ); ?>.</b><input type="button" name="ced_rnx_left_amount" class="button button-primary" data-orderid="<?php echo esc_html( $order_id ); ?>" id="ced_rnx_refund_left_amount" Value="Refund Amount" > 
				<?php
			} else {
				esc_html_e( 'Following product refund request is approved on', 'woocommerce-refund-and-exchange' );
				?>
				<b><?php echo esc_html( $approve_date ); ?>.</b>
				<?php
			}
			$ced_rnx_manage_stock_for_return = wps_wrma_get_meta_data( $order_id, 'ced_rnx_manage_stock_for_return', true );
			if ( '' == $ced_rnx_manage_stock_for_return ) {
				$ced_rnx_manage_stock_for_return = 'yes';
			}
			$manage_stock = get_option( 'ced_rnx_return_request_manage_stock' );
			if ( 'yes' == $manage_stock && 'yes' == $ced_rnx_manage_stock_for_return ) {
				?>
				<div id="ced_rnx_stock_button_wrapper"><?php esc_html_e( 'When Product Back in stock then for stock management click on ', 'woocommerce-refund-and-exchange' ); ?> <input type="button" name="ced_rnx_stock_back" class="button button-primary" id="ced_rnx_stock_back" data-type="ced_rnx_return" data-orderid="<?php echo esc_html( $order_id ); ?>" Value="Manage Stock" ></div> 
				<?php
			}
		}
		if ( 'cancel' == $return_data['status'] ) {
			$approve_date = date_create( $return_data['cancel_date'] );
			$approve_date = date_format( $approve_date, 'F d, Y' );

			esc_html_e( 'Following product refund request is cancelled on ', 'woocommerce-refund-and-exchange' );
			?>
			<b><?php echo esc_html( $approve_date ); ?>.</b>
			<?php
		}
		?>
		</p>
		<hr/>
		<?php
	}
} else {
	$ced_rnx_pages = get_option( 'ced_rnx_pages' );
	$page_id = $ced_rnx_pages['pages']['ced_return_from'];
	$return_url = get_permalink( $page_id );
	$order_id = $order_obj->get_id();
	$ced_rnx_return_url = add_query_arg( 'order_id', $order_id, $return_url );
	?>
<p><?php esc_html_e( 'No request from customer', 'woocommerce-refund-and-exchange' ); ?></p>
<a target="_blank" href="<?php echo esc_url( $ced_rnx_return_url ); ?>" class="button-primary button"><b><?php esc_html_e( 'Initiate Refund Request', 'woocommerce-refund-and-exchange' ); ?></b></a>
	<?php
}
?>
