<?php
/**
 * Exit if accessed directly
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * CED_rnx_order_return
 */
if ( ! class_exists( 'CED_rnx_order_return' ) ) {

	/**
	 * This is class for managing return process at front end.
	 *
	 * @name    CED_rnx_order_return
	 * @category Class
	 * @author wpswings<support@wpswings.com>
	 */
	class CED_rnx_order_return {

		/**
		 * Construct of class
		 *
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function __construct() {

			add_action( 'plugins_loaded', array( $this, 'mwb_wpr_load_woocommerce' ) );
		}

		/**
		 * Load the hooks
		 *
		 * @return void
		 */
		public function mwb_wpr_load_woocommerce() {
			if ( function_exists( 'WC' ) ) {

				$this->add_hooks_and_filters();
			}
		}

		/**
		 * Hook and filter function
		 *
		 * @return void
		 */
		public function add_hooks_and_filters() {
			add_action( 'woocommerce_order_details_after_order_table', array( $this, 'ced_rnx_order_return_button' ) );
			add_action( 'wp_ajax_ced_rnx_return_upload_files', array( $this, 'ced_rnx_order_return_attach_files' ) );
			add_action( 'wp_ajax_nopriv_ced_rnx_return_upload_files', array( $this, 'ced_rnx_order_return_attach_files' ) );
			add_action( 'wp_ajax_ced_rnx_return_product_info', array( $this, 'ced_rnx_return_product_info_callback' ) );
			add_action( 'wp_ajax_nopriv_ced_rnx_return_product_info', array( $this, 'ced_rnx_return_product_info_callback' ) );

				add_action( 'woocommerce_new_order_item', array( $this, 'ced_rnx_woocommerce_order_add_coupon' ), 10, 3 );

			add_action( 'woocommerce_after_checkout_validation', array( $this, 'ced_rnx_woocommerce_after_checkout_validation' ) );
			add_filter( 'woocommerce_available_payment_gateways', array( $this, 'ced_rnx_woocommerce_available_payment_gateways' ), 5, 1 );
			add_action( 'woocommerce_before_pay_action', array( $this, 'ced_rnx_pay_order_validation' ), 10 );
			add_action( 'wp_ajax_ced_rnx_calculate_price_deduct_on_return', array( $this, 'ced_rnx_calculate_price_deduct_on_return' ) );
			add_action( 'wp_ajax_nopriv_ced_rnx_calculate_price_deduct_on_return', array( $this, 'ced_rnx_calculate_price_deduct_on_return' ) );
		}

		/**
		 * Calculate price deduct on return
		 *
		 * @return void
		 */
		public function ced_rnx_calculate_price_deduct_on_return() {
			$product_qty   = isset( $_POST['product_qty'] ) ? sanitize_text_field( wp_unslash( $_POST['product_qty'] ) ) : 0;
			$product_total = isset( $_POST['product_total'] ) ? sanitize_text_field( wp_unslash( $_POST['product_total'] ) ) : 0;
			$ced_rnx_enable_price_policy = get_option( 'ced_rnx_enable_price_policy', 'no' );
			if ( 'no' === $ced_rnx_enable_price_policy ) {
				echo esc_html( $product_total );
				wp_die();
			}
			$ced_rnx_price_policy_array = array();
			$ced_rnx_number_of_days     = get_option( 'ced_rnx_number_of_days', array() );
			$ced_rnx_price_reduced      = get_option( 'ced_rnx_price_reduced', array() );
			foreach ( $ced_rnx_number_of_days as $key => $value ) {
				foreach ( $ced_rnx_price_reduced as $key1 => $value1 ) {
					if ( $key1 === $key ) {
						$ced_rnx_price_policy_array[ $value ] = $value1;
					}
				}
			}
			ksort( $ced_rnx_price_policy_array );
			$order_id = isset( $_POST['order_id'] ) ? sanitize_text_field( wp_unslash( $_POST['order_id'] ) ) : 0;
			if ( ! empty( $ced_rnx_number_of_days ) ) {
				$order        = wc_get_order( $order_id );
				$order_date   = $order->order_date;
				$order_date   = strtotime( $order_date );
				$current_date = strtotime( current_time( 'Y-m-d h:i:s' ) );
				$date_dif     = $current_date - $order_date;
				$date_dif     = floor( $date_dif / ( 60 * 60 * 24 ) );
				foreach ( $ced_rnx_price_policy_array as $key => $value ) {
					if ( $date_dif > $key ) {
						continue;
					} else {
						$product_total = $product_total - $product_total * $value / 100;
						break;
					}
				}
			}
			echo esc_html( $product_total );
			wp_die();
		}

		/**
		 * Manage wallet payment gateway avaliability
		 *
		 * @param array() $payment_gateways .
		 * @return $payment_gateways
		 */
		public function ced_rnx_woocommerce_available_payment_gateways( $payment_gateways ) {
			if ( ced_rnx_wallet_feature_enable() ) {
				$customer_id = get_current_user_id();
				if ( $customer_id > 0 ) {
					$customer_coupon_id = 0;
					$walletcoupon       = wps_wrma_get_meta_data( $customer_id, 'ced_rnx_refund_wallet_coupon', true );
					if ( ! empty( $walletcoupon ) && isset( $walletcoupon ) ) {
						$the_coupon = new WC_Coupon( $walletcoupon );

						$customer_coupon_id = $the_coupon->get_id();
						if ( isset( $customer_coupon_id ) ) {
							$amount = wps_wrma_get_meta_data( $customer_coupon_id, 'coupon_amount', true );
							if ( $amount <= 0 ) {
								if ( isset( $payment_gateways['wallet_gateway'] ) ) {
									unset( $payment_gateways['wallet_gateway'] );
									return $payment_gateways;
								}
							}
						}
						if ( isset( WC()->cart ) && ! empty( WC()->cart ) ) {
							$applied_coupon_ids = array();
							$applied_coupons    = WC()->cart->applied_coupons;
							foreach ( $applied_coupons as $applied_coupon ) {
								$the_coupon = new WC_Coupon( $applied_coupon );
								$coupon_id  = $the_coupon->get_id();
								if ( isset( $coupon_id ) ) {
									$applied_coupon_ids[] = $coupon_id;
								}
							}
						}

						if ( isset( $applied_coupon_ids ) && in_array( $customer_coupon_id, $applied_coupon_ids ) ) {
							if ( isset( $payment_gateways['wallet_gateway'] ) ) {
								unset( $payment_gateways['wallet_gateway'] );
							}
						}
					} elseif ( isset( $payment_gateways['wallet_gateway'] ) ) {
							unset( $payment_gateways['wallet_gateway'] );
					}
				} elseif ( isset( $payment_gateways['wallet_gateway'] ) ) {
						unset( $payment_gateways['wallet_gateway'] );
				}
			} elseif ( isset( $payment_gateways['wallet_gateway'] ) ) {
					unset( $payment_gateways['wallet_gateway'] );
			}
			return $payment_gateways;
		}

		/**
		 * This function is used to validate the wallet amount in respect to cart total
		 *
		 * @param array $posted .
		 * @name ced_rnx_woocommerce_after_checkout_validation
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function ced_rnx_woocommerce_after_checkout_validation( $posted ) {
			if ( ced_rnx_wallet_feature_enable() ) {
				if ( isset( $posted['payment_method'] ) ) {
					$payment_type = $posted['payment_method'];
					if ( 'wallet_gateway' === $payment_type ) {
						$customer_id = get_current_user_id();
						if ( $customer_id > 0 ) {
							global $woocommerce;
							$carttotal    = floatval( preg_replace( '#[^\d.]#', '', $woocommerce->cart->total ) );
							$walletcoupon = wps_wrma_get_meta_data( $customer_id, 'ced_rnx_refund_wallet_coupon', true );
							if ( ! empty( $walletcoupon ) && isset( $walletcoupon ) ) {
								$the_coupon = new WC_Coupon( $walletcoupon );
								$coupon_id  = $the_coupon->get_id();
								if ( isset( $coupon_id ) ) {
									$amount = wps_wrma_get_meta_data( $coupon_id, 'coupon_amount', true );
									if ( $carttotal > $amount ) {
										wc_add_notice( sprintf( __( "Your Wallet doesn't have a sufficient amount to place an order. For using Wallet amount use Coupon Code : %1\$s %2\$s %3\$s", 'woocommerce-refund-and-exchange' ), '<b>', $walletcoupon, '</b>' ), 'error' );
									}
								}
							}
						}
					}
				}
			}
		}

		/**
		 * This function is used to validate the wallet amount in respect to cart total on the pay order page
		 *
		 * @param array $posted .
		 * @name ced_rnx_woocommerce_after_checkout_validation
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function ced_rnx_pay_order_validation( $posted ) {
			if ( ced_rnx_wallet_feature_enable() ) {
				if ( isset( $_POST['payment_method'] ) ) {
					$payment_type = isset( $_POST['payment_method'] ) ? sanitize_text_field( wp_unslash( $_POST['payment_method'] ) ) : '';
					if ( 'wallet_gateway' === $payment_type ) {
						$customer_id = get_current_user_id();
						if ( $customer_id > 0 ) {
							$cart_total   = wps_wrma_get_meta_data( $posted->id, '_order_total', true );
							$walletcoupon = wps_wrma_get_meta_data( $customer_id, 'ced_rnx_refund_wallet_coupon', true );
							if ( ! empty( $walletcoupon ) && isset( $walletcoupon ) ) {
								$the_coupon = new WC_Coupon( $walletcoupon );

									$coupon_id = $the_coupon->get_id();

								if ( isset( $coupon_id ) ) {
									$amount = wps_wrma_get_meta_data( $coupon_id, 'coupon_amount', true );
									if ( $cart_total > $amount ) {
										wc_add_notice( sprintf( __( "Your Wallet doesn't have a sufficient amount to place an order. Please Select any other payment method", 'woocommerce-refund-and-exchange' ) ), 'error' );
										return;
									}
								}
							}
						}
					}
				}
			}
		}

		/**
		 * This function is to update wallet coupon amount
		 *
		 * @param int    $order_id .
		 * @param int    $item_id .
		 * @param string $coupon_code .
		 * @return void
		 */
		public function ced_rnx_woocommerce_order_add_coupon( $order_id, $item_id, $coupon_code ) {
			if ( ced_rnx_wallet_feature_enable() ) {
				$the_coupon = new WC_Coupon( $coupon_code );
				$coupon_id = $the_coupon->get_id();
				if ( isset( $coupon_id ) ) {
					$rnx_coupon = wps_wrma_get_meta_data( $coupon_id, 'rnxwallet', true );
					if ( $rnx_coupon ) {
						$amount           = wps_wrma_get_meta_data( $coupon_id, 'coupon_amount', true );
						$remaining_amount = $amount - $discount_amount;
						wps_wrma_update_meta_data( $coupon_id, 'coupon_amount', $remaining_amount );
					}
				}
			}
		}

		/**
		 * This function is to save return request
		 *
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function ced_rnx_return_product_info_callback() {
			$check_ajax = check_ajax_referer( 'ced-rnx-ajax-seurity-string', 'security_check' );
			if ( $check_ajax ) {
				$order_id              = isset( $_POST['orderid'] ) ? sanitize_text_field( wp_unslash( $_POST['orderid'] ) ) : '';
				$subject               = isset( $_POST['subject'] ) ? sanitize_text_field( wp_unslash( $_POST['subject'] ) ) : '';
				$reason                = isset( $_POST['reason'] ) ? sanitize_text_field( wp_unslash( $_POST['reason'] ) ) : '';
				$ced_rnx_refund_method = isset( $_POST['refund_method'] ) ? sanitize_text_field( wp_unslash( $_POST['refund_method'] ) ) : '';
				$ced_rnx_bank_details  = isset( $_POST['bank_details'] ) ? sanitize_text_field( wp_unslash( $_POST['bank_details'] ) ) : '';
				$checkall              = isset( $_POST['checkall'] ) ? sanitize_text_field( wp_unslash( $_POST['checkall'] ) ) : '';
				$wallet_enable = get_option( 'ced_rnx_return_wallet_enable', 'no' );
				$ced_select_rnx_refund_method = get_option( 'ced_rnx_select_refund_method_enable', 'no' );
				if ( 'yes' === $wallet_enable && 'yes' !== $ced_select_rnx_refund_method ) {
					$ced_rnx_refund_method = 'wallet_method';
				}

				$ced_rnx_customer_contact_refund = isset( $_POST['ced_rnx_customer_contact_refund'] ) ? sanitize_text_field( wp_unslash( $_POST['ced_rnx_customer_contact_refund'] ) ) : '';
				if ( $ced_rnx_customer_contact_refund ) {
					wps_wrma_update_meta_data( $order_id, 'ced_rnx_customer_contact_refund', $ced_rnx_customer_contact_refund );
				}

				wps_wrma_update_meta_data( $order_id, 'ced_rnx_refund_method', $ced_rnx_refund_method );
				if ( $ced_rnx_bank_details ) {
					wps_wrma_update_meta_data( $order_id, 'ced_rnx_bank_details', $ced_rnx_bank_details );
				}
				$products = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_product', true );
				$pending  = true;
				if ( isset( $products ) && ! empty( $products ) ) {
					foreach ( $products as $date => $product ) {
						if ( 'pending' === $product['status'] ) {
							$products[ $date ]           = $_POST;
							$products[ $date ]['status'] = 'pending'; // update requested products.
							$pending                     = false;
							break;
						}
					}
				}
				if ( $pending ) {
					if ( ! is_array( $products ) ) {
						$products = array();
					}

					$date                        = gmdate( 'd-m-Y' );
					$products[ $date ]           = $_POST;
					$products[ $date ]['status'] = 'pending';
				}

				wps_wrma_update_meta_data( $order_id, 'ced_rnx_request_made', true );

				wps_wrma_update_meta_data( $order_id, 'ced_rnx_return_product', $products );

				// Send mail to merchant.
				$subject = str_replace( '[order]', '#' . $order_id, $subject );

				$reason_subject = $subject;

				$mail_header = stripslashes( get_option( 'ced_rnx_notification_mail_header', false ) );
				$mail_header = apply_filters( 'mwb_rnx_meta_content', $mail_header );

				$mail_footer = stripslashes( get_option( 'ced_rnx_notification_mail_footer', false ) );
				$mail_footer = apply_filters( 'mwb_rnx_meta_content', $mail_footer );

				$message = '<html>
								<body>
						' . do_action( 'wrnx_return_request_before_mail_content', $order_id ) . '
								<style>
								body {
								    box-shadow: 2px 2px 10px #ccc;
								    color: #767676;
								    font-family: Arial,sans-serif;
								    margin: 80px auto;
								    max-width: 700px;
								    padding-bottom: 30px;
								    width: 100%;
								}
								
								h2 {
									font-size: 30px;
									margin-top: 0;
									color: #fff;
									padding: 40px;
									background-color: #557da1;
								}
								
								h4 {
									color: #557da1;
									font-size: 20px;
									margin-bottom: 10px;
								}
								
								.content {
									padding: 0 40px;
								}
								
								.Customer-detail ul li p {
									margin: 0;
								}
								
								.details .Shipping-detail {
									width: 40%;
									float: right;
								}
								
								.details .Billing-detail {
									width: 60%;
									float: left;
								}
								
								.details .Shipping-detail ul li,.details .Billing-detail ul li {
									list-style-type: none;
									margin: 0;
								}
								
								.details .Billing-detail ul,.details .Shipping-detail ul {
									margin: 0;
									padding: 0;
								}
								
								.clear {
									clear: both;
								}
								
								table,td,th {
									border: 2px solid #ccc;
									padding: 15px;
									text-align: left;
								}
								
								table {
									border-collapse: collapse;
									width: 100%;
								}
								
								.info {
									display: inline-block;
								}
								
								.bold {
									font-weight: bold;
								}
								
								.footer {
									margin-top: 30px;
									text-align: center;
									color: #99B1D8;
									font-size: 12px;
								}
							dl.variation dd {
							    font-size: 12px;
							    margin: 0;
								}
								</style>
								<div class="header" style="text-align:center;padding: 10px;">
									' . $mail_header . '
									</div>	
								<div class="header">
									<h2>' . $reason_subject . '</h2>
								</div>
								<div class="content">
										
									<div class="reason">
										<h4>' . __( 'Reason of Refund', 'woocommerce-refund-and-exchange' ) . '</h4>
										<p>' . $reason . '</p>
									</div>
									<div class="Order">
										<h4>Order #' . $order_id . '</h4>
										<table>
											<tbody>
												<tr>
													<th>' . __( 'Product', 'woocommerce-refund-and-exchange' ) . '</th>
													<th>' . __( 'Quantity', 'woocommerce-refund-and-exchange' ) . '</th>
													<th>' . __( 'Price', 'woocommerce-refund-and-exchange' ) . '</th>
												</tr>';
					$order              = new WC_Order( $order_id );
					$requested_products = $products[ $date ]['products'];
				if ( isset( $requested_products ) && ! empty( $requested_products ) ) {
					$total = 0;
					foreach ( $order->get_items() as $item_id => $item ) {
						$product = apply_filters( 'woocommerce_order_item_product', $item->get_product(), $item );
						foreach ( $requested_products as $requested_product ) {
							if ( isset( $requested_product['item_id'] ) ) {
								if ( $item_id == $requested_product['item_id'] ) {
									if ( isset( $requested_product['variation_id'] ) && $requested_product['variation_id'] > 0 ) {
										$prod = wc_get_product( $requested_product['variation_id'] );

									} else {
										$prod = wc_get_product( $requested_product['product_id'] );
									}
									$subtotal = $requested_product['price'] * $requested_product['qty'];
									$total += $subtotal;

										$item_meta      = new WC_Order_Item_Product( $item, $_product );
										$item_meta_html = wc_display_item_meta( $item_meta, array( 'echo' => false ) );

									$message     .= '<tr>
														<td>' . $item['name'] . '<br>';
										$message .= '<small>' . $item_meta_html . '</small>
														<td>' . $requested_product['qty'] . '</td>
														<td>' . ced_rnx_format_price( $requested_product['price'] * $requested_product['qty'] ) . '</td>
													</tr>';
								}
							}
						}
					}
				}
				if ( $checkall ) {
					wps_wrma_update_meta_data( $order_id, 'all_product_is_refunded', 'yes' );
					$shipping_price = $order->get_shipping_total();
					$total += $shipping_price;
					$message .= '<tr>
									<th colspan="2">' . esc_html__( 'Refund Total', 'woocommerce-refund-and-exchange' ) . ':</th>
									<td>' . ced_rnx_format_price( $total ) . '( shipping price added )</td>
								</tr>';
				} else {

					$message .= '<tr>
									<th colspan="2">' . esc_html__( 'Refund Total', 'woocommerce-refund-and-exchange' ) . ':</th>
									<td>' . ced_rnx_format_price( $total ) . '</td>
								</tr>';
				}

					$message .= '</tbody>
						</table>
					</div>
					<div class="Customer-detail">
						<h4>' . __( 'Customer details', 'woocommerce-refund-and-exchange' ) . '</h4>
						<ul>
							<li><p class="info">
									<span class="bold">' . __( 'Email', 'woocommerce-refund-and-exchange' ) . ': </span>' . wps_wrma_get_meta_data( $order_id, '_billing_email', true ) . '
								</p></li>
							<li><p class="info">
									<span class="bold">' . __( 'Tel', 'woocommerce-refund-and-exchange' ) . ': </span>' . wps_wrma_get_meta_data( $order_id, '_billing_phone', true ) . '
								</p></li>
						</ul>
					</div>
					<div class="details">
						<div class="Shipping-detail">
							<h4>' . __( 'Shipping Address', 'woocommerce-refund-and-exchange' ) . '</h4>
							' . $order->get_formatted_shipping_address() . '
						</div>
						<div class="Billing-detail">
							<h4>' . __( 'Billing Address', 'woocommerce-refund-and-exchange' ) . '</h4>
							' . $order->get_formatted_billing_address() . '
						</div>
						<div class="clear"></div>
					</div>
					
				</div>
				<div class="footer" style="text-align:center;padding: 10px;">
					' . $mail_footer . '
				</div>
									
			</body>
			</html>';

				$headers   = array();
				$headers[] = 'Content-Type: text/html; charset=UTF-8';
				$to        = get_option( 'ced_rnx_notification_from_mail' );
				$subject   = get_option( 'ced_rnx_notification_merchant_return_subject' );
				$subject   = str_replace( '[order]', '#' . $order_id, $subject );
				$customer_message = $message;

				wc_mail( $to, $subject, $message, $headers );

				// Send mail to User that we recieved your request.

				$fname = get_option( 'ced_rnx_notification_from_name' );
				$fmail = get_option( 'ced_rnx_notification_from_mail' );

				$to = wps_wrma_get_meta_data( $order_id, '_billing_email', true );
				$headers   = array();
				$headers[] = "From: $fname <$fmail>";
				$headers[] = 'Content-Type: text/html; charset=UTF-8';
				$subject = get_option( 'ced_rnx_notification_return_subject' );
				$subject = str_replace( '[order]', '#' . $order_id, $subject );
				$message = stripslashes( get_option( 'ced_rnx_notification_return_rcv' ) );
				$message = apply_filters( 'mwb_rnx_meta_content', $message );

				// shortcode replace variable start.

				$fname = wps_wrma_get_meta_data( $order_id, '_billing_first_name', true );
				$lname = wps_wrma_get_meta_data( $order_id, '_billing_last_name', true );
				$billing_company = wps_wrma_get_meta_data( $order_id, '_billing_company', true );
				$billing_email = wps_wrma_get_meta_data( $order_id, '_billing_email', true );
				$billing_phone = wps_wrma_get_meta_data( $order_id, '_billing_phone', true );
				$billing_country = wps_wrma_get_meta_data( $order_id, '_billing_country', true );
				$billing_address_1 = wps_wrma_get_meta_data( $order_id, '_billing_address_1', true );
				$billing_address_2 = wps_wrma_get_meta_data( $order_id, '_billing_address_2', true );
				$billing_state = wps_wrma_get_meta_data( $order_id, '_billing_state', true );
				$billing_postcode = wps_wrma_get_meta_data( $order_id, '_billing_postcode', true );
				$shipping_first_name = wps_wrma_get_meta_data( $order_id, '_shipping_first_name', true );
				$shipping_last_name = wps_wrma_get_meta_data( $order_id, '_shipping_last_name', true );
				$shipping_company = wps_wrma_get_meta_data( $order_id, '_shipping_company', true );
				$shipping_country = wps_wrma_get_meta_data( $order_id, '_shipping_country', true );
				$shipping_address_1 = wps_wrma_get_meta_data( $order_id, '_shipping_address_1', true );
				$shipping_address_2 = wps_wrma_get_meta_data( $order_id, '_shipping_address_2', true );
				$shipping_city = wps_wrma_get_meta_data( $order_id, '_shipping_city', true );
				$shipping_state = wps_wrma_get_meta_data( $order_id, '_shipping_state', true );
				$shipping_postcode = wps_wrma_get_meta_data( $order_id, '_shipping_postcode', true );
				$payment_method_tittle = wps_wrma_get_meta_data( $order_id, '_payment_method_title', true );
				$order_shipping = wps_wrma_get_meta_data( $order_id, '_order_shipping', true );
				$order_total = wps_wrma_get_meta_data( $order_id, '_order_total', true );
				$refundable_amount = wps_wrma_get_meta_data( $order_id, 'refundable_amount', true );

				// shortcode replace variable end.

				$fullname = $fname . ' ' . $lname;

				$message = str_replace( '[username]', $fullname, $message );
				$message = str_replace( '[order]', '#' . $order_id, $message );
				$message = str_replace( '[siteurl]', home_url(), $message );
				$message = str_replace( '[_billing_company]', $billing_company, $message );
				$message = str_replace( '[_billing_email]', $billing_email, $message );
				$message = str_replace( '[_billing_phone]', $billing_phone, $message );
				$message = str_replace( '[_billing_country]', $billing_country, $message );
				$message = str_replace( '[_billing_address_1]', $billing_address_1, $message );
				$message = str_replace( '[_billing_address_2]', $billing_address_2, $message );
				$message = str_replace( '[_billing_state]', $billing_state, $message );
				$message = str_replace( '[_billing_postcode]', $billing_postcode, $message );
				$message = str_replace( '[_shipping_first_name]', $shipping_first_name, $message );
				$message = str_replace( '[_shipping_last_name]', $shipping_last_name, $message );
				$message = str_replace( '[_shipping_company]', $shipping_company, $message );
				$message = str_replace( '[_shipping_country]', $shipping_country, $message );
				$message = str_replace( '[_shipping_address_1]', $shipping_address_1, $message );
				$message = str_replace( '[_shipping_address_2]', $shipping_address_2, $message );
				$message = str_replace( '[_shipping_city]', $shipping_city, $message );
				$message = str_replace( '[_shipping_state]', $shipping_state, $message );
				$message = str_replace( '[_shipping_postcode]', $shipping_postcode, $message );
				$message = str_replace( '[_payment_method_tittle]', $payment_method_tittle, $message );
				$message = str_replace( '[_order_shipping]', $order_shipping, $message );
				$message = str_replace( '[_order_total]', $order_total, $message );
				$message = str_replace( '[_refundable_amount]', $refundable_amount, $message );
				$message = str_replace( '[formatted_shipping_address]', $order->get_formatted_shipping_address(), $message );
				$message = str_replace( '[formatted_billing_address]', $order->get_formatted_billing_address(), $message );

				$mail_header = stripslashes( get_option( 'ced_rnx_notification_mail_header', false ) );
				$mail_header = apply_filters( 'mwb_rnx_meta_content', $mail_header );
				$mail_footer = stripslashes( get_option( 'ced_rnx_notification_mail_footer', false ) );
				$mail_footer = apply_filters( 'mwb_rnx_meta_content', $mail_footer );

				$mail_header = str_replace( '[username]', $fullname, $mail_header );
				$mail_header = str_replace( '[order]', '#' . $order_id, $mail_header );
				$mail_header = str_replace( '[siteurl]', home_url(), $mail_header );

				$subject = str_replace( '[username]', $fullname, $subject );
				$subject = str_replace( '[order]', '#' . $order_id, $subject );
				$subject = str_replace( '[siteurl]', home_url(), $subject );

				$template = get_option( 'ced_rnx_notification_return_template', 'no' );
				$message = $customer_message;
				if ( isset( $template ) && 'on' === $template ) {
					$html_content = $message;
				} else {
					$html_content = '<html>
									<head>
										<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
										<meta name="viewport" content="width=device-width, initial-scale=1.0"/>
									</head>
									<body style="margin: 1% 0 0; padding: 0;">
										<table cellpadding="0" cellspacing="0" width="100%">
											<tr>
												<td style="text-align: center; margin-top: 30px; padding: 10px; color: #99B1D8; font-size: 12px;">
													' . $mail_header . '
												</td>
											</tr>
											<tr>
												<td>
													<table align="center" cellpadding="0" cellspacing="0" style="border-collapse: collapse; font-family:Open Sans; max-width: 600px; width: 100%;">
														<tr>
															<td style="padding: 36px 48px; width: 100%; background-color:#557DA1;color: #fff; font-size: 30px; font-weight: 300; font-family:helvetica;">' . $subject . '</td>
														</tr>
														<tr>
															<td style="width:100%; padding: 36px 48px 10px; background-color:#fdfdfd; font-size: 14px; color: #737373;">' . $message . '</td>
														</tr>
													</table>
												</td>
											</tr>
											<tr>
												<td style="text-align: center; margin-top: 30px; color: #99B1D8; font-size: 12px;">
													' . $mail_footer . '
												</td>
											</tr>				
										</table>
																
									</body>
								</html>';
				}
				$ced_rnx_restrict_mails = get_option( 'ced_rnx_return_restrict_customer_mails', true );
				if ( ! empty( $ced_rnx_restrict_mails ) && 'yes' !== $ced_rnx_restrict_mails ) {
					wc_mail( $to, $subject, $html_content, $headers );
				}

				// send sms notifcaition to admin if everthing is enable.
				$ced_rnx_sms_notification_enable = get_option( 'ced_rnx_sms_notification_enable' );
				if ( 'yes' == $ced_rnx_sms_notification_enable ) {
					$ced_rnx_sms_notification_from_customer = get_option( 'ced_rnx_sms_notification_from_customer' );
					if ( 'yes' == $ced_rnx_sms_notification_from_customer ) {
						// twilio credentials.
						$ced_rnx_twilio_account_Sid = get_option( 'ced_rnx_twilio_account_Sid' );
						$ced_rnx_twilio_account_auth_token = get_option( 'ced_rnx_twilio_account_auth_token' );
						$ced_rnx_twilio_account_number = get_option( 'ced_rnx_twilio_account_number' );

						// admin phone number.
						$ced_rnx_twilio_shop_owner_number = get_option( 'ced_rnx_twilio_shop_owner_number' );

						$default_admin_id = 1;
						$default_admin_name = get_user_meta( $default_admin_id, 'nickname', true );

						$site_name = get_bloginfo( 'name' );

						$message       = sprintf(
							/* translators: %1s: $full_name*/
							esc_html__(
								'Hello %1$s,
						This is to inform you that a user has submitted a return request for Order #%2$s - %3$s',
								'woocommerce-refund-and-exchange'
							),
							$default_admin_name,
							$order_id,
							$site_name
						);

						if ( isset( $ced_rnx_twilio_account_Sid ) && isset( $ced_rnx_twilio_account_auth_token ) && isset( $ced_rnx_twilio_account_number ) ) {

							$request_args = array(
								'body' => array(
									'To'   => $ced_rnx_twilio_shop_owner_number,
									'From' => $ced_rnx_twilio_account_number,
									'Body' => $message,
								),
								'headers' => array(
									'Authorization' => 'Basic ' . base64_encode( $ced_rnx_twilio_account_Sid . ':' . $ced_rnx_twilio_account_auth_token ),
									'Content-Type' => 'application/x-www-form-urlencoded',
								),
							);
							$response = wp_remote_post( 'https://api.twilio.com/2010-04-01/Accounts/' . $ced_rnx_twilio_account_Sid . '/Messages.json', $request_args );

							$response_body = wp_remote_retrieve_body( $response );

							$logger = wc_get_logger();

							$logger->info( wc_print_r( $order_id . $response_body, true ), array( 'source' => 'woocommerce-refund-and-exchange' ) );
						}
					}
				}
				// send sms notifcaition to admin if everthing is enable.

				$order = new WC_Order( $order_id );
				$order->update_status( 'wc-return-requested', 'User Request to Refund Product' );
				$response['msg'] = __( 'Message send successfully. You have received a notification mail regarding this, Please check your mail. Soon You redirect to the My Account Page. Thanks', 'woocommerce-refund-and-exchange' );

					$order_date = date_i18n( 'F j, Y', strtotime( $order->get_date_created() ) );

				$today_date  = time(); // Or your date as well.
				$order_date  = strtotime( $order_date );
				$days        = $today_date - $order_date;
				$day_diff    = floor( $days / ( 60 * 60 * 24 ) );
				$day_allowed = get_option( 'ced_rnx_auto_return_days', false );
				$auto_re     = get_option( 'ced_rnx_return_autoaccept_enable', 'no' );
				if ( $day_allowed >= $day_diff && ! empty( $day_allowed ) && 'yes' === $auto_re ) {
					$response['auto_accept'] = true;
				}
				echo wp_json_encode( $response );
				wp_die();
			}
		}

		/**
		 * This function is to save return request Attachment
		 *
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function ced_rnx_order_return_attach_files() {
			if ( isset( $_FILES['ced_rnx_return_request_files'] ) ) {
				if ( isset( $_FILES['ced_rnx_return_request_files']['tmp_name'] ) ) {
					$filename = array();
					$order_id = isset( $_POST['ced_rnx_return_request_order'] ) ? sanitize_text_field( wp_unslash( $_POST['ced_rnx_return_request_order'] ) ) : 0;
					$count = count( $_FILES['ced_rnx_return_request_files']['tmp_name'] );
					for ( $i = 0;$i < $count;$i++ ) {
						if ( isset( $_FILES['ced_rnx_return_request_files']['tmp_name'][ $i ] ) ) {
							$directory = ABSPATH . 'wp-content/attachment';
							if ( ! file_exists( $directory ) ) {
								mkdir( $directory, 0755, true );
							}

							$sourcepath = sanitize_text_field( wp_unslash( $_FILES['ced_rnx_return_request_files']['tmp_name'][ $i ] ) );
							$f_name      = isset( $_FILES['ced_rnx_return_request_files']['name'][ $i ] ) ? sanitize_text_field( wp_unslash( $_FILES['ced_rnx_return_request_files']['name'][ $i ] ) ) : '';
							$targetpath = $directory . '/' . $order_id . '-' . $f_name;
							$check = wp_check_filetype_and_ext( $_FILES['ced_rnx_return_request_files']['tmp_name'][ $i ], $_FILES['ced_rnx_return_request_files']['name'][ $i ] );
							if ( in_array( $check['ext'], array( 'jpg', 'jpeg', 'png' ), true ) ) {
								$filename[] = $order_id . '-' . $f_name;
								move_uploaded_file( $sourcepath, $targetpath );
							}
						}
					}

					$request_files = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_attachment', true );

					$pending = true;
					if ( isset( $request_files ) && ! empty( $request_files ) ) {
						foreach ( $request_files as $date => $request_file ) {
							if ( 'pending' === $request_file['status'] ) {
								unset( $request_files[ $date ][0] );
								$request_files[ $date ]['files']  = $filename;
								$request_files[ $date ]['status'] = 'pending';
								$pending                          = false;
								break;
							}
						}
					}

					if ( $pending ) {
						$request_files                    = array();
						$date                             = gmdate( 'd-m-Y' );
						$request_files[ $date ]['files']  = $filename;
						$request_files[ $date ]['status'] = 'pending';
					}

					wps_wrma_update_meta_data( $order_id, 'ced_rnx_return_attachment', $request_files );
					echo 'success';
				}
			}
			wp_die();
		}

		/**
		 * This function is to add Return button and Show return products
		 *
		 * @param object $order .
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		public function ced_rnx_order_return_button( $order ) {
			$ced_rnx_return_button_show = true;
			$ced_rnx_cancel_button_show = true;
			$ced_rnx_next_return        = true;
			$items                      = $order->get_items();
			$ced_rnx_catalog            = get_option( 'catalog', array() );
			$refund_button_hide         = get_option( 'ced_rnx_return_button_hide_enable', false );
			if ( ! is_user_logged_in() && null == WC()->session->get( 'ced_rnx_email' ) ) {
				$ced_rnx_return_button_show = false;
				$ced_rnx_cancel_button_show = false;
			}
			if ( is_array( $ced_rnx_catalog ) && ! empty( $ced_rnx_catalog ) ) {
				$ced_rnx_catalog_refund = array();
				foreach ( $items as $item ) {
					$product_id = $item['product_id'];
					if ( is_array( $ced_rnx_catalog ) && ! empty( $ced_rnx_catalog ) ) {
						foreach ( $ced_rnx_catalog as $key => $value ) {
							if ( is_array( $value['products'] ) ) {
								if ( in_array( $product_id, $value['products'] ) ) {
									$ced_rnx_catalog_refund[] = $value['refund'];
								}
							}
						}
					}
				}
				if ( is_array( $ced_rnx_catalog_refund ) && ! empty( $ced_rnx_catalog_refund ) ) {
					$ced_rnx_catalog_refund_days = max( $ced_rnx_catalog_refund );
				}
			}
			$ced_rnx_enable             = get_option( 'ced_rnx_return_exchange_enable', false );
			$ced_rnx_enable_time_policy = get_option( 'ced_rnx_enable_time_policy', 'no' );
			$ced_rnx_from_time          = get_option( 'ced_rnx_return_from_time', '' );
			$ced_rnx_to_time            = get_option( 'ced_rnx_return_to_time', '' );
			if ( 'yes' === $ced_rnx_enable ) {
				$order_id     = $order->get_id();
				$ced_rnx_made = wps_wrma_get_meta_data( $order_id, 'ced_rnx_request_made', true );
				if ( isset( $ced_rnx_made ) && ! empty( $ced_rnx_made ) ) {
					$ced_rnx_next_return = false;
				}
			}

			$order_total       = $order->get_total();
			$return_min_amount = get_option( 'ced_rnx_return_minimum_amount', false );

			// Return Request at order detail page.
			$ced_rnx_return = get_option( 'ced_rnx_return_enable', false );
			if ( 'yes' === $ced_rnx_return ) {
				if ( 'on' === $ced_rnx_enable_time_policy ) {
					if ( strtotime( current_time( 'h:i A' ) ) < strtotime( $ced_rnx_from_time ) || strtotime( current_time( 'h:i A' ) ) > strtotime( $ced_rnx_to_time ) ) {
						return;
					}
				}

					$order_id = $order->get_id();

				$statuses      = get_option( 'ced_rnx_return_order_status', array() );
				$order_status  = 'wc-' . $order->get_status();
				$product_datas = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_product', true );
				if ( isset( $product_datas ) && ! empty( $product_datas ) ) {
					?>
					<h2><?php esc_html_e( 'Refund Requested Product', 'woocommerce-refund-and-exchange' ); ?></h2>
					<?php

					$request_status = true;
					foreach ( $product_datas as $key => $product_data ) {
						$date        = date_create( $key );
						$date_format = get_option( 'date_format' );
						$date        = date_format( $date, $date_format );
						?>
						<p><?php esc_html_e( 'Following product Refund request made on', 'woocommerce-refund-and-exchange' ); ?> <b><?php echo $date; ?>.</b></p>
						<table class="shop_table order_details">
							<thead>
								<tr>
									<th class="product-name"><?php esc_html_e( 'Product', 'woocommerce-refund-and-exchange' ); ?></th>
									<th class="product-total"><?php esc_html_e( 'Total', 'woocommerce-refund-and-exchange' ); ?></th>
								</tr>
							</thead>
							<tbody>
							<?php
							$return_products = $product_data['products'];
							foreach ( $order->get_items() as $item_id => $item ) {
								foreach ( $return_products as $return_product ) {
									if ( isset( $return_product['item_id'] ) ) {
										if ( $return_product['item_id'] == $item_id ) {
											?>
										<tr>
											<td class="product-name">
											<?php
											$product = apply_filters( 'woocommerce_order_item_product', $item->get_product(), $item );
											$is_visible        = $product && $product->is_visible();
											$product_permalink = apply_filters( 'woocommerce_order_item_permalink', $is_visible ? $product->get_permalink( $item ) : '', $item, $order );

											echo $product_permalink ? sprintf( '<a href="%s">%s</a>', $product_permalink, $item['name'] ) : $item['name'];
											echo '<strong class="product-quantity">' . sprintf( '&times; %s', $return_product['qty'] ) . '</strong>';

											do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order );

												wc_display_item_meta( $item );
												wc_display_item_downloads( $item );

											do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order );
											?>
											</td>
											<td class="product-total">
											<?php
											echo ced_rnx_format_price( $return_product['price'] * $return_product['qty'] );
											?>
											</td>
											</tr>
											<?php
										}
									}
								}
							}
							?>
							<tr>
								<th scope="row"><?php esc_html_e( 'Refund Amount', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php echo ced_rnx_format_price( $product_data['amount'] ); ?></th>
							</tr>
							<?php
							$added_fees = wps_wrma_get_meta_data( $order_id, 'ced_rnx_return_added_fee', true );
							if ( isset( $added_fees ) ) {
								if ( is_array( $added_fees ) ) {
									foreach ( $added_fees as $da => $added_fee ) {
										if ( ! empty( $added_fee ) ) {
											if ( $da == $key ) {
												?>
												<tr>
													<th colspan="2"><?php esc_html_e( 'Extra Cost', 'woocommerce-refund-and-exchange' ); ?></th>
												</tr>
												<?php
												foreach ( $added_fee as $fee ) {
													?>
													<tr>
														<th><?php echo $fee['text']; ?></th>
														<td><?php echo ced_rnx_format_price( $fee['val'] ); ?></td>
													</tr>
													<?php
													$product_data['amount'] -= $fee['val'];
												}
											}
										}
									}
									?>
									<tr>
								<th scope="row"><?php esc_html_e( 'Total Refund Amount', 'woocommerce-refund-and-exchange' ); ?></th>
								<th><?php echo ced_rnx_format_price( $product_data['amount'] ); ?></th>
							</tr>
									<?php
								}
							}
							?>
							</tbody>
						</table>	
						<?php

						if ( in_array( $order_status, $statuses ) ) {
							if ( 'pending' === $product_data['status'] ) {
								$request_status = false;

									$order      = new WC_Order( $order );
									$order_id   = $order->get_id();
									$order_date = date_i18n( 'F j, Y', strtotime( $order->get_date_created() ) );

								$today_date  = time(); // Or your date as well.
								$order_date  = strtotime( $order_date );
								$days        = $today_date - $order_date;
								$day_diff    = floor( $days / ( 60 * 60 * 24 ) );
								$day_allowed = get_option( 'ced_rnx_return_days', false );
								if ( isset( $ced_rnx_catalog_refund_days ) && $ced_rnx_catalog_refund_days != 0 && 'yes' != $refund_button_hide ) {
									if ( $ced_rnx_catalog_refund_days >= $day_diff ) {
										if ( $ced_rnx_return_button_show ) {
											$ced_rnx_return_button_show = false;
											$ced_rnx_pages              = get_option( 'ced_rnx_pages' );
											$page_id                    = $ced_rnx_pages['pages']['ced_return_from'];
											$return_url                 = get_permalink( $page_id );
											?>
											<form action="<?php echo esc_html( $return_url . $order_id ); ?>" method="post">
												<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
												<p>
													<input type="submit" class="btn button" value="<?php esc_html_e( 'Update Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_update_return_request">
												</p>
											</form>
											<?php
										}
									}
								} elseif ( $day_allowed >= $day_diff && ! empty( $day_allowed ) && 'yes' !== $refund_button_hide ) {
									if ( $ced_rnx_return_button_show ) {
										$ced_rnx_return_button_show = false;
										$ced_rnx_pages              = get_option( 'ced_rnx_pages' );
										$page_id                    = $ced_rnx_pages['pages']['ced_return_from'];
										$return_url                 = get_permalink( $page_id );
										?>
											<form action="<?php echo esc_html( $return_url . $order_id ); ?>" method="post">
												<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
												<p>
													<input type="submit" class="btn button" value="<?php esc_html_e( 'Update Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_update_return_request">
												</p>
											</form>
											<?php
									}
								}
							}
						}
						if ( 'complete' === $product_data['status'] ) {
							$appdate = date_create( $product_data['approve_date'] );
							$format  = get_option( 'date_format' );
							$appdate = date_format( $appdate, $format );
							?>
							<p><?php esc_html_e( 'Above product Refund request is approved on', 'woocommerce-refund-and-exchange' ); ?> <b><?php echo $appdate; ?>.</b></p>
							<?php
						}

						if ( 'cancel' === $product_data['status'] ) {
							$appdate = date_create( $product_data['cancel_date'] );
							$format  = get_option( 'date_format' );
							$appdate = date_format( $appdate, $format );
							?>
							<p><?php esc_html_e( 'Above product Refund request is cancelled on', 'woocommerce-refund-and-exchange' ); ?> <b><?php echo $appdate; ?>.</b></p>
							<?php
						}
					}

					$statuses     = get_option( 'ced_rnx_return_order_status', array() );
					$order_status = 'wc-' . $order->get_status();
					if ( in_array( $order_status, $statuses ) && 'yes' !== $refund_button_hide ) {
						if ( $request_status ) {

								$order_id   = $order->get_id();
								$order_date = date_i18n( 'F j, Y', strtotime( $order->get_date_created() ) );

							$today_date  = time(); // or your date as well.
							$order_date  = strtotime( $order_date );
							$days        = $today_date - $order_date;
							$day_diff    = floor( $days / ( 60 * 60 * 24 ) );
							$day_allowed = get_option( 'ced_rnx_return_days', false );
							if ( isset( $ced_rnx_catalog_refund_days ) && 0 != $ced_rnx_catalog_refund_days ) {
								if ( $ced_rnx_catalog_refund_days >= $day_diff ) {
									$ced_rnx_pages = get_option( 'ced_rnx_pages' );
									$page_id       = $ced_rnx_pages['pages']['ced_return_from'];
									$return_url    = get_permalink( $page_id );
									if ( isset( $return_min_amount ) && ! empty( $return_min_amount ) ) {
										if ( $return_min_amount <= $order_total ) {
											if ( $ced_rnx_next_return ) {
												if ( $ced_rnx_return_button_show ) {
													$ced_rnx_return_button_show = false;
													?>
													<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
														<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
														<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
													</form>
													<?php
												}
											}
										}
									} elseif ( $ced_rnx_next_return ) {
										if ( $ced_rnx_return_button_show ) {

											$ced_rnx_return_button_show = false;
											?>
												<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
													<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
													<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
												</form>
												<?php
										}
									}
								}
							} elseif ( $day_allowed >= $day_diff && ! empty( $day_allowed ) ) {
									$ced_rnx_pages = get_option( 'ced_rnx_pages' );
									$page_id       = $ced_rnx_pages['pages']['ced_return_from'];
									$return_url    = get_permalink( $page_id );
								if ( isset( $return_min_amount ) && ! empty( $return_min_amount ) ) {
									if ( $return_min_amount <= $order_total ) {
										if ( $ced_rnx_next_return ) {
											if ( $ced_rnx_return_button_show ) {

												$ced_rnx_return_button_show = false;
												?>
													<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
														<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
														<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
													</form>
													<?php
											}
										}
									}
								} elseif ( $ced_rnx_next_return ) {

									if ( $ced_rnx_return_button_show ) {

										$ced_rnx_return_button_show = false;
										?>
												<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
													<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
													<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
												</form>
											<?php
									}
								}
							}
						}
					}
				}

				if ( in_array( $order_status, $statuses ) && 'yes' !== $refund_button_hide ) {

						$order_id   = $order->get_id();
						$order_date = date_i18n( 'F j, Y', strtotime( $order->get_date_created() ) );

					$today_date = date_i18n( 'F j, Y' );
					$order_date = strtotime( $order_date );
					$today_date = strtotime( $today_date );

					$days        = $today_date - $order_date;
					$day_diff    = floor( $days / ( 60 * 60 * 24 ) );
					$day_allowed = get_option( 'ced_rnx_return_days', false );
					if ( isset( $ced_rnx_catalog_refund_days ) && 0 != $ced_rnx_catalog_refund_days ) {
						if ( $ced_rnx_catalog_refund_days >= $day_diff ) {
							$ced_rnx_pages = get_option( 'ced_rnx_pages' );
							$page_id       = $ced_rnx_pages['pages']['ced_return_from'];
							$return_url    = get_permalink( $page_id );
							if ( isset( $return_min_amount ) && ! empty( $return_min_amount ) ) {
								if ( $return_min_amount <= $order_total ) {
									if ( $ced_rnx_next_return ) {
										if ( $ced_rnx_return_button_show ) {

											$ced_rnx_return_button_show = false;

											?>
											<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
												<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
												<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
											</form>
											<?php
										}
									}
								}
							} elseif ( $ced_rnx_next_return ) {
								if ( $ced_rnx_return_button_show ) {
									$ced_rnx_return_button_show = false;

									$action_url = add_query_arg( 'order_id', $order_id, $return_url );
									?>
										<form action="<?php echo esc_html( $action_url ); ?>" method="post">
											<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
											<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
										</form>
										<?php
								}
							}
						}
					} elseif ( $day_allowed >= $day_diff && 0 != $day_allowed ) {
							$ced_rnx_pages = get_option( 'ced_rnx_pages' );
							$page_id = $ced_rnx_pages['pages']['ced_return_from'];
							$return_url = get_permalink( $page_id );
						if ( isset( $return_min_amount ) && ! empty( $return_min_amount ) ) {
							if ( $return_min_amount <= $order_total ) {
								if ( $ced_rnx_next_return ) {
									if ( $ced_rnx_return_button_show ) {

										$ced_rnx_return_button_show = false;
										?>
											<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $return_url ) ); ?>" method="post">
												<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
												<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
											</form>
											<?php
									}
								}
							}
						} elseif ( $ced_rnx_next_return ) {
							if ( $ced_rnx_return_button_show ) {
								$ced_rnx_return_button_show = false;
								?>
										<form action="<?php echo add_query_arg( 'order_id', $order_id, $return_url ); ?>" method="post">
											<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
											<p><input type="submit" class="btn button" value="<?php esc_html_e( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?>" name="ced_new_return_request"></p>
										</form>
									<?php
							}
						}
					}
				}
			}

			$ced_rnx_pages         = get_option( 'ced_rnx_pages' );
			$cancel_page_id        = $ced_rnx_pages['pages']['ced_cancel_request_from'];
			$cancel_form_url       = get_permalink( $cancel_page_id );
			$cancel_enable         = get_option( 'ced_rnx_cancel_enable', '' );
			$cancel_product_enable = get_option( 'ced_rnx_cancel_order_product_enable', '' );
			$cancel_order_status   = get_option( 'ced_rnx_cancel_order_status', array() );
			$cancel_button_text    = get_option( 'ced_rnx_order_cancel_text', '' );
			$cancel_button_text    = ! empty( $cancel_button_text ) ? $cancel_button_text : 'Cancel Request';

			if ( isset( $cancel_product_enable ) && 'yes' === $cancel_enable && 'yes' === $cancel_product_enable && $ced_rnx_cancel_button_show ) {
				if ( in_array( $order_status, $cancel_order_status ) ) {
					?>
					<form action="<?php echo esc_html( add_query_arg( 'order_id', $order_id, $cancel_form_url ) ); ?>" method="post">
						<input type="hidden" value="<?php echo esc_html( $order_id ); ?>" name="order_id">
						<p><input type="submit" class="btn button" value="<?php echo esc_html( $cancel_button_text ); ?>" name="ced_rnx_new_return_request"></p>
					</form>
					<?php
				}
			}
		}
	}
	new CED_rnx_order_return();
}

?>
