<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link  https://wpswings.com/
 * @since 1.0.0
 *
 * @package    woocommerce-refund-and-exchange
 * @subpackage woocommerce-refund-and-exchange/includes/wcblocks
 */

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

/**
 * Extend the RMA Wallet system
 */
final class Ced_Wallet_Payments_Blocks extends AbstractPaymentMethodType {

	/**
	 * The gateway instance.
	 *
	 * @var Wps_Rma_Wallet_Gateway
	 */
	private $gateway;

	/**
	 * Payment method name/id/slug.
	 *
	 * @var string
	 */
	protected $name = 'wallet';

	/**
	 * Extend the RMA Wallet system function
	 *
	 * @return void
	 */
	public function initialize() {
		$this->settings = get_option( 'woocommerce_wallet_gateway_settings', array() );
		$this->gateway  = new WC_Wallet_Gateway();
	}
	/**
	 * Extend the RMA Wallet system function
	 *
	 * @return boolean
	 */
	public function is_active() {
		return $this->gateway->is_available();
	}

	/**
	 * Extend the RMA Wallet system function
	 *
	 * @return array
	 */
	public function get_payment_method_script_handles() {
		$script_path       = '/blockassets/js/frontend/blocks.js';
		$script_asset_path = CED_REFUND_N_EXCHANGE_URL . 'blockassets/js/frontend/blocks.asset.php';

		$script_asset      = file_exists( $script_asset_path )
		? require $script_asset_path
		: array(
			'dependencies' => array(),
			'version'      => '1.2.0',
		);
		$script_url        = CED_REFUND_N_EXCHANGE_URL . $script_path;

		wp_register_script(
			'ced-wallet-payments-blocks',
			$script_url,
			$script_asset['dependencies'],
			$script_asset['version'],
			true
		);

		if ( function_exists( 'wp_set_script_translations' ) ) {
			wp_set_script_translations( 'ced-wallet-payments-blocks', 'woocommerce-refund-and-exchange', CED_REFUND_N_EXCHANGE_DIRPATH . 'languages/' );
		}

		return array( 'ced-wallet-payments-blocks' );
	}

	/**
	 * Returns an array of key=>value pairs of data made available to the payment methods script.
	 *
	 * @return array
	 */
	public function get_payment_method_data() {
		return array(
			'title'       => $this->get_setting( 'title' ),
			'description' => $this->get_setting( 'description' ),
			'supports'    => array_filter( $this->gateway->supports, array( $this->gateway, 'supports' ) ),
		);
	}
}
