<?php
/**
 * The common functionality of the plugin.
 *
 * @link       https://wpswings.com/
 * @since      1.0.0
 *
 * @package    woocommerce-refund-and-exchange
 * @subpackage woocommerce-refund-and-exchange/template
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$current_user_id = get_current_user_id();
if ( $current_user_id > 0 ) {
	$myaccount_page = get_option( 'woocommerce_myaccount_page_id' );
	$myaccount_page_url = get_permalink( $myaccount_page );
	wp_safe_redirect( $myaccount_page_url );
	exit;
}

get_header( 'shop' );

/**
 * Woocommerce_before_main_content hook.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
*/
do_action( 'woocommerce_before_main_content' );

/**
 * Woocommerce_after_main_content hook.
 *
 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
 */

$ced_main_wrapper_class  = get_option( 'ced_rnx_return_exchange_class' );
$ced_child_wrapper_class = get_option( 'ced_rnx_return_exchange_child_class' );

?>
<div class="woocommerce woocommerce-account <?php echo esc_html( $ced_main_wrapper_class ); ?>">
	<div class="<?php echo wp_kses_post( $ced_child_wrapper_class ); ?>">
		<div id="ced_rnx_guest_request_form_wrapper">
			<h2>
			<?php
			$page_head = get_option( 'ced_rnx_return_exchange_page_heading_text', 'Refund/Exchange Request Form' );
			if ( '' == $page_head ) {
				$page_head = esc_html__( 'Refund/Exchange Request Form', 'woocommerce-refund-and-exchange' );
			}
			$return_product_form = $page_head;
			echo wp_kses_post( apply_filters( 'ced_rnx_return_product_form', $return_product_form ) );
			?>
			</h2>
			<?php
			if ( null != WC()->session->get( 'ced_rnx_notification' ) && '' != WC()->session->get( 'ced_rnx_notification' ) ) {
				?>
				<ul class="woocommerce-error">
						<li><strong><?php esc_html_e( 'ERROR', 'woocommerce-refund-and-exchange' ); ?></strong>: <?php echo esc_html( WC()->session->get( 'ced_rnx_notification' ) ); ?></li>
				</ul>
				<?php
				WC()->session->__unset( 'ced_rnx_notification' );
			}
			?>
			<form class="login ced_rnx_guest_form" method="post">
			<input type="hidden" name="get_nonce" value="<?php echo esc_html( wp_create_nonce( 'create_form_nonce' ) ); ?>">
				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
					<label for="username"><?php esc_html_e( 'Enter Order Id', 'woocommerce-refund-and-exchange' ); ?><span class="required"> *</span></label>
					<input type="text" id="order_id" name="order_id" class="woocommerce-Input woocommerce-Input--text input-text" required>
				</p>
				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
					<label for="username"><?php esc_html_e( 'Enter Order Email', 'woocommerce-refund-and-exchange' ); ?><span class="required"> *</span></label>
					<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="order_email" id="order_email" value="" required>
				</p>

				<p class="woocommerce-FormRow woocommerce-FormRow--wide form-row form-row-wide">
					<label for="username"><?php esc_html_e( 'Request Type', 'woocommerce-refund-and-exchange' ); ?><span class="required"> *</span></label>
					<select name="request_type">
						<?php
						if ( 'yes' === get_option( 'ced_rnx_return_enable' ) && 'yes' !== get_option( 'ced_rnx_return_button_hide_enable', false ) ) {
							?>
							<option value="refund"><?php echo esc_html__( 'Refund Request', 'woocommerce-refund-and-exchange' ); ?></option>
							<?php
						}
						if ( 'yes' === get_option( 'ced_rnx_exchange_enable' ) && 'yes' !== get_option( 'ced_rnx_exchange_button_hide_enable', false ) ) {
							?>
							<option value="exchange"><?php echo esc_html__( 'Exchange Request', 'woocommerce-refund-and-exchange' ); ?></option>
							<?php
						}
						if ( 'yes' === get_option( 'ced_rnx_cancel_enable' ) && 'yes' === get_option( 'ced_rnx_cancel_order_product_enable' ) ) {
							?>
							<option value="cancel"><?php echo esc_html__( 'Cancel Request', 'woocommerce-refund-and-exchange' ); ?></option>
							<?php
						}
						?>
					</select>
				</p>
				<p class="form-row">
					<input type="submit" value="<?php esc_html_e( 'Submit', 'woocommerce-refund-and-exchange' ); ?>" name="ced_rnx_order_id_submit" class="woocommerce-Button button">
				</p>
			</form>
		</div>
	</div>
</div>
<?php
do_action( 'woocommerce_after_main_content' );

get_footer( 'shop' );
?>
