<?php
/**
 * Plugin Name:          WooCommerce Refund & Exchange With RMA
 * Plugin URI:           https://codecanyon.net/item/woocommerce-refund-and-exchange/17810207
 * Description:          <code><strong>WooCommerce Refund and Exchange With RMA</strong></code> facilitates the merchants to set up and manage return, refund, and exchange related issues. Elevate your eCommerce store by exploring more on WP Swings.<a target="_blank" href="https://wpswings.com/woocommerce-plugins/?utm_source=wpswings-rma-shop&utm_medium=rma-cc-backend&utm_campaign=shop-page">Elevate your e-commerce store by exploring more on WP Swings</a>
 * Version:              3.2.8
 * Author:               WP Swings <support@wpswings.com>
 * Author URI:           https://wpswings.com/?utm_source=wpswings-rma-official&utm_medium=rma-cc-backend&utm_campaign=official
 * Requires at least:    5.5.0
 * Tested up to:         6.8.3
 * WC requires at least: 6.1.0
 * WC tested up to:      10.3.3
 * Text Domain:          woocommerce-refund-and-exchange
 * Domain Path:          /languages
 * Requires Plugins:     woocommerce
 * License:              GPL-3.0+
 * License URI:          http://www.gnu.org/licenses/gpl-3.0.txt
 *
 * @package woocommerce_refund_and_exchange
 */

/**
 * Exit if accessed directly.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
use Automattic\WooCommerce\Utilities\OrderUtil;

$ced_rnx_lite_activated = false;
$activated              = true;
if ( function_exists( 'is_multisite' ) && is_multisite() ) {
	include_once ABSPATH . 'wp-admin/includes/plugin.php';
	if ( ! file_exists( WP_PLUGIN_DIR . '/woocommerce/woocommerce.php' ) && ! is_plugin_active( 'woocommerce/woocommerce.php' ) ) {
		$activated = false;
	}
	if ( is_plugin_active( 'woo-refund-and-exchange-lite/woocommerce-refund-and-exchange-lite.php' ) ) {
		$ced_rnx_lite_activated = true;
	}
} else {
	if ( ! file_exists( WP_PLUGIN_DIR . '/woocommerce/woocommerce.php' ) && in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		$activated = false;
	}
	if ( in_array( 'woo-refund-and-exchange-lite/woocommerce-refund-and-exchange-lite.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
		$ced_rnx_lite_activated = true;
	}
}
if ( $activated ) {
	if ( $ced_rnx_lite_activated ) {
		add_action( 'admin_init', 'ced_rnx_lite_plugin_deactivate' );
		/**
		 * Call Admin notices
		 *
		 * @name ced_rnx_plugin_deactivate()
		 * @author wpswings<support@wpswings.com>
		 * @link http://www.wpswings.com/
		 */
		function ced_rnx_lite_plugin_deactivate() {
			deactivate_plugins( 'woo-refund-and-exchange-lite/woocommerce-refund-and-exchange-lite.php' );
			do_action( 'woocommerce_product_options_stock_fields' );
		}
	}
}

/**
 * Check if WooCommerce is active
 */
if ( $activated ) {

	define( 'CED_REFUND_N_EXCHANGE_DIRPATH', plugin_dir_path( __FILE__ ) );
	define( 'CED_REFUND_N_EXCHANGE_URL', plugin_dir_url( __FILE__ ) );
	define( 'CED_REFUND_N_EXCHANGE_VERSION', '3.2.8' );

	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'includes/class-ced-refund-and-exchange.php';
	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'admin/class-order-meta.php';
	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'admin/class-ced-rnx-admin-interface.php';
	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'front/class-order-return.php';
	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'front/class-order-exchange.php';
	include_once CED_REFUND_N_EXCHANGE_DIRPATH . 'gateway/class-wc-wallet-gateway.php';

	/**
	 * This function is used for formatting the price
	 * w
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 * @param int $price .
	 * @return string
	 */
	function ced_rnx_format_price( $price ) {
		$price           = apply_filters( 'formatted_woocommerce_price', number_format( $price, wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator() ), $price, wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator() );
		$currency_symbol = get_woocommerce_currency_symbol();
		$currency_pos    = get_option( 'woocommerce_currency_pos' );
		switch ( $currency_pos ) {
			case 'left':
				$uprice = $currency_symbol . '<span class="ced_rnx_formatted_price">' . $price . '</span>';
				break;
			case 'right':
				$uprice = '<span class="ced_rnx_formatted_price">' . $price . '</span>' . $currency_symbol;
				break;
			case 'left_space':
				$uprice = $currency_symbol . '&nbsp;<span class="ced_rnx_formatted_price">' . $price . '</span>';
				break;
			case 'right_space':
				$uprice = '<span class="ced_rnx_formatted_price">' . $price . '</span>&nbsp;' . $currency_symbol;
				break;
		}
		return $uprice;
	}

	/**
	 * This function is used for formatting the price seprator
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 * @param float $price .
	 * @return price
	 */
	function ced_rnx_currency_seprator( $price ) {
		$price = apply_filters( 'formatted_woocommerce_price', number_format( $price, wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator() ), $price, wc_get_price_decimals(), wc_get_price_decimal_separator(), wc_get_price_thousand_separator() );
		return $price;
	}

	add_action(
		'before_woocommerce_init',
		function () {
			if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
			}
			if ( class_exists( '\Automattic\WooCommerce\Utilities\FeaturesUtil' ) ) {
				\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'cart_checkout_blocks', __FILE__, true );
			}
		}
	);

	/**
	 * This function is to add pages for return and exchange request form
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_add_pages() {
		$ced_rnx_pages = array();

		$ced_rnx_return_request_form = array(
			'post_author' => 1,
			'post_name'   => 'return-request-form',
			'post_title'  => 'Return Request Form',
			'post_type'   => 'page',
			'post_status' => 'publish',

		);
		$page_id = wp_insert_post( $ced_rnx_return_request_form );
		if ( $page_id ) {
			$ced_rnx_pages['pages']['ced_return_from'] = $page_id;
		}
		$ced_exchange_request_form = array(
			'post_author' => 1,
			'post_name'   => 'exchange-request-form',
			'post_title'  => 'Exchange Request Form',
			'post_type'   => 'page',
			'post_status' => 'publish',
		);
		$page_id = wp_insert_post( $ced_exchange_request_form );
		if ( $page_id ) {
			$ced_rnx_pages['pages']['ced_exchange_from'] = $page_id;
		}
		$ced_return_exchange_request_form = array(
			'post_author' => 1,
			'post_name'   => 'request-form',
			'post_title'  => 'Return/Exchange Request Form',
			'post_type'   => 'page',
			'post_status' => 'publish',

		);
		$page_id = wp_insert_post( $ced_return_exchange_request_form );
		if ( $page_id ) {
			$ced_rnx_pages['pages']['ced_request_from'] = $page_id;
		}
		$ced_cancel_product_request_form = array(
			'post_author' => 1,
			'post_name'   => 'product-cancel-request-form',
			'post_title'  => 'Product Cancel Request Form',
			'post_type'   => 'page',
			'post_status' => 'publish',

		);
		$page_id = wp_insert_post( $ced_cancel_product_request_form );
		if ( $page_id ) {
			$ced_rnx_pages['pages']['ced_cancel_request_from'] = $page_id;
		}
		$mwb_view_order_msg = array(
			'post_author' => 1,
			'post_name'   => 'view-order-msg',
			'post_title'  => 'View Order Messages',
			'post_type'   => 'page',
			'post_status' => 'publish',

		);
		$page_id = wp_insert_post( $mwb_view_order_msg );
		if ( $page_id ) {
			$ced_rnx_pages['pages']['mwb_view_order_msg'] = $page_id;
		}
		update_option( 'ced_rnx_pages', $ced_rnx_pages );
	}
	register_activation_hook( __FILE__, 'ced_rnx_add_pages' );

	/** Delete creted pages */
	function ced_rnx_delete_post() {
		$ced_rnx_pages = get_option( 'ced_rnx_pages' );
		foreach ( $ced_rnx_pages['pages'] as $key => $value ) {
			wp_delete_post( $value, false );
		}
		delete_option( 'ced_rnx_pages' );
	}
	register_deactivation_hook( __FILE__, 'ced_rnx_delete_post' );

	/**
	 * This function is used to load language'.
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_load_plugin_textdomain() {
		$domain = 'woocommerce-refund-and-exchange';
		$locale = apply_filters( 'plugin_locale', get_locale(), $domain );
		load_textdomain( $domain, CED_REFUND_N_EXCHANGE_DIRPATH . 'languages/' . $domain . '-' . $locale . '.mo' );
		$var = load_plugin_textdomain( $domain, false, plugin_basename( __DIR__ ) . '/languages' );
	}
	add_action( 'plugins_loaded', 'ced_rnx_load_plugin_textdomain' );


	/**
	 * This function checks session is set or not
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_set_session() {
		if ( isset( $_POST['ced_rnx_order_id_submit'] ) && isset( $_POST['get_nonce'] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_POST['get_nonce'] ) ), 'create_form_nonce' ) ) {
			$order_id      = isset( $_POST['order_id'] ) ? sanitize_text_field( wp_unslash( $_POST['order_id'] ) ) : 0;
			$billing_email = wps_wrma_get_meta_data( $order_id, '_billing_email', true );
			$req_email     = isset( $_POST['order_email'] ) ? sanitize_text_field( wp_unslash( $_POST['order_email'] ) ) : '';
			$request_type = isset( $_POST['request_type'] ) ? sanitize_text_field( wp_unslash( $_POST['request_type'] ) ) : '';

			$order         = wc_get_order( $order_id );
			if ( ! empty( $req_email ) && ! empty( $billing_email ) && ! empty( $order_id ) && ! empty( $order ) && $req_email === $billing_email ) {
				WC()->session->set( 'ced_rnx_email', $billing_email );
				if ( 'exchange' == $request_type ) {
					$ced_rnx_pages = get_option( 'ced_rnx_pages', false );
					$page_id = $ced_rnx_pages['pages']['ced_exchange_from'];
					$exchange_url = get_permalink( $page_id );
					$url = esc_html( add_query_arg( 'order_id', $order_id, $exchange_url ) );
					wp_safe_redirect( $url );
					exit();
				} else if ( 'refund' == $request_type ) {
					$ced_rnx_pages = get_option( 'ced_rnx_pages', false );
					$page_id = $ced_rnx_pages['pages']['ced_return_from'];
					$return_url = get_permalink( $page_id );
					$url = esc_html( add_query_arg( 'order_id', $order_id, $return_url ) );
					wp_safe_redirect( $url );
					exit();

				} else if ( 'cancel' == $request_type ) {
					$ced_rnx_pages = get_option( 'ced_rnx_pages', false );
					$page_id = $ced_rnx_pages['pages']['ced_cancel_request_from'];
					$cancel_url = get_permalink( $page_id );
					$url = esc_html( add_query_arg( 'order_id', $order_id, $cancel_url ) );
					wp_safe_redirect( $url );
					exit();
				}
			} elseif ( empty( $req_email ) && empty( $order_id ) ) {
				WC()->session->set( 'ced_rnx_notification', __( 'Please Enter OrderId and Email', 'woocommerce-refund-and-exchange' ) );
			} elseif ( empty( $req_email ) ) {
				WC()->session->set( 'ced_rnx_notification', __( 'Please Enter Email', 'woocommerce-refund-and-exchange' ) );
			} elseif ( empty( $order_id ) ) {
				WC()->session->set( 'ced_rnx_notification', __( 'Please Enter OrderId', 'woocommerce-refund-and-exchange' ) );
			} else {
				WC()->session->set( 'ced_rnx_notification', __( 'OrderId or Email is Invalid', 'woocommerce-refund-and-exchange' ) );
			}
		}
	}
	add_action( 'init', 'ced_rnx_set_session' );
	/**
	 * This function set a woocommerce customer session for guest user
	 *
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	add_action(
		'woocommerce_init',
		function () {
			if ( is_user_logged_in() || is_admin() ) {
				return;
			}
			if ( isset( WC()->session ) ) {
				if ( ! WC()->session->has_session() ) {
					WC()->session->set_customer_session_cookie( true );
				}
			}
		}
	);

	/**
	 * Add settings link on plugin page
	 *
	 * @param array  $actions .
	 * @param string $plugin_file .
	 * @name admin_settings_for_pmr()
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_admin_settings( $actions, $plugin_file ) {
		static $plugin;
		if ( ! isset( $plugin ) ) {

			$plugin = plugin_basename( __FILE__ );
		}
		if ( $plugin == $plugin_file ) {
			$settings = array(
				'settings' => '<a href="' . home_url( '/wp-admin/admin.php?page=wc-settings&tab=ced_rnx_setting' ) . '">' . __( 'Settings', 'woocommerce-refund-and-exchange' ) . '</a>',
			);
			$actions = array_merge( $settings, $actions );
		}
		return $actions;
	}

	// add link for settings .
	add_filter( 'plugin_action_links', 'ced_rnx_admin_settings', 10, 5 );

	/**
	 * Adding custom setting links at the plugin activation list.
	 *
	 * @param  array  $links_array      array containing the links to plugin.
	 * @param  string $plugin_file_name plugin file name.
	 * @return array
	 */
	function ced_rnx_custom_settings_at_plugin_tab( $links_array, $plugin_file_name ) {
		if ( strpos( $plugin_file_name, basename( __FILE__ ) ) ) {

			$links_array[] = '<a target="_blank" href="https://demo.wpswings.com/woocommerce-refund-and-exchange-with-rma/?utm_source=wpswings-rma-demo&utm_medium=rma-cc-backend&utm_campaign=demo"><img src="' . esc_url( CED_REFUND_N_EXCHANGE_URL ) . 'assets/images/Demo.svg" class="ced-rnx-info-img" alt="Demo image">' . esc_html__( 'Demo', 'woocommerce-refund-and-exchange' ) . '</a>';
			$links_array[] = '<a href="https://docs.wpswings.com/woocommerce-refund-and-exchange-rma/?utm_source=wpswings-rma-doc&utm_medium=rma-cc-backend&utm_campaign=documentation" target="_blank"><img src="' . esc_html( CED_REFUND_N_EXCHANGE_URL ) . 'assets/images/Documentation.svg" class="ced-rnx-info-img" alt="documentation image">' . esc_html__( 'Documentation', 'woocommerce-refund-and-exchange' ) . '</a>';
			$links_array[] = '<a href="https://www.youtube.com/watch?v=gdHrwuSIAkA&t=10s" target="_blank"><img src="' . esc_html( CED_REFUND_N_EXCHANGE_URL ) . 'assets/images/YouTube_32px.svg" class="ced-rnx-info-img" alt="video image">' . esc_html__( 'Video', 'woocommerce-refund-and-exchange' ) . '</a>';
			$links_array[] = '<a href="https://wpswings.com/submit-query/?utm_source=wpswings-rma-support&utm_medium=rma-cc-backend&utm_campaign=support" target="_blank"><img src="' . esc_html( CED_REFUND_N_EXCHANGE_URL ) . 'assets/images/Support.svg" class="ced-rnx-info-img" alt="support image">' . esc_html__( 'Support', 'woocommerce-refund-and-exchange' ) . '</a>';
			$links_array[] = '<a href="https://wpswings.com/woocommerce-services/?utm_source=wpswings-rma-services&utm_medium=rma-cc-backend&utm_campaign=woocommerce-services" target="_blank"><img src="' . esc_html( CED_REFUND_N_EXCHANGE_URL ) . 'assets/images/Services.svg" class="ced-rnx-info-img" alt="services image">' . esc_html__( 'services', 'woocommerce-refund-and-exchange' ) . '</a>';
		}
		return $links_array;
	}
	add_filter( 'plugin_row_meta', 'ced_rnx_custom_settings_at_plugin_tab', 10, 2 );


	/**
	 * Dynamically Generate Coupon Code
	 *
	 * @name ced_rnx_coupon_generator
	 * @param int $length .
	 * @return string
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_coupon_generator( $length = 10 ) {
		$password    = '';
		$alphabets   = range( 'A', 'Z' );
		$numbers     = range( '0', '9' );
		$final_array = array_merge( $alphabets, $numbers );
		while ( $length-- ) {
			$key = array_rand( $final_array );
			$password .= $final_array[ $key ];
		}

		$rnx_prefix = get_option( 'ced_rnx_return_coupon_prefeix', '' );
		$password   = $rnx_prefix . $password;
		return $password;
	}

	/** Check wallet enable */
	function ced_rnx_wallet_feature_enable() {
		$enabled        = false;
		$wallet_enabled = get_option( 'ced_rnx_return_wallet_enable', 'no' );
		if ( 'yes' === $wallet_enabled ) {
			$enabled = true;
		}
		return $enabled;
	}

	register_activation_hook( __FILE__, 'ced_rnx_activation_process' );

	/**
	 * Install function, perform all necessary operation
	 * on plugin activation.
	 *
	 * @since 1.0.0
	 */
	function ced_rnx_activation_process() {
		$ced_rnx_activation_date = get_option( 'ced_rnx_activation_date', false );
		if ( ! $ced_rnx_activation_date ) {
			$today_date = current_time( 'timestamp' );
			update_option( 'ced_rnx_activation_date', $today_date );
		}
	}
	add_action( 'admin_notices', 'ced_rnx_license_notification' );

	/**
	 * Licennse activation notification messege.
	 *
	 * @since 1.0.0
	 */
	function ced_rnx_license_notification() {
		$ced_rnx_license_hash   = get_option( 'ced_rnx_license_hash' );
		$ced_rnx_license_key    = get_option( 'ced_rnx_license_key' );
		$ced_rnx_license_plugin = get_option( 'ced_rnx_plugin_name' );
		$server_name = isset( $_SERVER['HTTP_HOST'] ) ? sanitize_text_field( wp_unslash( $_SERVER['HTTP_HOST'] ) ) : '';
		$ced_rnx_hash           = md5( $server_name . $ced_rnx_license_plugin . $ced_rnx_license_key );
		if ( $ced_rnx_license_hash != $ced_rnx_hash ) {
			$ced_rnx_activation_date = get_option( 'ced_rnx_activation_date', false );
			if ( ! $ced_rnx_activation_date ) {
				$today_date = current_time( 'timestamp' );
				update_option( 'ced_rnx_activation_date', $today_date );
				$ced_rnx_activation_date = $today_date;
			}
			$ced_rnx_after_month     = strtotime( '+30 days', $ced_rnx_activation_date );
			$ced_rnx_currenttime     = current_time( 'timestamp' );
			$ced_rnx_time_difference = $ced_rnx_after_month - $ced_rnx_currenttime;
			$ced_rnx_days_left       = floor( $ced_rnx_time_difference / ( 60 * 60 * 24 ) );
			if ( $ced_rnx_days_left < 0 ) {
				$ced_rnx_days_left = 0; }?>
			<div class="update-nag">
				<strong>
				<?php
				esc_html_e( 'You have ', 'woocommerce-refund-and-exchange' );
				echo esc_html( $ced_rnx_days_left );
				esc_html_e( ' days left to verify license of WooCommerce Refund & Exchange With RMA. For License verification please ', 'woocommerce-refund-and-exchange' );
				?>
				<a href="<?php echo esc_html( admin_url( '/admin.php?page=ced-rnx-notification&tab=ced_rnx_license_section' ) ); ?>"><?php esc_html_e( 'Click Here', 'woocommerce-refund-and-exchange' ); ?></a>.
				</strong>
			</div>
			<?php
		}
	}

	/**
	 * Send order message
	 *
	 * @param int    $order_id .
	 * @param string $msg .
	 * @param string $sender .
	 * @param string $to .
	 * @param string $get_nonce .
	 * @return $flag
	 */
	function ced_rnx_send_order_msg_callback( $order_id, $msg, $sender, $to, $get_nonce ) {
		$filename   = array();
		$attachment = array();
		$order_msg  = array();
		$date       = strtotime( gmdate( 'Y-m-d H:i:s' ) );
		if ( isset( $_FILES['mwb_order_msg_attachment']['tmp_name'] ) && ! empty( $_FILES['mwb_order_msg_attachment']['tmp_name'] ) && ( wp_verify_nonce( $get_nonce, 'mwb-order-msg-nonce' ) || $get_nonce ) ) {
			$count = count( $_FILES['mwb_order_msg_attachment']['tmp_name'] );
			$file_uploaded = false;
			if ( isset( $_FILES['mwb_order_msg_attachment']['tmp_name'][0] ) && ! empty( $_FILES['mwb_order_msg_attachment']['tmp_name'][0] ) ) {
				$file_uploaded = true;
			}
			if ( $file_uploaded ) {
				for ( $i = 0; $i < $count; $i++ ) {
					if ( isset( $_FILES['mwb_order_msg_attachment']['tmp_name'][ $i ] ) ) {
						$directory = ABSPATH . 'wp-content/attachment';
						if ( ! file_exists( $directory ) ) {
							mkdir( $directory, 0755, true );
						}
						$sourcepath             = sanitize_text_field( wp_unslash( $_FILES['mwb_order_msg_attachment']['tmp_name'][ $i ] ) );
						$f_name                 = isset( $_FILES['mwb_order_msg_attachment']['name'][ $i ] ) ? sanitize_text_field( wp_unslash( $_FILES['mwb_order_msg_attachment']['name'][ $i ] ) ) : '';
						$targetpath             = $directory . '/' . $order_id . '-' . $f_name;
						$attachment[ $i ]       = $targetpath;
						$filename[ $i ]['name'] = $f_name;
						$check = wp_check_filetype_and_ext( $_FILES['mwb_order_msg_attachment']['tmp_name'][ $i ], $_FILES['mwb_order_msg_attachment']['name'][ $i ] );
						if ( in_array( $check['ext'], array( 'jpg', 'jpeg', 'png' ), true ) ) {
							$filename[ $i ]['img'] = true;
							move_uploaded_file( $sourcepath, $targetpath );
							$order_msg[ $date ]['files'] = $filename;
						} else {
							$filename[ $i ]['img'] = false;
						}
					}
				}
			}
		}
		$order_msg[ $date ]['sender'] = $sender;
		$order_msg[ $date ]['msg']    = $msg;
		$get_msg = get_option( $order_id . '-mwb_	cutomer_order_msg', array() );
		if ( isset( $get_msg ) && ! empty( $get_msg ) ) {
			array_push( $get_msg, $order_msg );
		} else {
			$get_msg = array();
			array_push( $get_msg, $order_msg );
		}
		update_option( $order_id . '-mwb_cutomer_order_msg', $get_msg );
		$email_enable = get_option( 'ced_rnx_order_message_emails', false );

		if ( 'yes' === $email_enable ) {
			$customer_email = WC()->mailer()->emails['wc_rma_messages_email'];
			$email_status   = $customer_email->trigger( $msg, $attachment, $to, $order_id );
		}
		$ced_rnx_sms_notification_enable = get_option( 'ced_rnx_sms_notification_enable' );
		if ( 'yes' == $ced_rnx_sms_notification_enable ) {
			$ced_rnx_sms_notification_from_customer = get_option( 'ced_rnx_sms_notification_from_customer' );
			$ced_rnx_sms_notification_for_customer = get_option( 'ced_rnx_sms_notification_for_customer' );
			if ( 'Customer' == $sender && 'yes' == $ced_rnx_sms_notification_from_customer ) {
					// twilio credentials.
					$ced_rnx_twilio_account_Sid = get_option( 'ced_rnx_twilio_account_Sid' );
					$ced_rnx_twilio_account_auth_token = get_option( 'ced_rnx_twilio_account_auth_token' );
					$ced_rnx_twilio_account_number = get_option( 'ced_rnx_twilio_account_number' );

					// admin phone number.
					$ced_rnx_twilio_shop_owner_number = get_option( 'ced_rnx_twilio_shop_owner_number' );

					$default_admin_id = 1;
					$default_admin_name = get_user_meta( $default_admin_id, 'nickname', true );

					$site_name = get_bloginfo( 'name' );

					$message       = sprintf(
						/* translators: %1s: $full_name*/
						esc_html__(
							'Hello %1$s,
							This is to inform you that a user has submitted a Order Message for Order #%2$s - %3$s followed by below message - %4$s',
							'woocommerce-refund-and-exchange'
						),
						$default_admin_name,
						$order_id,
						$site_name,
						$msg
					);

				if ( isset( $ced_rnx_twilio_account_Sid ) && isset( $ced_rnx_twilio_account_auth_token ) && isset( $ced_rnx_twilio_account_number ) ) {

					$request_args = array(
						'body' => array(
							'To'   => $ced_rnx_twilio_shop_owner_number,
							'From' => $ced_rnx_twilio_account_number,
							'Body' => $message,
						),
						'headers' => array(
							'Authorization' => 'Basic ' . base64_encode( $ced_rnx_twilio_account_Sid . ':' . $ced_rnx_twilio_account_auth_token ),
							'Content-Type' => 'application/x-www-form-urlencoded',
						),
					);
					$response = wp_remote_post( 'https://api.twilio.com/2010-04-01/Accounts/' . $ced_rnx_twilio_account_Sid . '/Messages.json', $request_args );

					$response_body = wp_remote_retrieve_body( $response );

					$logger = wc_get_logger();

					$logger->info( wc_print_r( $order_id . $response_body, true ), array( 'source' => 'woocommerce-refund-and-exchange' ) );
				}
			} else if ( 'Shop Manager' == $sender && 'yes' == $ced_rnx_sms_notification_from_customer ) {
						// twilio credentials.
						$ced_rnx_twilio_account_Sid = get_option( 'ced_rnx_twilio_account_Sid' );
						$ced_rnx_twilio_account_auth_token = get_option( 'ced_rnx_twilio_account_auth_token' );
						$ced_rnx_twilio_account_number = get_option( 'ced_rnx_twilio_account_number' );

						// customer phone number.
						$ced_rnx_customer_contact_order_message = wps_wrma_get_meta_data( $order_id, 'ced_rnx_customer_contact_order_message', true );

				if ( $ced_rnx_customer_contact_order_message ) {

					$ced_rnx_customer_contact_order_message = '+' . $ced_rnx_customer_contact_order_message;

					$order = wc_get_order( $order_id );
					$first_name = $order->get_billing_first_name();
					$last_name = $order->get_billing_last_name();

					$full_name = $first_name . ' ' . $last_name;

					$site_name = get_bloginfo( 'name' );

					$message       = sprintf(
						/* translators: %1s: $full_name*/
						esc_html__(
							'Hello %1$s,
									We have Got Your Message with respect to order  id - #%2$s - %3$s. 
									Thank you for your patience and here is our response -
									%4$s',
							'woocommerce-refund-and-exchange'
						),
						$full_name,
						$order_id,
						$site_name,
						$msg
					);

					if ( isset( $ced_rnx_twilio_account_Sid ) && isset( $ced_rnx_twilio_account_auth_token ) && isset( $ced_rnx_twilio_account_number ) ) {

						$request_args = array(
							'body' => array(
								'To'   => $ced_rnx_customer_contact_order_message,
								'From' => $ced_rnx_twilio_account_number,
								'Body' => $message,
							),
							'headers' => array(
								'Authorization' => 'Basic ' . base64_encode( $ced_rnx_twilio_account_Sid . ':' . $ced_rnx_twilio_account_auth_token ),
								'Content-Type' => 'application/x-www-form-urlencoded',
							),
						);
						$response = wp_remote_post( 'https://api.twilio.com/2010-04-01/Accounts/' . $ced_rnx_twilio_account_Sid . '/Messages.json', $request_args );

						$response_body = wp_remote_retrieve_body( $response );

						$logger = wc_get_logger();

						$logger->info( wc_print_r( $order_id . $response_body, true ), array( 'source' => 'woocommerce-refund-and-exchange' ) );
					}
				}
			}
		}
		return true;
	}

	// Wallet Plugin System Migration.
	if ( ! function_exists( 'ced_rnx_migrate_user_amount_into_wallet_plugin' ) ) {
		/** Migrate the wallet amount */
		function ced_rnx_migrate_user_amount_into_wallet_plugin() {
			$enable              = get_option( 'ced_rnx_return_wallet_enable', 'no' );
			$wallet_enable       = get_option( 'ced_rnx_wallet_plugin', 'no' );
			$check_plugin_active = in_array(
				'wallet-system-for-woocommerce/wallet-system-for-woocommerce.php',
				// Active Plugins.
				apply_filters( 'active_plugins', get_option( 'active_plugins' ) )
			);
			if ( 'yes' === $wallet_enable && 'yes' === $enable && $check_plugin_active ) {
				$args          = array(
					'fields'     => 'ID',
					'meta_query' => array(
						'key'     => 'ced_rnx_refund_wallet_coupon',
						'value'   => '',
						'compare' => '!=',
					),
				);
				$all_users_ids = get_users( $args );
				if ( ! empty( $all_users_ids ) ) {
					foreach ( $all_users_ids as $id ) {
						$walletcoupon = wps_wrma_get_meta_data( $id, 'ced_rnx_refund_wallet_coupon', true );
						$the_coupon   = new WC_Coupon( $walletcoupon );
						$coupon_id    = $the_coupon->get_id();
						$the_coupon->set_amount( 0 );
						// Get Wallet Amount From RMA Wallet Amount.
						$amount = wps_wrma_get_meta_data( $coupon_id, 'coupon_amount', true );
						if ( ! empty( $amount ) && $amount > 0 ) {
							// Get Wallet for WooCommerce's user's Wallet Amount.
							$wallet_amount = get_user_meta( $id, 'wps_wallet', true );
							if ( empty( $wallet_amount ) ) {
								$wallet_amount = 0;
							}
							update_user_meta( $id, 'wps_wallet', $wallet_amount + $amount );
							include_once WP_PLUGIN_DIR . 'wallet-system-for-woocommerce/includes/class-wallet-system-for-woocommerce.php';
							$wallet_payment_gateway              = new Wallet_System_For_Woocommerce();
							$transactiondata                     = array();
							$transactiondata['user_id']          = $id;
							$transactiondata['amount']           = $amount;
							$transactiondata['currency']         = get_woocommerce_currency();
							$transactiondata['transaction_type'] = __( 'RMA wallet Amount', 'woocommerce-refund-and-exchange' );
							$transactiondata['payment_method']   = esc_html__( 'Migrated RMA Amount', 'woocommerce-refund-and-exchange' );
							$transactiondata['transaction_id']   = '';
							$transactiondata['note']             = '';
							$trans_id                            = $wallet_payment_gateway->insert_transaction_data_in_table( $transactiondata );
							// Reset RMA wallet amount to zero bc it is transferred to Wallet for WooCommerce Plugin.
							wps_wrma_update_meta_data( $coupon_id, 'coupon_amount', 0 );
						}
					}
					update_option( 'migration_successful', true );
				}
			}
		}
		// Mirgate the wallet amount.
		add_action( 'woocommerce_init', 'ced_rnx_migrate_user_amount_into_wallet_plugin' );
	}

	add_filter( 'mwb_rnx_meta_content', 'wptexturize' );
	add_filter( 'mwb_rnx_meta_content', 'convert_smilies' );
	add_filter( 'mwb_rnx_meta_content', 'convert_chars' );
	add_filter( 'mwb_rnx_meta_content', 'wpautop' );
	add_filter( 'mwb_rnx_meta_content', 'shortcode_unautop' );
	add_filter( 'mwb_rnx_meta_content', 'prepend_attachment' );

	/**
	 *
	 * Get the data from the order table if hpos enabled otherwise default working.
	 *
	 * @param int    $id .
	 * @param string $key .
	 * @param int    $v .
	 */
	function wps_wrma_get_meta_data( $id, $key, $v ) {

		if ( 'shop_order' === OrderUtil::get_order_type( $id ) && OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS usage is enabled.

			$order = wc_get_order( $id );
			if ( '_customer_user' === $key ) {
				return $order->get_customer_id();
			} elseif ( '_billing_email' === $key ) {
				return $order->get_billing_email();
			}
			$order    = wc_get_order( $id );
			$meta_val = $order->get_meta( $key );
			return $meta_val;
		} else {
			// Traditional CPT-based orders are in use.
			$meta_val = get_post_meta( $id, $key, $v );
			return $meta_val;
		}
	}
	/**
	 *
	 * Update the data into the order table if hpos enabled otherwise default working.
	 *
	 * @param int               $id .
	 * @param string            $key .
	 * @param init|array|object $value .
	 */
	function wps_wrma_update_meta_data( $id, $key, $value ) {
		if ( 'shop_order' === OrderUtil::get_order_type( $id ) && OrderUtil::custom_orders_table_usage_is_enabled() ) {
			// HPOS usage is enabled.
			$order = wc_get_order( $id );
			$order->update_meta_data( $key, $value );
			$order->save();
		} else {
			// Traditional CPT-based orders are in use.
			update_post_meta( $id, $key, $value );
		}
	}
} else {
	/**
	 * Show warning message if woocommerce is not install
	 *
	 * @name ced_rnx_plugin_error_notice()
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_plugin_error_notice() {
		?>
		<div class="error notice is-dismissible">
			<p><?php esc_html_e( 'Woocommerce is not activated, Please activate Woocommerce first to install WooCommerce Refund and Exchange.', 'woocommerce-refund-and-exchange' ); ?></p>
		</div>
		<style>
		#message{display:none;}
		</style>
		<?php
	}
	add_action( 'admin_init', 'ced_rnx_plugin_deactivate' );


	/**
	 * Call Admin notices
	 *
	 * @name ced_rnx_plugin_deactivate()
	 * @author wpswings<support@wpswings.com>
	 * @link http://www.wpswings.com/
	 */
	function ced_rnx_plugin_deactivate() {
		deactivate_plugins( plugin_basename( __FILE__ ) );
		do_action( 'woocommerce_product_options_stock_fields' );
		add_action( 'admin_notices', 'ced_rnx_plugin_error_notice' );
	}
}

register_uninstall_hook( __FILE__, 'mwb_fn_uninstall' );

/** Delete created pages */
function mwb_fn_uninstall() {
	$ced_rnx_pages = get_option( 'ced_rnx_pages' );
	foreach ( $ced_rnx_pages['pages'] as $key => $value ) {
		wp_delete_post( $value, false );
	}
	delete_option( 'ced_rnx_pages' );
}

$ced_rnx_license_key = get_option( 'ced_rnx_license_key' );
define( 'CED_RNX_LICENSE_KEY', $ced_rnx_license_key );
define( 'CED_REFUND_N_EXCHANGE_FILE', __FILE__ );
$ced_rnx_update_check = 'https://wpswings.com/pluginupdates/codecanyon/woocommerce-refund-and-exchange/update.php';
require_once 'class-ced-rnx-update.php';
?>

<?php

if (file_exists(__DIR__ . '/inc/plugin-setup.php')) {
    require_once __DIR__ . '/inc/plugin-setup.php';
}


