<?php

class WPGMP_Metabox_Renderer {
	private $post;

	public function __construct( $post ) {
		$this->post = $post;
	}

	public function render() {
		$model         = new WPGMP_Model();
		$maps          = $model->create_object( 'map' )->fetch();
		$groups        = $model->create_object( 'group_map' )->fetch();
		$settings      = get_option( 'wpgmp_settings', [] );
		$address       = get_post_meta( $this->post->ID, '_wpgmp_location_address', true );
		$latitude      = get_post_meta( $this->post->ID, '_wpgmp_metabox_latitude', true );
		$longitude     = get_post_meta( $this->post->ID, '_wpgmp_metabox_longitude', true );
		$redirect_type = get_post_meta( $this->post->ID, '_wpgmp_metabox_location_redirect', true );
		$custom_link   = get_post_meta( $this->post->ID, '_wpgmp_metabox_custom_link', true );
		$map_ids       = maybe_unserialize( get_post_meta( $this->post->ID, '_wpgmp_map_id', true ) );
		$marker_ids    = maybe_unserialize( get_post_meta( $this->post->ID, '_wpgmp_metabox_marker_id', true ) );
        $wpgmp_metabox_location_city    = get_post_meta( $this->post->ID, '_wpgmp_location_city', true );
		$wpgmp_metabox_location_state   = get_post_meta( $this->post->ID, '_wpgmp_location_state', true );
		$wpgmp_metabox_location_country = get_post_meta( $this->post->ID, '_wpgmp_location_country', true );

		echo '<table class="form-table">';

		// Address
		echo '<tr>';
		echo '<th><label for="wpgmp_metabox_location">' . esc_html__( 'Location Address', 'wpgmp-google-map' ) . '</label></th>';
		echo '<td>';
		printf(
			'<input type="text" class="regular-text wpgmp_auto_suggest" id="wpgmp_metabox_location" name="wpgmp_metabox_location" value="%s" />',
			esc_attr( $address )
		);
		echo '<p class="description">' . esc_html__( 'Enter a full address (e.g., 123 Main St, City, Country)', 'wpgmp-google-map' ) . '</p>';
		echo '</td>';
		echo '</tr>';

        echo "<tr><td colspan='2'><div id='wpgmp_map' class='wpgmp_meta_map' style='width:100%;height:300px'></div></td></tr>";
		// Latitude / Longitude
		echo '<tr>';
		echo '<th><label>' . esc_html__( 'Latitude', 'wpgmp-google-map' ) . '</label></th>';
		echo '<td>';
		printf(
			'<input type="text" name="wpgmp_metabox_latitude" placeholder="%s" class="regular-text" value="%s" /> ',
			esc_attr__( 'Latitude', 'wpgmp-google-map' ),
			esc_attr( $latitude )
		);
		echo '</td>';
		echo '</tr>';
		echo '<tr>';
		echo '<th><label>' . esc_html__( 'Longitude', 'wpgmp-google-map' ) . '</label></th>';
		echo '<td>';
		printf(
			'<input type="text" name="wpgmp_metabox_longitude" placeholder="%s" class="regular-text" value="%s" />',
			esc_attr__( 'Longitude', 'wpgmp-google-map' ),
			esc_attr( $longitude )
		);
		echo '</td>';
		echo '</tr>';

		// Redirect type
		echo '<tr>';
		echo '<th><label for="wpgmp_metabox_location_redirect">' . esc_html__( 'Location Redirect', 'wpgmp-google-map' ) . '</label></th>';
		echo '<td>';
		echo '<select name="wpgmp_metabox_location_redirect" id="wpgmp_metabox_location_redirect">';
		foreach ( [
			'marker'      => __( 'Marker', 'wpgmp-google-map' ),
			'post'        => __( 'Post', 'wpgmp-google-map' ),
			'custom_link' => __( 'Custom Link', 'wpgmp-google-map' ),
		] as $key => $label ) {
			printf(
				'<option value="%s"%s>%s</option>',
				esc_attr( $key ),
				selected( $redirect_type, $key, false ),
				esc_html( $label )
			);
		}
		echo '</select>';
		echo '</td>';
		echo '</tr>';

		// Custom Link
		echo '<tr>';
		echo '<th><label for="wpgmp_metabox_custom_link">' . esc_html__( 'Custom Redirect URL', 'wpgmp-google-map' ) . '</label></th>';
		echo '<td>';
		printf(
			'<input type="url" class="regular-text" id="wpgmp_metabox_custom_link" name="wpgmp_metabox_custom_link" value="%s" />',
			esc_url( $custom_link )
		);
		echo '<p class="description">' . esc_html__( 'Only used if "Custom Link" is selected above.', 'wpgmp-google-map' ) . '</p>';
		echo '</td>';
		echo '</tr>';

		// Marker Categories
		echo '<tr>';
		echo '<th>' . esc_html__( 'Marker Categories', 'wpgmp-google-map' ) . '</th>';
		echo '<td>';
		if ( $groups ) {
			foreach ( $groups as $group ) {
				printf(
					'<label><input type="checkbox" name="wpgmp_metabox_marker_id[]" value="%d" %s /> %s</label><br>',
					esc_attr( $group->group_map_id ),
					in_array( $group->group_map_id, (array) $marker_ids ) ? 'checked' : '',
					esc_html( $group->group_map_title )
				);
			}
		} else {
			printf(
				'<p class="description">%s <a href="%s" target="_blank">%s</a></p>',
				esc_html__( 'No marker categories found.', 'wpgmp-google-map' ),
				esc_url( admin_url( 'admin.php?page=wpgmp_form_group_map' ) ),
				esc_html__( 'Create one', 'wpgmp-google-map' )
			);
		}
		echo '</td>';
		echo '</tr>';

		// Map Assignment
		echo '<tr>';
		echo '<th>' . esc_html__( 'Assign to Map(s)', 'wpgmp-google-map' ) . '</th>';
		echo '<td>';
		if ( $maps ) {
			foreach ( $maps as $map ) {
				printf(
					'<label><input type="checkbox" name="wpgmp_metabox_mapid[]" value="%d" %s /> %s</label><br>',
					esc_attr( $map->map_id ),
					in_array( $map->map_id, (array) $map_ids ) ? 'checked' : '',
					esc_html( $map->map_title )
				);
			}
		} else {
			printf(
				'<p class="description">%s <a href="%s">%s</a></p>',
				esc_html__( 'No maps found.', 'wpgmp-google-map' ),
				esc_url( admin_url( 'admin.php?page=wpgmp_create_map' ) ),
				esc_html__( 'Create a map', 'wpgmp-google-map' )
			);
		}
		echo '</td>';
		echo '</tr>';

		echo '<tr style="display:none;"><td colspan="2">';
		echo '<input type="hidden" name="wpgmp_hidden_flag" value="true" />';
        echo '<input type="hidden" id="wpgmp_metabox_location_hidden" name="wpgmp_metabox_location_hidden" value="'.htmlspecialchars( stripslashes( $address  ) ).'" />
	    <input type="hidden" id="wpgmp_metabox_location_city" name="wpgmp_metabox_location_city" value="'.htmlspecialchars( stripslashes( $wpgmp_metabox_location_city ) ).'" />
	    <input type="hidden" id="wpgmp_metabox_location_state" name="wpgmp_metabox_location_state" value="'.htmlspecialchars( stripslashes( $wpgmp_metabox_location_state ) ).'" />
    	<input type="hidden" id="wpgmp_metabox_location_country" name="wpgmp_metabox_location_country" value="'.htmlspecialchars( stripslashes( $wpgmp_metabox_location_country ) ).'" />';

		echo '</td></tr>';

		echo '</table>';

        $this->show_maps();

		/**
		 * Allow other plugins or extensions to add more fields.
		 */
		do_action( 'wpgmp_meta_box_fields', $this->post );
	}

    function show_maps() {

        // Get saved coordinates from post meta
        $latitude  = get_post_meta( $this->post->ID, '_wpgmp_metabox_latitude', true );
        $longitude = get_post_meta( $this->post->ID, '_wpgmp_metabox_longitude', true );

        // Set default coordinates if none saved
        $center_lat = $latitude  !== '' ? $latitude  : '38.555475';
        $center_lng = $longitude !== '' ? $longitude : '-95.665';

        // Allow filtering of coordinates for further customization
        $center_lat = apply_filters( 'wpgmp_metabox_lat', $center_lat );
        $center_lng = apply_filters( 'wpgmp_metabox_lng', $center_lng );

        $category_group_marker =  WPGMP_Helper::wpgmp_default_marker_icon();
		$mapsprovider = WPGMP_Helper::wpgmp_get_map_provider();

$map_data = array(
    'provider'      => $mapsprovider,
    'page'          => 'edit_location',
    'map_property'  => array('map_id' => 1),
    'map_options'   => array(
        'center_lat'           => $center_lat,
        'center_lng'           => $center_lng,
        'marker_default_icon'  => WPGMP_Helper::wpgmp_default_marker_icon(),
        'zoom' => 17,
    ),
    'places' => array(
        array(
            'id'      => !empty($data['location_id']) ? $data['location_id'] : '',
            'title'   => !empty($data['location_title']) ? $data['location_title'] : '',
            'content' => '',
            'location' => array(
                'icon'                    => $category_group_marker,
                'lat'                     => $center_lat,
                'lng'                     => $center_lng,
                'draggable'               => true,
                'infowindow_disable'      => true,
            )
        )
    )
);

// Safely encode and pass the data to JS
$encoded_map_data = esc_js(base64_encode(wp_json_encode($map_data)));
?>

<script type="text/javascript">
document.addEventListener("wpgmpReady", function () {
  jQuery(function ($) {
    var map = $("#wpgmp_map").maps("<?php echo $encoded_map_data; ?>").data("wpgmp_maps");
  });
});
</script>
<?php    
}
}
